//
//  PRBriCon.m
//  PRICE
//
//  Created by Riccardo Mottola on Thu Mar 3 2005.
//  Copyright (c) 2005-2010 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#include <math.h>
#import <AppKit/AppKit.h>

#include <limits.h>
#define HALF_CHAR (UCHAR_MAX >> 1)

#import "PRBriCon.h"


@implementation PRBriCon

- (PRImage *)filterImage:(PRImage *)image with:(NSArray *)parameters progressPanel:(PRCProgress *)progressPanel
{
    int   brightness;
    float contrast;

    /* interpret the parameters */
    brightness = [[parameters objectAtIndex:0] intValue];
    contrast = [[parameters objectAtIndex:1] floatValue];

    return [self adjustImage:image :brightness :contrast];
}

- (NSString *)actionName
{
    return @"Brightness & Contrast";
}

- (PRImage *)adjustImage :(PRImage *)srcImage :(int)bri :(float)con
{
    NSBitmapImageRep *srcImageRep;
    PRImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    int pixNum;
    BOOL isColor;
    int tempValue;
    int srcSamplesPerPixel;
    int destSamplesPerPixel;
    int srcBytesPerRow;
    int destBytesPerRow;
    

    /* get source image representation and associated information */
    srcImageRep = [srcImage bitmapRep];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    srcBytesPerRow = [srcImageRep bytesPerRow];
    srcSamplesPerPixel = [srcImageRep samplesPerPixel];
    pixNum = h * w;
    
    /* check bith depth and color/greyscale image */
    if ([srcImageRep hasAlpha])
    {
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColor = NO;
        }
        else
        {
            isColor = YES;
        }
    }
    else
    {
        if ([srcImageRep samplesPerPixel] == 1)
        {
            isColor = NO;
        }
        else
        {
            isColor = YES;
        }
    }
    
    /* allocate destination image and its representation */
    destImage = [[PRImage alloc] initWithSize:NSMakeSize(w, h)];
    if (isColor)
    {
        destSamplesPerPixel = 3;
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:destSamplesPerPixel
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:w*destSamplesPerPixel
                    bitsPerPixel:0];
    } else
    {
        destSamplesPerPixel = 1;
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:destSamplesPerPixel
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:w*destSamplesPerPixel
                    bitsPerPixel:0];
    }
    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    destBytesPerRow = [destImageRep bytesPerRow];
    
    if (isColor)
    {
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                tempValue = rint((float)(srcData[srcBytesPerRow*y + srcSamplesPerPixel*x] - HALF_CHAR + bri) * con + HALF_CHAR);
                if (tempValue > UCHAR_MAX)
                    tempValue = UCHAR_MAX;
                else if (tempValue < 0)
                    tempValue = 0;
                destData[destSamplesPerPixel*(y*w + x)] = tempValue;

                tempValue = rint((float)(srcData[srcBytesPerRow*y + srcSamplesPerPixel*x + 1] - HALF_CHAR + bri) * con + HALF_CHAR);
                if (tempValue > UCHAR_MAX)
                    tempValue = UCHAR_MAX;
                else if (tempValue < 0)
                    tempValue = 0;
                destData[destSamplesPerPixel*(y*w + x) + 1] = tempValue;

                tempValue = rint((float)(srcData[srcBytesPerRow*y + srcSamplesPerPixel*x + 2] - HALF_CHAR + bri) * con + HALF_CHAR);
                if (tempValue > UCHAR_MAX)
                    tempValue = UCHAR_MAX;
                else if (tempValue < 0)
                    tempValue = 0;
                destData[destSamplesPerPixel*(y*w + x) + 2] = tempValue;
            }
    } else
    {
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                tempValue = rint((float)(srcData[srcBytesPerRow*y + x] - HALF_CHAR + bri) * con + HALF_CHAR);
                if (tempValue > UCHAR_MAX)
                    tempValue = UCHAR_MAX;
                else if (tempValue < 0)
                    tempValue = 0;
                destData[y*w + x] = tempValue;
            }
    }
    
    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}

- (BOOL)displayProgress
{
    return NO;
}


@end
