"""
Base Class for all Widgets displaying/editing a Journal Entry (vEvent)
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: AbstractJournalView.py 82 2004-07-11 13:01:44Z henning $

import vcalendar
import broadcaster


class AbstractJournalView:
    def __init__(self, **kws):
        self._jourhandle = None
        self._journal = vcalendar.vEvent() #Empty Calendar Entry
        self.registerAtBroadcaster()
        
    def registerAtBroadcaster(self):
        "Register our Widget's Callback Handlers"
        broadcaster.Register(self.onContactsClose,
            source='Contacts', title='Closed')

    def onContactsClose(self):
        self.bind_journal(None)

    def bind_journal(self, journal):
        if journal is None:
            self._jourhandle = None
            self._journal = vcalendar.vEvent()
        else:
            self._jourhandle = journal.handle()
            self._journal = journal
    def cardhandle(self):
        return self._jourhandle
    def boundto(self):
        return self._journal
                
