# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Sku(Model):
    """SKU details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar family: SKU family name. Default value: "A" .
    :vartype family: str
    :param name: SKU name to specify whether the key vault is a standard vault
     or a premium vault. Possible values include: 'standard', 'premium'
    :type name: str or :class:`SkuName <azure.mgmt.keyvault.models.SkuName>`
    """

    _validation = {
        'family': {'required': True, 'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'SkuName'},
    }

    family = "A"

    def __init__(self, name):
        self.name = name
