# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.azurestackhci.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.azurestackhci.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.azurestackhci.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.azurestackhci.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "CustomLocation"
    :vartype type: str or ~azure.mgmt.azurestackhci.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "CustomLocation"
        :paramtype type: str or ~azure.mgmt.azurestackhci.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class GalleryDiskImage(_serialization.Model):
    """This is the disk image base class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_mb: This property indicates the size of the VHD to be created.
    :vartype size_in_mb: int
    """

    _validation = {
        "size_in_mb": {"readonly": True},
    }

    _attribute_map = {
        "size_in_mb": {"key": "sizeInMB", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.size_in_mb = None


class GalleryImageIdentifier(_serialization.Model):
    """This is the gallery image definition identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher: The name of the gallery image definition publisher. Required.
    :vartype publisher: str
    :ivar offer: The name of the gallery image definition offer. Required.
    :vartype offer: str
    :ivar sku: The name of the gallery image definition SKU. Required.
    :vartype sku: str
    """

    _validation = {
        "publisher": {"required": True},
        "offer": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
    }

    def __init__(self, *, publisher: str, offer: str, sku: str, **kwargs: Any) -> None:
        """
        :keyword publisher: The name of the gallery image definition publisher. Required.
        :paramtype publisher: str
        :keyword offer: The name of the gallery image definition offer. Required.
        :paramtype offer: str
        :keyword sku: The name of the gallery image definition SKU. Required.
        :paramtype sku: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class GalleryImages(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The gallery images resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
    :ivar container_id: Storage ContainerID of the storage container to be used for gallery image.
    :vartype container_id: str
    :ivar image_path: location of the image the gallery image should be created from.
    :vartype image_path: str
    :ivar os_type: Operating system type that the gallery image uses [Windows, Linux]. Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.azurestackhci.models.OperatingSystemTypes
    :ivar cloud_init_data_source: Datasource for the gallery image when provisioning with
     cloud-init [NoCloud, Azure]. Known values are: "NoCloud" and "Azure".
    :vartype cloud_init_data_source: str or ~azure.mgmt.azurestackhci.models.CloudInitDataSource
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.azurestackhci.models.HyperVGeneration
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.azurestackhci.models.GalleryImageIdentifier
    :ivar version: Specifies information about the gallery image version that you want to create or
     update.
    :vartype version: ~azure.mgmt.azurestackhci.models.GalleryImageVersion
    :ivar provisioning_state: Provisioning state of the gallery image. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhci.models.ProvisioningStateEnum
    :ivar status: The observed state of gallery images.
    :vartype status: ~azure.mgmt.azurestackhci.models.GalleryImageStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "container_id": {"key": "properties.containerId", "type": "str"},
        "image_path": {"key": "properties.imagePath", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "cloud_init_data_source": {"key": "properties.cloudInitDataSource", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "version": {"key": "properties.version", "type": "GalleryImageVersion"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "GalleryImageStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        container_id: Optional[str] = None,
        image_path: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        cloud_init_data_source: Optional[Union[str, "_models.CloudInitDataSource"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        version: Optional["_models.GalleryImageVersion"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
        :keyword container_id: Storage ContainerID of the storage container to be used for gallery
         image.
        :paramtype container_id: str
        :keyword image_path: location of the image the gallery image should be created from.
        :paramtype image_path: str
        :keyword os_type: Operating system type that the gallery image uses [Windows, Linux]. Known
         values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.azurestackhci.models.OperatingSystemTypes
        :keyword cloud_init_data_source: Datasource for the gallery image when provisioning with
         cloud-init [NoCloud, Azure]. Known values are: "NoCloud" and "Azure".
        :paramtype cloud_init_data_source: str or ~azure.mgmt.azurestackhci.models.CloudInitDataSource
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
         values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.azurestackhci.models.HyperVGeneration
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.azurestackhci.models.GalleryImageIdentifier
        :keyword version: Specifies information about the gallery image version that you want to create
         or update.
        :paramtype version: ~azure.mgmt.azurestackhci.models.GalleryImageVersion
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.container_id = container_id
        self.image_path = image_path
        self.os_type = os_type
        self.cloud_init_data_source = cloud_init_data_source
        self.hyper_v_generation = hyper_v_generation
        self.identifier = identifier
        self.version = version
        self.provisioning_state = None
        self.status = None


class GalleryImagesListResult(_serialization.Model):
    """List of gallery images.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.azurestackhci.models.GalleryImages]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryImages]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.GalleryImages"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.azurestackhci.models.GalleryImages]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class GalleryImageStatus(_serialization.Model):
    """The observed state of gallery images.

    :ivar error_code: GalleryImage provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status:
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhci.models.GalleryImageStatusProvisioningStatus
    :ivar download_status: The download status of the gallery image.
    :vartype download_status: ~azure.mgmt.azurestackhci.models.GalleryImageStatusDownloadStatus
    :ivar progress_percentage: The progress of the operation in percentage.
    :vartype progress_percentage: int
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "provisioning_status": {"key": "provisioningStatus", "type": "GalleryImageStatusProvisioningStatus"},
        "download_status": {"key": "downloadStatus", "type": "GalleryImageStatusDownloadStatus"},
        "progress_percentage": {"key": "progressPercentage", "type": "int"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.GalleryImageStatusProvisioningStatus"] = None,
        download_status: Optional["_models.GalleryImageStatusDownloadStatus"] = None,
        progress_percentage: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: GalleryImage provisioning error code.
        :paramtype error_code: str
        :keyword error_message: Descriptive error message.
        :paramtype error_message: str
        :keyword provisioning_status:
        :paramtype provisioning_status:
         ~azure.mgmt.azurestackhci.models.GalleryImageStatusProvisioningStatus
        :keyword download_status: The download status of the gallery image.
        :paramtype download_status: ~azure.mgmt.azurestackhci.models.GalleryImageStatusDownloadStatus
        :keyword progress_percentage: The progress of the operation in percentage.
        :paramtype progress_percentage: int
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message
        self.provisioning_status = provisioning_status
        self.download_status = download_status
        self.progress_percentage = progress_percentage


class GalleryImageStatusDownloadStatus(_serialization.Model):
    """The download status of the gallery image.

    :ivar download_size_in_mb: The downloaded sized of the image in MB.
    :vartype download_size_in_mb: int
    """

    _attribute_map = {
        "download_size_in_mb": {"key": "downloadSizeInMB", "type": "int"},
    }

    def __init__(self, *, download_size_in_mb: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword download_size_in_mb: The downloaded sized of the image in MB.
        :paramtype download_size_in_mb: int
        """
        super().__init__(**kwargs)
        self.download_size_in_mb = download_size_in_mb


class GalleryImageStatusProvisioningStatus(_serialization.Model):
    """GalleryImageStatusProvisioningStatus.

    :ivar operation_id: The ID of the operation performed on the gallery image.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the gallery image [Succeeded, Failed,
     InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhci.models.Status
    """

    _attribute_map = {
        "operation_id": {"key": "operationId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_id: The ID of the operation performed on the gallery image.
        :paramtype operation_id: str
        :keyword status: The status of the operation performed on the gallery image [Succeeded, Failed,
         InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
        :paramtype status: str or ~azure.mgmt.azurestackhci.models.Status
        """
        super().__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status


class GalleryImagesUpdateRequest(_serialization.Model):
    """The gallery images resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class GalleryImageVersion(_serialization.Model):
    """Specifies information about the gallery image version that you want to create or update.

    :ivar name: This is the version of the gallery image.
    :vartype name: str
    :ivar storage_profile: This is the storage profile of a Gallery Image Version.
    :vartype storage_profile: ~azure.mgmt.azurestackhci.models.GalleryImageVersionStorageProfile
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "storage_profile": {"key": "properties.storageProfile", "type": "GalleryImageVersionStorageProfile"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        storage_profile: Optional["_models.GalleryImageVersionStorageProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: This is the version of the gallery image.
        :paramtype name: str
        :keyword storage_profile: This is the storage profile of a Gallery Image Version.
        :paramtype storage_profile: ~azure.mgmt.azurestackhci.models.GalleryImageVersionStorageProfile
        """
        super().__init__(**kwargs)
        self.name = name
        self.storage_profile = storage_profile


class GalleryImageVersionStorageProfile(_serialization.Model):
    """This is the storage profile of a Gallery Image Version.

    :ivar os_disk_image: This is the OS disk image.
    :vartype os_disk_image: ~azure.mgmt.azurestackhci.models.GalleryOSDiskImage
    """

    _attribute_map = {
        "os_disk_image": {"key": "osDiskImage", "type": "GalleryOSDiskImage"},
    }

    def __init__(self, *, os_disk_image: Optional["_models.GalleryOSDiskImage"] = None, **kwargs: Any) -> None:
        """
        :keyword os_disk_image: This is the OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.azurestackhci.models.GalleryOSDiskImage
        """
        super().__init__(**kwargs)
        self.os_disk_image = os_disk_image


class GalleryOSDiskImage(GalleryDiskImage):
    """This is the OS disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_mb: This property indicates the size of the VHD to be created.
    :vartype size_in_mb: int
    """

    _validation = {
        "size_in_mb": {"readonly": True},
    }

    _attribute_map = {
        "size_in_mb": {"key": "sizeInMB", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class GuestAgent(ProxyResource):
    """Defines the GuestAgent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar credentials: Username / Password Credentials to provision guest agent.
    :vartype credentials: ~azure.mgmt.azurestackhci.models.GuestCredential
    :ivar provisioning_action: The guest agent provisioning action. Known values are: "install",
     "uninstall", and "repair".
    :vartype provisioning_action: str or ~azure.mgmt.azurestackhci.models.ProvisioningAction
    :ivar status: The guest agent status.
    :vartype status: str
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "credentials": {"key": "properties.credentials", "type": "GuestCredential"},
        "provisioning_action": {"key": "properties.provisioningAction", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        credentials: Optional["_models.GuestCredential"] = None,
        provisioning_action: Optional[Union[str, "_models.ProvisioningAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword credentials: Username / Password Credentials to provision guest agent.
        :paramtype credentials: ~azure.mgmt.azurestackhci.models.GuestCredential
        :keyword provisioning_action: The guest agent provisioning action. Known values are: "install",
         "uninstall", and "repair".
        :paramtype provisioning_action: str or ~azure.mgmt.azurestackhci.models.ProvisioningAction
        """
        super().__init__(**kwargs)
        self.credentials = credentials
        self.provisioning_action = provisioning_action
        self.status = None
        self.provisioning_state = None


class GuestAgentInstallStatus(_serialization.Model):
    """Defines the status of a guest agent installation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_uuid: Specifies the VM's unique SMBIOS ID.
    :vartype vm_uuid: str
    :ivar status: The installation status of the hybrid machine agent installation. Known values
     are: "Succeeded", "InProgress", and "Failed".
    :vartype status: str or ~azure.mgmt.azurestackhci.models.StatusTypes
    :ivar last_status_change: The time of the last status change.
    :vartype last_status_change: ~datetime.datetime
    :ivar agent_version: The hybrid machine agent full version.
    :vartype agent_version: str
    :ivar error_details: Details about the error state.
    :vartype error_details: list[~azure.mgmt.azurestackhci.models.ErrorDetail]
    """

    _validation = {
        "vm_uuid": {"readonly": True},
        "status": {"readonly": True},
        "last_status_change": {"readonly": True},
        "agent_version": {"readonly": True},
        "error_details": {"readonly": True},
    }

    _attribute_map = {
        "vm_uuid": {"key": "vmUuid", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "last_status_change": {"key": "lastStatusChange", "type": "iso-8601"},
        "agent_version": {"key": "agentVersion", "type": "str"},
        "error_details": {"key": "errorDetails", "type": "[ErrorDetail]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.vm_uuid = None
        self.status = None
        self.last_status_change = None
        self.agent_version = None
        self.error_details = None


class GuestAgentList(_serialization.Model):
    """List of GuestAgent.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of GuestAgent.
    :vartype next_link: str
    :ivar value: Array of GuestAgent. Required.
    :vartype value: list[~azure.mgmt.azurestackhci.models.GuestAgent]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[GuestAgent]"},
    }

    def __init__(self, *, value: List["_models.GuestAgent"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Url to follow for getting next page of GuestAgent.
        :paramtype next_link: str
        :keyword value: Array of GuestAgent. Required.
        :paramtype value: list[~azure.mgmt.azurestackhci.models.GuestAgent]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class GuestCredential(_serialization.Model):
    """Username / Password Credentials to connect to guest.

    :ivar username: The username to connect with the guest.
    :vartype username: str
    :ivar password: The password to connect with the guest.
    :vartype password: str
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: The username to connect with the guest.
        :paramtype username: str
        :keyword password: The password to connect with the guest.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password


class HardwareProfileUpdate(_serialization.Model):
    """HardwareProfile - Specifies the hardware settings for the virtual machine instance.

    :ivar vm_size: Known values are: "Default", "Standard_A2_v2", "Standard_A4_v2",
     "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
     "Standard_D32s_v3", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2",
     "Standard_DS13_v2", "Standard_K8S_v1", "Standard_K8S2_v1", "Standard_K8S3_v1",
     "Standard_K8S4_v1", "Standard_NK6", "Standard_NK12", "Standard_NV6", "Standard_NV12",
     "Standard_K8S5_v1", and "Custom".
    :vartype vm_size: str or ~azure.mgmt.azurestackhci.models.VmSizeEnum
    :ivar processors: number of processors for the virtual machine instance.
    :vartype processors: int
    :ivar memory_mb: RAM in MB for the virtual machine instance.
    :vartype memory_mb: int
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "processors": {"key": "processors", "type": "int"},
        "memory_mb": {"key": "memoryMB", "type": "int"},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[Union[str, "_models.VmSizeEnum"]] = None,
        processors: Optional[int] = None,
        memory_mb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_size: Known values are: "Default", "Standard_A2_v2", "Standard_A4_v2",
         "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
         "Standard_D32s_v3", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2",
         "Standard_DS13_v2", "Standard_K8S_v1", "Standard_K8S2_v1", "Standard_K8S3_v1",
         "Standard_K8S4_v1", "Standard_NK6", "Standard_NK12", "Standard_NV6", "Standard_NV12",
         "Standard_K8S5_v1", and "Custom".
        :paramtype vm_size: str or ~azure.mgmt.azurestackhci.models.VmSizeEnum
        :keyword processors: number of processors for the virtual machine instance.
        :paramtype processors: int
        :keyword memory_mb: RAM in MB for the virtual machine instance.
        :paramtype memory_mb: int
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.processors = processors
        self.memory_mb = memory_mb


class HttpProxyConfiguration(_serialization.Model):
    """HTTP Proxy configuration for the VM.

    :ivar http_proxy: The HTTP proxy server endpoint to use.
    :vartype http_proxy: str
    :ivar https_proxy: The HTTPS proxy server endpoint to use.
    :vartype https_proxy: str
    :ivar no_proxy: The endpoints that should not go through proxy.
    :vartype no_proxy: list[str]
    :ivar trusted_ca: Alternative CA cert to use for connecting to proxy servers.
    :vartype trusted_ca: str
    """

    _attribute_map = {
        "http_proxy": {"key": "httpProxy", "type": "str"},
        "https_proxy": {"key": "httpsProxy", "type": "str"},
        "no_proxy": {"key": "noProxy", "type": "[str]"},
        "trusted_ca": {"key": "trustedCa", "type": "str"},
    }

    def __init__(
        self,
        *,
        http_proxy: Optional[str] = None,
        https_proxy: Optional[str] = None,
        no_proxy: Optional[List[str]] = None,
        trusted_ca: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword http_proxy: The HTTP proxy server endpoint to use.
        :paramtype http_proxy: str
        :keyword https_proxy: The HTTPS proxy server endpoint to use.
        :paramtype https_proxy: str
        :keyword no_proxy: The endpoints that should not go through proxy.
        :paramtype no_proxy: list[str]
        :keyword trusted_ca: Alternative CA cert to use for connecting to proxy servers.
        :paramtype trusted_ca: str
        """
        super().__init__(**kwargs)
        self.http_proxy = http_proxy
        self.https_proxy = https_proxy
        self.no_proxy = no_proxy
        self.trusted_ca = trusted_ca


class HybridIdentityMetadata(ProxyResource):
    """Defines the HybridIdentityMetadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar resource_uid: The unique identifier for the resource.
    :vartype resource_uid: str
    :ivar public_key: The Public Key.
    :vartype public_key: str
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.azurestackhci.models.Identity
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "identity": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "resource_uid": {"key": "properties.resourceUid", "type": "str"},
        "public_key": {"key": "properties.publicKey", "type": "str"},
        "identity": {"key": "properties.identity", "type": "Identity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, resource_uid: Optional[str] = None, public_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_uid: The unique identifier for the resource.
        :paramtype resource_uid: str
        :keyword public_key: The Public Key.
        :paramtype public_key: str
        """
        super().__init__(**kwargs)
        self.resource_uid = resource_uid
        self.public_key = public_key
        self.identity = None
        self.provisioning_state = None


class HybridIdentityMetadataList(_serialization.Model):
    """List of HybridIdentityMetadata.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of HybridIdentityMetadata.
    :vartype next_link: str
    :ivar value: Array of HybridIdentityMetadata. Required.
    :vartype value: list[~azure.mgmt.azurestackhci.models.HybridIdentityMetadata]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[HybridIdentityMetadata]"},
    }

    def __init__(
        self, *, value: List["_models.HybridIdentityMetadata"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: Url to follow for getting next page of HybridIdentityMetadata.
        :paramtype next_link: str
        :keyword value: Array of HybridIdentityMetadata. Required.
        :paramtype value: list[~azure.mgmt.azurestackhci.models.HybridIdentityMetadata]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value is "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Literal["SystemAssigned"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The identity type. Default value is "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class InstanceViewStatus(_serialization.Model):
    """Instance view status.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.azurestackhci.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "_models.StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The status code.
        :paramtype code: str
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.azurestackhci.models.StatusLevelTypes
        :keyword display_status: The short localizable label for the status.
        :paramtype display_status: str
        :keyword message: The detailed status message, including for alerts and error messages.
        :paramtype message: str
        :keyword time: The time of the status.
        :paramtype time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time


class InterfaceDNSSettings(_serialization.Model):
    """InterfaceDNSSettings.

    :ivar dns_servers: List of DNS server IP Addresses for the interface.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword dns_servers: List of DNS server IP Addresses for the interface.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers


class IPConfiguration(_serialization.Model):
    """InterfaceIPConfiguration iPConfiguration in a network interface.

    :ivar name: Name - The name of the resource that is unique within a resource group. This name
     can be used to access the resource.
    :vartype name: str
    :ivar properties: InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
    :vartype properties: ~azure.mgmt.azurestackhci.models.IPConfigurationProperties
    """

    _validation = {
        "name": {"pattern": r"^[a-zA-Z0-9]$|^[a-zA-Z0-9][-._a-zA-Z0-9]{0,78}[_a-zA-Z0-9]$"},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "IPConfigurationProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.IPConfigurationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name - The name of the resource that is unique within a resource group. This
         name can be used to access the resource.
        :paramtype name: str
        :keyword properties: InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        :paramtype properties: ~azure.mgmt.azurestackhci.models.IPConfigurationProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class IPConfigurationProperties(_serialization.Model):
    """InterfaceIPConfigurationPropertiesFormat properties of IP configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar gateway: Gateway for network interface.
    :vartype gateway: str
    :ivar prefix_length: prefixLength for network interface.
    :vartype prefix_length: str
    :ivar private_ip_address: PrivateIPAddress - Private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar subnet: Subnet - Name of Subnet bound to the IP configuration.
    :vartype subnet: ~azure.mgmt.azurestackhci.models.IPConfigurationPropertiesSubnet
    """

    _validation = {
        "gateway": {"readonly": True},
        "prefix_length": {"readonly": True},
    }

    _attribute_map = {
        "gateway": {"key": "gateway", "type": "str"},
        "prefix_length": {"key": "prefixLength", "type": "str"},
        "private_ip_address": {"key": "privateIPAddress", "type": "str"},
        "subnet": {"key": "subnet", "type": "IPConfigurationPropertiesSubnet"},
    }

    def __init__(
        self,
        *,
        private_ip_address: Optional[str] = None,
        subnet: Optional["_models.IPConfigurationPropertiesSubnet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_ip_address: PrivateIPAddress - Private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword subnet: Subnet - Name of Subnet bound to the IP configuration.
        :paramtype subnet: ~azure.mgmt.azurestackhci.models.IPConfigurationPropertiesSubnet
        """
        super().__init__(**kwargs)
        self.gateway = None
        self.prefix_length = None
        self.private_ip_address = private_ip_address
        self.subnet = subnet


class IPConfigurationPropertiesSubnet(_serialization.Model):
    """Subnet - Name of Subnet bound to the IP configuration.

    :ivar id: ID - The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: ID - The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class IPPool(_serialization.Model):
    """IPPool.

    :ivar name: Name of the IP-Pool.
    :vartype name: str
    :ivar ip_pool_type: Type of the IP Pool [vm, vippool]. Known values are: "vm" and "vippool".
    :vartype ip_pool_type: str or ~azure.mgmt.azurestackhci.models.IPPoolTypeEnum
    :ivar start: Start of the IP address pool.
    :vartype start: str
    :ivar end: End of the IP address pool.
    :vartype end: str
    :ivar info:
    :vartype info: ~azure.mgmt.azurestackhci.models.IPPoolInfo
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "ip_pool_type": {"key": "ipPoolType", "type": "str"},
        "start": {"key": "start", "type": "str"},
        "end": {"key": "end", "type": "str"},
        "info": {"key": "info", "type": "IPPoolInfo"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ip_pool_type: Optional[Union[str, "_models.IPPoolTypeEnum"]] = None,
        start: Optional[str] = None,
        end: Optional[str] = None,
        info: Optional["_models.IPPoolInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the IP-Pool.
        :paramtype name: str
        :keyword ip_pool_type: Type of the IP Pool [vm, vippool]. Known values are: "vm" and "vippool".
        :paramtype ip_pool_type: str or ~azure.mgmt.azurestackhci.models.IPPoolTypeEnum
        :keyword start: Start of the IP address pool.
        :paramtype start: str
        :keyword end: End of the IP address pool.
        :paramtype end: str
        :keyword info:
        :paramtype info: ~azure.mgmt.azurestackhci.models.IPPoolInfo
        """
        super().__init__(**kwargs)
        self.name = name
        self.ip_pool_type = ip_pool_type
        self.start = start
        self.end = end
        self.info = info


class IPPoolInfo(_serialization.Model):
    """IPPoolInfo.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar used: Number of IP addresses allocated from the IP Pool.
    :vartype used: str
    :ivar available: Number of IP addresses available in the IP Pool.
    :vartype available: str
    """

    _validation = {
        "used": {"readonly": True},
        "available": {"readonly": True},
    }

    _attribute_map = {
        "used": {"key": "used", "type": "str"},
        "available": {"key": "available", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.used = None
        self.available = None


class LogicalNetworkPropertiesDhcpOptions(_serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network.
    Standard DHCP option for a subnet overrides logical network DHCP options.

    :ivar dns_servers: The list of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword dns_servers: The list of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers


class LogicalNetworks(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The logical network resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
    :ivar dhcp_options: DhcpOptions contains an array of DNS servers available to VMs deployed in
     the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
    :vartype dhcp_options: ~azure.mgmt.azurestackhci.models.LogicalNetworkPropertiesDhcpOptions
    :ivar subnets: Subnet - list of subnets under the logical network.
    :vartype subnets: list[~azure.mgmt.azurestackhci.models.Subnet]
    :ivar provisioning_state: Provisioning state of the logical network. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhci.models.ProvisioningStateEnum
    :ivar vm_switch_name: name of the network switch to be used for VMs.
    :vartype vm_switch_name: str
    :ivar status: The observed state of logical networks.
    :vartype status: ~azure.mgmt.azurestackhci.models.LogicalNetworkStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "dhcp_options": {"key": "properties.dhcpOptions", "type": "LogicalNetworkPropertiesDhcpOptions"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "vm_switch_name": {"key": "properties.vmSwitchName", "type": "str"},
        "status": {"key": "properties.status", "type": "LogicalNetworkStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        dhcp_options: Optional["_models.LogicalNetworkPropertiesDhcpOptions"] = None,
        subnets: Optional[List["_models.Subnet"]] = None,
        vm_switch_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
        :keyword dhcp_options: DhcpOptions contains an array of DNS servers available to VMs deployed
         in the logical network. Standard DHCP option for a subnet overrides logical network DHCP
         options.
        :paramtype dhcp_options: ~azure.mgmt.azurestackhci.models.LogicalNetworkPropertiesDhcpOptions
        :keyword subnets: Subnet - list of subnets under the logical network.
        :paramtype subnets: list[~azure.mgmt.azurestackhci.models.Subnet]
        :keyword vm_switch_name: name of the network switch to be used for VMs.
        :paramtype vm_switch_name: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.dhcp_options = dhcp_options
        self.subnets = subnets
        self.provisioning_state = None
        self.vm_switch_name = vm_switch_name
        self.status = None


class LogicalNetworksListResult(_serialization.Model):
    """LogicalNetworksListResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.azurestackhci.models.LogicalNetworks]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LogicalNetworks]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.LogicalNetworks"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.azurestackhci.models.LogicalNetworks]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogicalNetworkStatus(_serialization.Model):
    """The observed state of logical networks.

    :ivar error_code: LogicalNetwork provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status:
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhci.models.LogicalNetworkStatusProvisioningStatus
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "provisioning_status": {"key": "provisioningStatus", "type": "LogicalNetworkStatusProvisioningStatus"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.LogicalNetworkStatusProvisioningStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: LogicalNetwork provisioning error code.
        :paramtype error_code: str
        :keyword error_message: Descriptive error message.
        :paramtype error_message: str
        :keyword provisioning_status:
        :paramtype provisioning_status:
         ~azure.mgmt.azurestackhci.models.LogicalNetworkStatusProvisioningStatus
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message
        self.provisioning_status = provisioning_status


class LogicalNetworkStatusProvisioningStatus(_serialization.Model):
    """LogicalNetworkStatusProvisioningStatus.

    :ivar operation_id: The ID of the operation performed on the logical network.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the logical network [Succeeded, Failed,
     InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhci.models.Status
    """

    _attribute_map = {
        "operation_id": {"key": "operationId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_id: The ID of the operation performed on the logical network.
        :paramtype operation_id: str
        :keyword status: The status of the operation performed on the logical network [Succeeded,
         Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
        :paramtype status: str or ~azure.mgmt.azurestackhci.models.Status
        """
        super().__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status


class LogicalNetworksUpdateRequest(_serialization.Model):
    """The logical network resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class MarketplaceGalleryImages(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The marketplace gallery image resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
    :ivar container_id: Storage ContainerID of the storage container to be used for marketplace
     gallery image.
    :vartype container_id: str
    :ivar os_type: Operating system type that the gallery image uses [Windows, Linux]. Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.azurestackhci.models.OperatingSystemTypes
    :ivar cloud_init_data_source: Datasource for the gallery image when provisioning with
     cloud-init [NoCloud, Azure]. Known values are: "NoCloud" and "Azure".
    :vartype cloud_init_data_source: str or ~azure.mgmt.azurestackhci.models.CloudInitDataSource
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.azurestackhci.models.HyperVGeneration
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.azurestackhci.models.GalleryImageIdentifier
    :ivar version: Specifies information about the gallery image version that you want to create or
     update.
    :vartype version: ~azure.mgmt.azurestackhci.models.GalleryImageVersion
    :ivar provisioning_state: Provisioning state of the marketplace gallery image. Known values
     are: "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhci.models.ProvisioningStateEnum
    :ivar status: The observed state of marketplace gallery images.
    :vartype status: ~azure.mgmt.azurestackhci.models.MarketplaceGalleryImageStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "container_id": {"key": "properties.containerId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "cloud_init_data_source": {"key": "properties.cloudInitDataSource", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "version": {"key": "properties.version", "type": "GalleryImageVersion"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "MarketplaceGalleryImageStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        container_id: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        cloud_init_data_source: Optional[Union[str, "_models.CloudInitDataSource"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        version: Optional["_models.GalleryImageVersion"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
        :keyword container_id: Storage ContainerID of the storage container to be used for marketplace
         gallery image.
        :paramtype container_id: str
        :keyword os_type: Operating system type that the gallery image uses [Windows, Linux]. Known
         values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.azurestackhci.models.OperatingSystemTypes
        :keyword cloud_init_data_source: Datasource for the gallery image when provisioning with
         cloud-init [NoCloud, Azure]. Known values are: "NoCloud" and "Azure".
        :paramtype cloud_init_data_source: str or ~azure.mgmt.azurestackhci.models.CloudInitDataSource
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
         values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.azurestackhci.models.HyperVGeneration
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.azurestackhci.models.GalleryImageIdentifier
        :keyword version: Specifies information about the gallery image version that you want to create
         or update.
        :paramtype version: ~azure.mgmt.azurestackhci.models.GalleryImageVersion
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.container_id = container_id
        self.os_type = os_type
        self.cloud_init_data_source = cloud_init_data_source
        self.hyper_v_generation = hyper_v_generation
        self.identifier = identifier
        self.version = version
        self.provisioning_state = None
        self.status = None


class MarketplaceGalleryImagesListResult(_serialization.Model):
    """MarketplaceGalleryImagesListResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.azurestackhci.models.MarketplaceGalleryImages]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MarketplaceGalleryImages]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.MarketplaceGalleryImages"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.azurestackhci.models.MarketplaceGalleryImages]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MarketplaceGalleryImageStatus(_serialization.Model):
    """The observed state of marketplace gallery images.

    :ivar error_code: MarketplaceGalleryImage provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status:
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhci.models.MarketplaceGalleryImageStatusProvisioningStatus
    :ivar download_status: The download status of the gallery image.
    :vartype download_status:
     ~azure.mgmt.azurestackhci.models.MarketplaceGalleryImageStatusDownloadStatus
    :ivar progress_percentage: The progress of the operation in percentage.
    :vartype progress_percentage: int
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "provisioning_status": {"key": "provisioningStatus", "type": "MarketplaceGalleryImageStatusProvisioningStatus"},
        "download_status": {"key": "downloadStatus", "type": "MarketplaceGalleryImageStatusDownloadStatus"},
        "progress_percentage": {"key": "progressPercentage", "type": "int"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.MarketplaceGalleryImageStatusProvisioningStatus"] = None,
        download_status: Optional["_models.MarketplaceGalleryImageStatusDownloadStatus"] = None,
        progress_percentage: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: MarketplaceGalleryImage provisioning error code.
        :paramtype error_code: str
        :keyword error_message: Descriptive error message.
        :paramtype error_message: str
        :keyword provisioning_status:
        :paramtype provisioning_status:
         ~azure.mgmt.azurestackhci.models.MarketplaceGalleryImageStatusProvisioningStatus
        :keyword download_status: The download status of the gallery image.
        :paramtype download_status:
         ~azure.mgmt.azurestackhci.models.MarketplaceGalleryImageStatusDownloadStatus
        :keyword progress_percentage: The progress of the operation in percentage.
        :paramtype progress_percentage: int
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message
        self.provisioning_status = provisioning_status
        self.download_status = download_status
        self.progress_percentage = progress_percentage


class MarketplaceGalleryImageStatusDownloadStatus(_serialization.Model):
    """The download status of the gallery image.

    :ivar download_size_in_mb: The downloaded sized of the image in MB.
    :vartype download_size_in_mb: int
    """

    _attribute_map = {
        "download_size_in_mb": {"key": "downloadSizeInMB", "type": "int"},
    }

    def __init__(self, *, download_size_in_mb: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword download_size_in_mb: The downloaded sized of the image in MB.
        :paramtype download_size_in_mb: int
        """
        super().__init__(**kwargs)
        self.download_size_in_mb = download_size_in_mb


class MarketplaceGalleryImageStatusProvisioningStatus(_serialization.Model):
    """MarketplaceGalleryImageStatusProvisioningStatus.

    :ivar operation_id: The ID of the operation performed on the gallery image.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the gallery image [Succeeded, Failed,
     InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhci.models.Status
    """

    _attribute_map = {
        "operation_id": {"key": "operationId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_id: The ID of the operation performed on the gallery image.
        :paramtype operation_id: str
        :keyword status: The status of the operation performed on the gallery image [Succeeded, Failed,
         InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
        :paramtype status: str or ~azure.mgmt.azurestackhci.models.Status
        """
        super().__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status


class MarketplaceGalleryImagesUpdateRequest(_serialization.Model):
    """The marketplace gallery image resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class NetworkInterfaces(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The network interface resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
    :ivar ip_configurations: IPConfigurations - A list of IPConfigurations of the network
     interface.
    :vartype ip_configurations: list[~azure.mgmt.azurestackhci.models.IPConfiguration]
    :ivar mac_address: MacAddress - The MAC address of the network interface.
    :vartype mac_address: str
    :ivar dns_settings: DNS Settings for the interface.
    :vartype dns_settings: ~azure.mgmt.azurestackhci.models.InterfaceDNSSettings
    :ivar provisioning_state: Provisioning state of the network interface. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhci.models.ProvisioningStateEnum
    :ivar status: The observed state of network interfaces.
    :vartype status: ~azure.mgmt.azurestackhci.models.NetworkInterfaceStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[IPConfiguration]"},
        "mac_address": {"key": "properties.macAddress", "type": "str"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "InterfaceDNSSettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "NetworkInterfaceStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        ip_configurations: Optional[List["_models.IPConfiguration"]] = None,
        mac_address: Optional[str] = None,
        dns_settings: Optional["_models.InterfaceDNSSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
        :keyword ip_configurations: IPConfigurations - A list of IPConfigurations of the network
         interface.
        :paramtype ip_configurations: list[~azure.mgmt.azurestackhci.models.IPConfiguration]
        :keyword mac_address: MacAddress - The MAC address of the network interface.
        :paramtype mac_address: str
        :keyword dns_settings: DNS Settings for the interface.
        :paramtype dns_settings: ~azure.mgmt.azurestackhci.models.InterfaceDNSSettings
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.ip_configurations = ip_configurations
        self.mac_address = mac_address
        self.dns_settings = dns_settings
        self.provisioning_state = None
        self.status = None


class NetworkInterfacesListResult(_serialization.Model):
    """NetworkInterfacesListResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.azurestackhci.models.NetworkInterfaces]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterfaces]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkInterfaces"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.azurestackhci.models.NetworkInterfaces]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkInterfaceStatus(_serialization.Model):
    """The observed state of network interfaces.

    :ivar error_code: NetworkInterface provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status:
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhci.models.NetworkInterfaceStatusProvisioningStatus
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "provisioning_status": {"key": "provisioningStatus", "type": "NetworkInterfaceStatusProvisioningStatus"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.NetworkInterfaceStatusProvisioningStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: NetworkInterface provisioning error code.
        :paramtype error_code: str
        :keyword error_message: Descriptive error message.
        :paramtype error_message: str
        :keyword provisioning_status:
        :paramtype provisioning_status:
         ~azure.mgmt.azurestackhci.models.NetworkInterfaceStatusProvisioningStatus
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message
        self.provisioning_status = provisioning_status


class NetworkInterfaceStatusProvisioningStatus(_serialization.Model):
    """NetworkInterfaceStatusProvisioningStatus.

    :ivar operation_id: The ID of the operation performed on the network interface.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the network interface [Succeeded,
     Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhci.models.Status
    """

    _attribute_map = {
        "operation_id": {"key": "operationId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_id: The ID of the operation performed on the network interface.
        :paramtype operation_id: str
        :keyword status: The status of the operation performed on the network interface [Succeeded,
         Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
        :paramtype status: str or ~azure.mgmt.azurestackhci.models.Status
        """
        super().__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status


class NetworkInterfacesUpdateRequest(_serialization.Model):
    """The network interface resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class NetworkProfileUpdate(_serialization.Model):
    """NetworkProfile - describes the network update configuration the virtual machine instance.

    :ivar network_interfaces: NetworkInterfaces - list of network interfaces to be attached to the
     virtual machine instance.
    :vartype network_interfaces:
     list[~azure.mgmt.azurestackhci.models.NetworkProfileUpdateNetworkInterfacesItem]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkProfileUpdateNetworkInterfacesItem]"},
    }

    def __init__(
        self,
        *,
        network_interfaces: Optional[List["_models.NetworkProfileUpdateNetworkInterfacesItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interfaces: NetworkInterfaces - list of network interfaces to be attached to
         the virtual machine instance.
        :paramtype network_interfaces:
         list[~azure.mgmt.azurestackhci.models.NetworkProfileUpdateNetworkInterfacesItem]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class NetworkProfileUpdateNetworkInterfacesItem(_serialization.Model):
    """NetworkProfileUpdateNetworkInterfacesItem.

    :ivar id: ID - Resource ID of the network interface.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: ID - Resource ID of the network interface.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.azurestackhci.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.azurestackhci.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.azurestackhci.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.azurestackhci.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.azurestackhci.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OsProfileUpdate(_serialization.Model):
    """OsProfile - describes the update configuration of the operating system.

    :ivar computer_name: ComputerName - name of the computer.
    :vartype computer_name: str
    :ivar linux_configuration:
    :vartype linux_configuration:
     ~azure.mgmt.azurestackhci.models.OsProfileUpdateLinuxConfiguration
    :ivar windows_configuration:
    :vartype windows_configuration:
     ~azure.mgmt.azurestackhci.models.OsProfileUpdateWindowsConfiguration
    """

    _attribute_map = {
        "computer_name": {"key": "computerName", "type": "str"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "OsProfileUpdateLinuxConfiguration"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "OsProfileUpdateWindowsConfiguration"},
    }

    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        linux_configuration: Optional["_models.OsProfileUpdateLinuxConfiguration"] = None,
        windows_configuration: Optional["_models.OsProfileUpdateWindowsConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword computer_name: ComputerName - name of the computer.
        :paramtype computer_name: str
        :keyword linux_configuration:
        :paramtype linux_configuration:
         ~azure.mgmt.azurestackhci.models.OsProfileUpdateLinuxConfiguration
        :keyword windows_configuration:
        :paramtype windows_configuration:
         ~azure.mgmt.azurestackhci.models.OsProfileUpdateWindowsConfiguration
        """
        super().__init__(**kwargs)
        self.computer_name = computer_name
        self.linux_configuration = linux_configuration
        self.windows_configuration = windows_configuration


class OsProfileUpdateLinuxConfiguration(_serialization.Model):
    """OsProfileUpdateLinuxConfiguration.

    :ivar provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be
     triggered during the virtual machine instance creation process.
    :vartype provision_vm_agent: bool
    :ivar provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
     installed during the virtual machine creation process.
    :vartype provision_vm_config_agent: bool
    """

    _attribute_map = {
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "provision_vm_config_agent": {"key": "provisionVMConfigAgent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        provision_vm_config_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should
         be triggered during the virtual machine instance creation process.
        :paramtype provision_vm_agent: bool
        :keyword provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
         installed during the virtual machine creation process.
        :paramtype provision_vm_config_agent: bool
        """
        super().__init__(**kwargs)
        self.provision_vm_agent = provision_vm_agent
        self.provision_vm_config_agent = provision_vm_config_agent


class OsProfileUpdateWindowsConfiguration(_serialization.Model):
    """OsProfileUpdateWindowsConfiguration.

    :ivar provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be
     triggered during the virtual machine instance creation process.
    :vartype provision_vm_agent: bool
    :ivar provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
     installed during the virtual machine creation process.
    :vartype provision_vm_config_agent: bool
    """

    _attribute_map = {
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "provision_vm_config_agent": {"key": "provisionVMConfigAgent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        provision_vm_config_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should
         be triggered during the virtual machine instance creation process.
        :paramtype provision_vm_agent: bool
        :keyword provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
         installed during the virtual machine creation process.
        :paramtype provision_vm_config_agent: bool
        """
        super().__init__(**kwargs)
        self.provision_vm_agent = provision_vm_agent
        self.provision_vm_config_agent = provision_vm_config_agent


class Route(_serialization.Model):
    """Route - Route resource.

    :ivar name: Name - name of the subnet.
    :vartype name: str
    :ivar address_prefix: The destination CIDR to which the route applies.
    :vartype address_prefix: str
    :ivar next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :vartype next_hop_ip_address: str
    """

    _validation = {
        "name": {"pattern": r"^[a-zA-Z0-9]$|^[a-zA-Z0-9][-._a-zA-Z0-9]{0,78}[_a-zA-Z0-9]$"},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "next_hop_ip_address": {"key": "properties.nextHopIpAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        address_prefix: Optional[str] = None,
        next_hop_ip_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name - name of the subnet.
        :paramtype name: str
        :keyword address_prefix: The destination CIDR to which the route applies.
        :paramtype address_prefix: str
        :keyword next_hop_ip_address: The IP address packets should be forwarded to. Next hop values
         are only allowed in routes where the next hop type is VirtualAppliance.
        :paramtype next_hop_ip_address: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.address_prefix = address_prefix
        self.next_hop_ip_address = next_hop_ip_address


class RouteTable(_serialization.Model):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar routes: Collection of routes contained within a route table.
    :vartype routes: list[~azure.mgmt.azurestackhci.models.Route]
    """

    _validation = {
        "etag": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "etag": {"key": "etag", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "routes": {"key": "properties.routes", "type": "[Route]"},
    }

    def __init__(self, *, routes: Optional[List["_models.Route"]] = None, **kwargs: Any) -> None:
        """
        :keyword routes: Collection of routes contained within a route table.
        :paramtype routes: list[~azure.mgmt.azurestackhci.models.Route]
        """
        super().__init__(**kwargs)
        self.etag = None
        self.name = None
        self.type = None
        self.routes = routes


class SshConfiguration(_serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.azurestackhci.models.SshPublicKey]
    """

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, public_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        :paramtype public_keys: list[~azure.mgmt.azurestackhci.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class SshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the
    public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in
     Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
    :vartype key_data: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, key_data: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword path: Specifies the full path on the created VM where ssh public key is stored. If the
         file already exists, the specified key is appended to the file. Example:
         /home/user/.ssh/authorized_keys.
        :paramtype path: str
        :keyword key_data: SSH public key certificate used to authenticate with the VM through ssh. The
         key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
         ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in
         Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.key_data = key_data


class StorageContainers(TrackedResource):
    """The storage container resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
    :ivar path: Path of the storage container on the disk.
    :vartype path: str
    :ivar provisioning_state: Provisioning state of the storage container. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhci.models.ProvisioningStateEnum
    :ivar status: The observed state of storage containers.
    :vartype status: ~azure.mgmt.azurestackhci.models.StorageContainerStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "path": {"key": "properties.path", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "StorageContainerStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
        :keyword path: Path of the storage container on the disk.
        :paramtype path: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.path = path
        self.provisioning_state = None
        self.status = None


class StorageContainersListResult(_serialization.Model):
    """StorageContainersListResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.azurestackhci.models.StorageContainers]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageContainers]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.StorageContainers"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.azurestackhci.models.StorageContainers]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class StorageContainerStatus(_serialization.Model):
    """The observed state of storage containers.

    :ivar error_code: StorageContainer provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar available_size_mb: Amount of space available on the disk in MB.
    :vartype available_size_mb: int
    :ivar container_size_mb: Total size of the disk in MB.
    :vartype container_size_mb: int
    :ivar provisioning_status:
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhci.models.StorageContainerStatusProvisioningStatus
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "available_size_mb": {"key": "availableSizeMB", "type": "int"},
        "container_size_mb": {"key": "containerSizeMB", "type": "int"},
        "provisioning_status": {"key": "provisioningStatus", "type": "StorageContainerStatusProvisioningStatus"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        available_size_mb: Optional[int] = None,
        container_size_mb: Optional[int] = None,
        provisioning_status: Optional["_models.StorageContainerStatusProvisioningStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: StorageContainer provisioning error code.
        :paramtype error_code: str
        :keyword error_message: Descriptive error message.
        :paramtype error_message: str
        :keyword available_size_mb: Amount of space available on the disk in MB.
        :paramtype available_size_mb: int
        :keyword container_size_mb: Total size of the disk in MB.
        :paramtype container_size_mb: int
        :keyword provisioning_status:
        :paramtype provisioning_status:
         ~azure.mgmt.azurestackhci.models.StorageContainerStatusProvisioningStatus
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message
        self.available_size_mb = available_size_mb
        self.container_size_mb = container_size_mb
        self.provisioning_status = provisioning_status


class StorageContainerStatusProvisioningStatus(_serialization.Model):
    """StorageContainerStatusProvisioningStatus.

    :ivar operation_id: The ID of the operation performed on the storage container.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the storage container [Succeeded,
     Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhci.models.Status
    """

    _attribute_map = {
        "operation_id": {"key": "operationId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_id: The ID of the operation performed on the storage container.
        :paramtype operation_id: str
        :keyword status: The status of the operation performed on the storage container [Succeeded,
         Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
        :paramtype status: str or ~azure.mgmt.azurestackhci.models.Status
        """
        super().__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status


class StorageContainersUpdateRequest(_serialization.Model):
    """The storage container resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class StorageProfileUpdate(_serialization.Model):
    """StorageProfileUpdate.

    :ivar data_disks: adds data disks to the virtual machine instance for the update call.
    :vartype data_disks: list[~azure.mgmt.azurestackhci.models.StorageProfileUpdateDataDisksItem]
    """

    _attribute_map = {
        "data_disks": {"key": "dataDisks", "type": "[StorageProfileUpdateDataDisksItem]"},
    }

    def __init__(
        self, *, data_disks: Optional[List["_models.StorageProfileUpdateDataDisksItem"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword data_disks: adds data disks to the virtual machine instance for the update call.
        :paramtype data_disks: list[~azure.mgmt.azurestackhci.models.StorageProfileUpdateDataDisksItem]
        """
        super().__init__(**kwargs)
        self.data_disks = data_disks


class StorageProfileUpdateDataDisksItem(_serialization.Model):
    """StorageProfileUpdateDataDisksItem.

    :ivar id:
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id:
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class Subnet(_serialization.Model):
    """Subnet.

    :ivar name: Name - The name of the resource that is unique within a resource group. This name
     can be used to access the resource.
    :vartype name: str
    :ivar address_prefix: The address prefix for the subnet: Cidr for this subnet - IPv4, IPv6.
    :vartype address_prefix: str
    :ivar address_prefixes: List of address prefixes for the subnet.
    :vartype address_prefixes: list[str]
    :ivar ip_allocation_method: IPAllocationMethod - The IP address allocation method. Possible
     values include: 'Static', 'Dynamic'. Known values are: "Dynamic" and "Static".
    :vartype ip_allocation_method: str or ~azure.mgmt.azurestackhci.models.IpAllocationMethodEnum
    :ivar ip_configuration_references: IPConfigurationReferences - list of
     IPConfigurationReferences.
    :vartype ip_configuration_references:
     list[~azure.mgmt.azurestackhci.models.SubnetPropertiesFormatIpConfigurationReferencesItem]
    :ivar route_table: Route table resource.
    :vartype route_table: ~azure.mgmt.azurestackhci.models.RouteTable
    :ivar ip_pools: network associated pool of IP Addresses.
    :vartype ip_pools: list[~azure.mgmt.azurestackhci.models.IPPool]
    :ivar vlan: Vlan to use for the subnet.
    :vartype vlan: int
    """

    _validation = {
        "name": {"pattern": r"^[a-zA-Z0-9]$|^[a-zA-Z0-9][-._a-zA-Z0-9]{0,78}[_a-zA-Z0-9]$"},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "address_prefixes": {"key": "properties.addressPrefixes", "type": "[str]"},
        "ip_allocation_method": {"key": "properties.ipAllocationMethod", "type": "str"},
        "ip_configuration_references": {
            "key": "properties.ipConfigurationReferences",
            "type": "[SubnetPropertiesFormatIpConfigurationReferencesItem]",
        },
        "route_table": {"key": "properties.routeTable", "type": "RouteTable"},
        "ip_pools": {"key": "properties.ipPools", "type": "[IPPool]"},
        "vlan": {"key": "properties.vlan", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        address_prefix: Optional[str] = None,
        address_prefixes: Optional[List[str]] = None,
        ip_allocation_method: Optional[Union[str, "_models.IpAllocationMethodEnum"]] = None,
        ip_configuration_references: Optional[
            List["_models.SubnetPropertiesFormatIpConfigurationReferencesItem"]
        ] = None,
        route_table: Optional["_models.RouteTable"] = None,
        ip_pools: Optional[List["_models.IPPool"]] = None,
        vlan: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name - The name of the resource that is unique within a resource group. This
         name can be used to access the resource.
        :paramtype name: str
        :keyword address_prefix: The address prefix for the subnet: Cidr for this subnet - IPv4, IPv6.
        :paramtype address_prefix: str
        :keyword address_prefixes: List of address prefixes for the subnet.
        :paramtype address_prefixes: list[str]
        :keyword ip_allocation_method: IPAllocationMethod - The IP address allocation method. Possible
         values include: 'Static', 'Dynamic'. Known values are: "Dynamic" and "Static".
        :paramtype ip_allocation_method: str or ~azure.mgmt.azurestackhci.models.IpAllocationMethodEnum
        :keyword ip_configuration_references: IPConfigurationReferences - list of
         IPConfigurationReferences.
        :paramtype ip_configuration_references:
         list[~azure.mgmt.azurestackhci.models.SubnetPropertiesFormatIpConfigurationReferencesItem]
        :keyword route_table: Route table resource.
        :paramtype route_table: ~azure.mgmt.azurestackhci.models.RouteTable
        :keyword ip_pools: network associated pool of IP Addresses.
        :paramtype ip_pools: list[~azure.mgmt.azurestackhci.models.IPPool]
        :keyword vlan: Vlan to use for the subnet.
        :paramtype vlan: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.address_prefix = address_prefix
        self.address_prefixes = address_prefixes
        self.ip_allocation_method = ip_allocation_method
        self.ip_configuration_references = ip_configuration_references
        self.route_table = route_table
        self.ip_pools = ip_pools
        self.vlan = vlan


class SubnetPropertiesFormatIpConfigurationReferencesItem(_serialization.Model):
    """IPConfigurationReference - Describes a IPConfiguration under the virtual network.

    :ivar id: IPConfigurationID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "ID", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: IPConfigurationID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.azurestackhci.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.azurestackhci.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.azurestackhci.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.azurestackhci.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class VirtualHardDisks(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The virtual hard disk resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
    :ivar block_size_bytes:
    :vartype block_size_bytes: int
    :ivar disk_size_gb: Size of the disk in GB.
    :vartype disk_size_gb: int
    :ivar dynamic: Boolean for enabling dynamic sizing on the virtual hard disk.
    :vartype dynamic: bool
    :ivar logical_sector_bytes:
    :vartype logical_sector_bytes: int
    :ivar physical_sector_bytes:
    :vartype physical_sector_bytes: int
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.azurestackhci.models.HyperVGeneration
    :ivar disk_file_format: The format of the actual VHD file [vhd, vhdx]. Known values are: "vhdx"
     and "vhd".
    :vartype disk_file_format: str or ~azure.mgmt.azurestackhci.models.DiskFileFormat
    :ivar provisioning_state: Provisioning state of the virtual hard disk. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhci.models.ProvisioningStateEnum
    :ivar container_id: Storage ContainerID of the storage container to be used for VHD.
    :vartype container_id: str
    :ivar status: The observed state of virtual hard disks.
    :vartype status: ~azure.mgmt.azurestackhci.models.VirtualHardDiskStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "block_size_bytes": {"key": "properties.blockSizeBytes", "type": "int"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "dynamic": {"key": "properties.dynamic", "type": "bool"},
        "logical_sector_bytes": {"key": "properties.logicalSectorBytes", "type": "int"},
        "physical_sector_bytes": {"key": "properties.physicalSectorBytes", "type": "int"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "disk_file_format": {"key": "properties.diskFileFormat", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "container_id": {"key": "properties.containerId", "type": "str"},
        "status": {"key": "properties.status", "type": "VirtualHardDiskStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        block_size_bytes: Optional[int] = None,
        disk_size_gb: Optional[int] = None,
        dynamic: Optional[bool] = None,
        logical_sector_bytes: Optional[int] = None,
        physical_sector_bytes: Optional[int] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        disk_file_format: Optional[Union[str, "_models.DiskFileFormat"]] = None,
        container_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
        :keyword block_size_bytes:
        :paramtype block_size_bytes: int
        :keyword disk_size_gb: Size of the disk in GB.
        :paramtype disk_size_gb: int
        :keyword dynamic: Boolean for enabling dynamic sizing on the virtual hard disk.
        :paramtype dynamic: bool
        :keyword logical_sector_bytes:
        :paramtype logical_sector_bytes: int
        :keyword physical_sector_bytes:
        :paramtype physical_sector_bytes: int
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
         values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.azurestackhci.models.HyperVGeneration
        :keyword disk_file_format: The format of the actual VHD file [vhd, vhdx]. Known values are:
         "vhdx" and "vhd".
        :paramtype disk_file_format: str or ~azure.mgmt.azurestackhci.models.DiskFileFormat
        :keyword container_id: Storage ContainerID of the storage container to be used for VHD.
        :paramtype container_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.block_size_bytes = block_size_bytes
        self.disk_size_gb = disk_size_gb
        self.dynamic = dynamic
        self.logical_sector_bytes = logical_sector_bytes
        self.physical_sector_bytes = physical_sector_bytes
        self.hyper_v_generation = hyper_v_generation
        self.disk_file_format = disk_file_format
        self.provisioning_state = None
        self.container_id = container_id
        self.status = None


class VirtualHardDisksListResult(_serialization.Model):
    """VirtualHardDisksListResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.azurestackhci.models.VirtualHardDisks]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualHardDisks]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualHardDisks"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.azurestackhci.models.VirtualHardDisks]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualHardDiskStatus(_serialization.Model):
    """The observed state of virtual hard disks.

    :ivar error_code: VirtualHardDisk provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status:
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhci.models.VirtualHardDiskStatusProvisioningStatus
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "provisioning_status": {"key": "provisioningStatus", "type": "VirtualHardDiskStatusProvisioningStatus"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.VirtualHardDiskStatusProvisioningStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: VirtualHardDisk provisioning error code.
        :paramtype error_code: str
        :keyword error_message: Descriptive error message.
        :paramtype error_message: str
        :keyword provisioning_status:
        :paramtype provisioning_status:
         ~azure.mgmt.azurestackhci.models.VirtualHardDiskStatusProvisioningStatus
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message
        self.provisioning_status = provisioning_status


class VirtualHardDiskStatusProvisioningStatus(_serialization.Model):
    """VirtualHardDiskStatusProvisioningStatus.

    :ivar operation_id: The ID of the operation performed on the virtual hard disk.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the virtual hard disk [Succeeded,
     Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhci.models.Status
    """

    _attribute_map = {
        "operation_id": {"key": "operationId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_id: The ID of the operation performed on the virtual hard disk.
        :paramtype operation_id: str
        :keyword status: The status of the operation performed on the virtual hard disk [Succeeded,
         Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
        :paramtype status: str or ~azure.mgmt.azurestackhci.models.Status
        """
        super().__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status


class VirtualHardDisksUpdateRequest(_serialization.Model):
    """The virtual hard disk resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class VirtualMachineConfigAgentInstanceView(_serialization.Model):
    """The instance view of the VM Config Agent running on the virtual machine.

    :ivar vm_config_agent_version: The VM Config Agent full version.
    :vartype vm_config_agent_version: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.azurestackhci.models.InstanceViewStatus]
    """

    _attribute_map = {
        "vm_config_agent_version": {"key": "vmConfigAgentVersion", "type": "str"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        vm_config_agent_version: Optional[str] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_config_agent_version: The VM Config Agent full version.
        :paramtype vm_config_agent_version: str
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.azurestackhci.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.vm_config_agent_version = vm_config_agent_version
        self.statuses = statuses


class VirtualMachineInstance(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The virtual machine instance resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhci.models.SystemData
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.azurestackhci.models.Identity
    :ivar hardware_profile: HardwareProfile - Specifies the hardware settings for the virtual
     machine instance.
    :vartype hardware_profile:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesHardwareProfile
    :ivar network_profile: NetworkProfile - describes the network configuration the virtual machine
     instance.
    :vartype network_profile:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesNetworkProfile
    :ivar os_profile: OsProfile - describes the configuration of the operating system and sets
     login data.
    :vartype os_profile: ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesOsProfile
    :ivar security_profile: SecurityProfile - Specifies the security settings for the virtual
     machine instance.
    :vartype security_profile:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesSecurityProfile
    :ivar storage_profile: StorageProfile - contains information about the disks and storage
     information for the virtual machine instance.
    :vartype storage_profile:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesStorageProfile
    :ivar http_proxy_config: HTTP Proxy configuration for the VM.
    :vartype http_proxy_config: ~azure.mgmt.azurestackhci.models.HttpProxyConfiguration
    :ivar provisioning_state: Provisioning state of the virtual machine instance. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhci.models.ProvisioningStateEnum
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.azurestackhci.models.VirtualMachineInstanceView
    :ivar status: The observed state of virtual machine instances.
    :vartype status: ~azure.mgmt.azurestackhci.models.VirtualMachineInstanceStatus
    :ivar guest_agent_install_status: Guest agent install status.
    :vartype guest_agent_install_status: ~azure.mgmt.azurestackhci.models.GuestAgentInstallStatus
    :ivar vm_id: Unique identifier for the vm resource.
    :vartype vm_id: str
    :ivar resource_uid: Unique identifier defined by ARC to identify the guest of the VM.
    :vartype resource_uid: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "status": {"readonly": True},
        "vm_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "identity": {"key": "identity", "type": "Identity"},
        "hardware_profile": {
            "key": "properties.hardwareProfile",
            "type": "VirtualMachineInstancePropertiesHardwareProfile",
        },
        "network_profile": {
            "key": "properties.networkProfile",
            "type": "VirtualMachineInstancePropertiesNetworkProfile",
        },
        "os_profile": {"key": "properties.osProfile", "type": "VirtualMachineInstancePropertiesOsProfile"},
        "security_profile": {
            "key": "properties.securityProfile",
            "type": "VirtualMachineInstancePropertiesSecurityProfile",
        },
        "storage_profile": {
            "key": "properties.storageProfile",
            "type": "VirtualMachineInstancePropertiesStorageProfile",
        },
        "http_proxy_config": {"key": "properties.httpProxyConfig", "type": "HttpProxyConfiguration"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineInstanceView"},
        "status": {"key": "properties.status", "type": "VirtualMachineInstanceStatus"},
        "guest_agent_install_status": {"key": "properties.guestAgentInstallStatus", "type": "GuestAgentInstallStatus"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "resource_uid": {"key": "properties.resourceUid", "type": "str"},
    }

    def __init__(
        self,
        *,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        identity: Optional["_models.Identity"] = None,
        hardware_profile: Optional["_models.VirtualMachineInstancePropertiesHardwareProfile"] = None,
        network_profile: Optional["_models.VirtualMachineInstancePropertiesNetworkProfile"] = None,
        os_profile: Optional["_models.VirtualMachineInstancePropertiesOsProfile"] = None,
        security_profile: Optional["_models.VirtualMachineInstancePropertiesSecurityProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineInstancePropertiesStorageProfile"] = None,
        http_proxy_config: Optional["_models.HttpProxyConfiguration"] = None,
        guest_agent_install_status: Optional["_models.GuestAgentInstallStatus"] = None,
        resource_uid: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurestackhci.models.ExtendedLocation
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.azurestackhci.models.Identity
        :keyword hardware_profile: HardwareProfile - Specifies the hardware settings for the virtual
         machine instance.
        :paramtype hardware_profile:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesHardwareProfile
        :keyword network_profile: NetworkProfile - describes the network configuration the virtual
         machine instance.
        :paramtype network_profile:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesNetworkProfile
        :keyword os_profile: OsProfile - describes the configuration of the operating system and sets
         login data.
        :paramtype os_profile:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesOsProfile
        :keyword security_profile: SecurityProfile - Specifies the security settings for the virtual
         machine instance.
        :paramtype security_profile:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesSecurityProfile
        :keyword storage_profile: StorageProfile - contains information about the disks and storage
         information for the virtual machine instance.
        :paramtype storage_profile:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesStorageProfile
        :keyword http_proxy_config: HTTP Proxy configuration for the VM.
        :paramtype http_proxy_config: ~azure.mgmt.azurestackhci.models.HttpProxyConfiguration
        :keyword guest_agent_install_status: Guest agent install status.
        :paramtype guest_agent_install_status: ~azure.mgmt.azurestackhci.models.GuestAgentInstallStatus
        :keyword resource_uid: Unique identifier defined by ARC to identify the guest of the VM.
        :paramtype resource_uid: str
        """
        super().__init__(**kwargs)
        self.extended_location = extended_location
        self.identity = identity
        self.hardware_profile = hardware_profile
        self.network_profile = network_profile
        self.os_profile = os_profile
        self.security_profile = security_profile
        self.storage_profile = storage_profile
        self.http_proxy_config = http_proxy_config
        self.provisioning_state = None
        self.instance_view = None
        self.status = None
        self.guest_agent_install_status = guest_agent_install_status
        self.vm_id = None
        self.resource_uid = resource_uid


class VirtualMachineInstanceListResult(_serialization.Model):
    """VirtualMachineInstanceListResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.azurestackhci.models.VirtualMachineInstance]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualMachineInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.azurestackhci.models.VirtualMachineInstance]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineInstancePropertiesHardwareProfile(_serialization.Model):
    """HardwareProfile - Specifies the hardware settings for the virtual machine instance.

    :ivar vm_size: Known values are: "Default", "Standard_A2_v2", "Standard_A4_v2",
     "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
     "Standard_D32s_v3", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2",
     "Standard_DS13_v2", "Standard_K8S_v1", "Standard_K8S2_v1", "Standard_K8S3_v1",
     "Standard_K8S4_v1", "Standard_NK6", "Standard_NK12", "Standard_NV6", "Standard_NV12",
     "Standard_K8S5_v1", and "Custom".
    :vartype vm_size: str or ~azure.mgmt.azurestackhci.models.VmSizeEnum
    :ivar processors: number of processors for the virtual machine instance.
    :vartype processors: int
    :ivar memory_mb: RAM in MB for the virtual machine instance.
    :vartype memory_mb: int
    :ivar dynamic_memory_config:
    :vartype dynamic_memory_config:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "processors": {"key": "processors", "type": "int"},
        "memory_mb": {"key": "memoryMB", "type": "int"},
        "dynamic_memory_config": {
            "key": "dynamicMemoryConfig",
            "type": "VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig",
        },
    }

    def __init__(
        self,
        *,
        vm_size: Optional[Union[str, "_models.VmSizeEnum"]] = None,
        processors: Optional[int] = None,
        memory_mb: Optional[int] = None,
        dynamic_memory_config: Optional[
            "_models.VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_size: Known values are: "Default", "Standard_A2_v2", "Standard_A4_v2",
         "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
         "Standard_D32s_v3", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2",
         "Standard_DS13_v2", "Standard_K8S_v1", "Standard_K8S2_v1", "Standard_K8S3_v1",
         "Standard_K8S4_v1", "Standard_NK6", "Standard_NK12", "Standard_NV6", "Standard_NV12",
         "Standard_K8S5_v1", and "Custom".
        :paramtype vm_size: str or ~azure.mgmt.azurestackhci.models.VmSizeEnum
        :keyword processors: number of processors for the virtual machine instance.
        :paramtype processors: int
        :keyword memory_mb: RAM in MB for the virtual machine instance.
        :paramtype memory_mb: int
        :keyword dynamic_memory_config:
        :paramtype dynamic_memory_config:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.processors = processors
        self.memory_mb = memory_mb
        self.dynamic_memory_config = dynamic_memory_config


class VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig(_serialization.Model):
    """VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig.

    :ivar maximum_memory_mb:
    :vartype maximum_memory_mb: int
    :ivar minimum_memory_mb:
    :vartype minimum_memory_mb: int
    :ivar target_memory_buffer: Defines the amount of extra memory that should be reserved for a
     virtual machine instance at runtime, as a percentage of the total memory that the virtual
     machine instance is thought to need. This only applies to virtual systems with dynamic memory
     enabled. This property can be in the range of 5 to 2000.
    :vartype target_memory_buffer: int
    """

    _attribute_map = {
        "maximum_memory_mb": {"key": "maximumMemoryMB", "type": "int"},
        "minimum_memory_mb": {"key": "minimumMemoryMB", "type": "int"},
        "target_memory_buffer": {"key": "targetMemoryBuffer", "type": "int"},
    }

    def __init__(
        self,
        *,
        maximum_memory_mb: Optional[int] = None,
        minimum_memory_mb: Optional[int] = None,
        target_memory_buffer: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword maximum_memory_mb:
        :paramtype maximum_memory_mb: int
        :keyword minimum_memory_mb:
        :paramtype minimum_memory_mb: int
        :keyword target_memory_buffer: Defines the amount of extra memory that should be reserved for a
         virtual machine instance at runtime, as a percentage of the total memory that the virtual
         machine instance is thought to need. This only applies to virtual systems with dynamic memory
         enabled. This property can be in the range of 5 to 2000.
        :paramtype target_memory_buffer: int
        """
        super().__init__(**kwargs)
        self.maximum_memory_mb = maximum_memory_mb
        self.minimum_memory_mb = minimum_memory_mb
        self.target_memory_buffer = target_memory_buffer


class VirtualMachineInstancePropertiesNetworkProfile(_serialization.Model):
    """NetworkProfile - describes the network configuration the virtual machine instance.

    :ivar network_interfaces: NetworkInterfaces - list of network interfaces to be attached to the
     virtual machine instance.
    :vartype network_interfaces:
     list[~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem]
    """

    _attribute_map = {
        "network_interfaces": {
            "key": "networkInterfaces",
            "type": "[VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem]",
        },
    }

    def __init__(
        self,
        *,
        network_interfaces: Optional[
            List["_models.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interfaces: NetworkInterfaces - list of network interfaces to be attached to
         the virtual machine instance.
        :paramtype network_interfaces:
         list[~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem(_serialization.Model):
    """VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem.

    :ivar id: ID - Resource Id of the network interface.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: ID - Resource Id of the network interface.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualMachineInstancePropertiesOsProfile(_serialization.Model):
    """OsProfile - describes the configuration of the operating system and sets login data.

    :ivar admin_password: AdminPassword - admin password.
    :vartype admin_password: str
    :ivar admin_username: AdminUsername - admin username.
    :vartype admin_username: str
    :ivar computer_name: ComputerName - name of the compute.
    :vartype computer_name: str
    :ivar linux_configuration: LinuxConfiguration - linux specific configuration values for the
     virtual machine instance.
    :vartype linux_configuration:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesOsProfileLinuxConfiguration
    :ivar windows_configuration: Windows Configuration for the virtual machine instance.
    :vartype windows_configuration:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesOsProfileWindowsConfiguration
    """

    _attribute_map = {
        "admin_password": {"key": "adminPassword", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "computer_name": {"key": "computerName", "type": "str"},
        "linux_configuration": {
            "key": "linuxConfiguration",
            "type": "VirtualMachineInstancePropertiesOsProfileLinuxConfiguration",
        },
        "windows_configuration": {
            "key": "windowsConfiguration",
            "type": "VirtualMachineInstancePropertiesOsProfileWindowsConfiguration",
        },
    }

    def __init__(
        self,
        *,
        admin_password: Optional[str] = None,
        admin_username: Optional[str] = None,
        computer_name: Optional[str] = None,
        linux_configuration: Optional["_models.VirtualMachineInstancePropertiesOsProfileLinuxConfiguration"] = None,
        windows_configuration: Optional["_models.VirtualMachineInstancePropertiesOsProfileWindowsConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_password: AdminPassword - admin password.
        :paramtype admin_password: str
        :keyword admin_username: AdminUsername - admin username.
        :paramtype admin_username: str
        :keyword computer_name: ComputerName - name of the compute.
        :paramtype computer_name: str
        :keyword linux_configuration: LinuxConfiguration - linux specific configuration values for the
         virtual machine instance.
        :paramtype linux_configuration:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesOsProfileLinuxConfiguration
        :keyword windows_configuration: Windows Configuration for the virtual machine instance.
        :paramtype windows_configuration:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesOsProfileWindowsConfiguration
        """
        super().__init__(**kwargs)
        self.admin_password = admin_password
        self.admin_username = admin_username
        self.computer_name = computer_name
        self.linux_configuration = linux_configuration
        self.windows_configuration = windows_configuration


class VirtualMachineInstancePropertiesOsProfileLinuxConfiguration(_serialization.Model):
    """LinuxConfiguration - linux specific configuration values for the virtual machine instance.

    :ivar disable_password_authentication: DisablePasswordAuthentication - whether password
     authentication should be disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.azurestackhci.models.SshConfiguration
    :ivar provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be
     triggered during the virtual machine instance creation process.
    :vartype provision_vm_agent: bool
    :ivar provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
     installed during the virtual machine creation process.
    :vartype provision_vm_config_agent: bool
    """

    _attribute_map = {
        "disable_password_authentication": {"key": "disablePasswordAuthentication", "type": "bool"},
        "ssh": {"key": "ssh", "type": "SshConfiguration"},
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "provision_vm_config_agent": {"key": "provisionVMConfigAgent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        provision_vm_agent: bool = True,
        provision_vm_config_agent: bool = True,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_password_authentication: DisablePasswordAuthentication - whether password
         authentication should be disabled.
        :paramtype disable_password_authentication: bool
        :keyword ssh: Specifies the ssh key configuration for a Linux OS.
        :paramtype ssh: ~azure.mgmt.azurestackhci.models.SshConfiguration
        :keyword provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should
         be triggered during the virtual machine instance creation process.
        :paramtype provision_vm_agent: bool
        :keyword provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
         installed during the virtual machine creation process.
        :paramtype provision_vm_config_agent: bool
        """
        super().__init__(**kwargs)
        self.disable_password_authentication = disable_password_authentication
        self.ssh = ssh
        self.provision_vm_agent = provision_vm_agent
        self.provision_vm_config_agent = provision_vm_config_agent


class VirtualMachineInstancePropertiesOsProfileWindowsConfiguration(_serialization.Model):
    """Windows Configuration for the virtual machine instance.

    :ivar enable_automatic_updates: Whether to EnableAutomaticUpdates on the machine.
    :vartype enable_automatic_updates: bool
    :ivar ssh: Specifies the ssh key configuration for Windows OS.
    :vartype ssh: ~azure.mgmt.azurestackhci.models.SshConfiguration
    :ivar time_zone: TimeZone for the virtual machine instance.
    :vartype time_zone: str
    :ivar provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be
     triggered during the virtual machine instance creation process.
    :vartype provision_vm_agent: bool
    :ivar provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
     installed during the virtual machine creation process.
    :vartype provision_vm_config_agent: bool
    """

    _attribute_map = {
        "enable_automatic_updates": {"key": "enableAutomaticUpdates", "type": "bool"},
        "ssh": {"key": "ssh", "type": "SshConfiguration"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "provision_vm_config_agent": {"key": "provisionVMConfigAgent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enable_automatic_updates: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        time_zone: Optional[str] = None,
        provision_vm_agent: bool = True,
        provision_vm_config_agent: bool = True,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_automatic_updates: Whether to EnableAutomaticUpdates on the machine.
        :paramtype enable_automatic_updates: bool
        :keyword ssh: Specifies the ssh key configuration for Windows OS.
        :paramtype ssh: ~azure.mgmt.azurestackhci.models.SshConfiguration
        :keyword time_zone: TimeZone for the virtual machine instance.
        :paramtype time_zone: str
        :keyword provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should
         be triggered during the virtual machine instance creation process.
        :paramtype provision_vm_agent: bool
        :keyword provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
         installed during the virtual machine creation process.
        :paramtype provision_vm_config_agent: bool
        """
        super().__init__(**kwargs)
        self.enable_automatic_updates = enable_automatic_updates
        self.ssh = ssh
        self.time_zone = time_zone
        self.provision_vm_agent = provision_vm_agent
        self.provision_vm_config_agent = provision_vm_config_agent


class VirtualMachineInstancePropertiesSecurityProfile(_serialization.Model):
    """SecurityProfile - Specifies the security settings for the virtual machine instance.

    :ivar enable_tpm:
    :vartype enable_tpm: bool
    :ivar uefi_settings:
    :vartype uefi_settings:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesSecurityProfileUefiSettings
    :ivar security_type: Specifies the SecurityType of the virtual machine. EnableTPM and
     SecureBootEnabled must be set to true for SecurityType to function. Known values are:
     "TrustedLaunch" and "ConfidentialVM".
    :vartype security_type: str or ~azure.mgmt.azurestackhci.models.SecurityTypes
    """

    _attribute_map = {
        "enable_tpm": {"key": "enableTPM", "type": "bool"},
        "uefi_settings": {"key": "uefiSettings", "type": "VirtualMachineInstancePropertiesSecurityProfileUefiSettings"},
        "security_type": {"key": "securityType", "type": "str"},
    }

    def __init__(
        self,
        *,
        enable_tpm: bool = False,
        uefi_settings: Optional["_models.VirtualMachineInstancePropertiesSecurityProfileUefiSettings"] = None,
        security_type: Optional[Union[str, "_models.SecurityTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_tpm:
        :paramtype enable_tpm: bool
        :keyword uefi_settings:
        :paramtype uefi_settings:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesSecurityProfileUefiSettings
        :keyword security_type: Specifies the SecurityType of the virtual machine. EnableTPM and
         SecureBootEnabled must be set to true for SecurityType to function. Known values are:
         "TrustedLaunch" and "ConfidentialVM".
        :paramtype security_type: str or ~azure.mgmt.azurestackhci.models.SecurityTypes
        """
        super().__init__(**kwargs)
        self.enable_tpm = enable_tpm
        self.uefi_settings = uefi_settings
        self.security_type = security_type


class VirtualMachineInstancePropertiesSecurityProfileUefiSettings(_serialization.Model):
    """VirtualMachineInstancePropertiesSecurityProfileUefiSettings.

    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine instance.
    :vartype secure_boot_enabled: bool
    """

    _attribute_map = {
        "secure_boot_enabled": {"key": "secureBootEnabled", "type": "bool"},
    }

    def __init__(self, *, secure_boot_enabled: bool = False, **kwargs: Any) -> None:
        """
        :keyword secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
         machine instance.
        :paramtype secure_boot_enabled: bool
        """
        super().__init__(**kwargs)
        self.secure_boot_enabled = secure_boot_enabled


class VirtualMachineInstancePropertiesStorageProfile(_serialization.Model):
    """StorageProfile - contains information about the disks and storage information for the virtual
    machine instance.

    :ivar data_disks: adds data disks to the virtual machine instance.
    :vartype data_disks:
     list[~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesStorageProfileDataDisksItem]
    :ivar image_reference: Which Image to use for the virtual machine instance.
    :vartype image_reference:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesStorageProfileImageReference
    :ivar os_disk: VHD to attach as OS disk.
    :vartype os_disk:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesStorageProfileOsDisk
    :ivar vm_config_storage_path_id: Id of the storage container that hosts the VM configuration
     file.
    :vartype vm_config_storage_path_id: str
    """

    _attribute_map = {
        "data_disks": {"key": "dataDisks", "type": "[VirtualMachineInstancePropertiesStorageProfileDataDisksItem]"},
        "image_reference": {
            "key": "imageReference",
            "type": "VirtualMachineInstancePropertiesStorageProfileImageReference",
        },
        "os_disk": {"key": "osDisk", "type": "VirtualMachineInstancePropertiesStorageProfileOsDisk"},
        "vm_config_storage_path_id": {"key": "vmConfigStoragePathId", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_disks: Optional[List["_models.VirtualMachineInstancePropertiesStorageProfileDataDisksItem"]] = None,
        image_reference: Optional["_models.VirtualMachineInstancePropertiesStorageProfileImageReference"] = None,
        os_disk: Optional["_models.VirtualMachineInstancePropertiesStorageProfileOsDisk"] = None,
        vm_config_storage_path_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_disks: adds data disks to the virtual machine instance.
        :paramtype data_disks:
         list[~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesStorageProfileDataDisksItem]
        :keyword image_reference: Which Image to use for the virtual machine instance.
        :paramtype image_reference:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesStorageProfileImageReference
        :keyword os_disk: VHD to attach as OS disk.
        :paramtype os_disk:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstancePropertiesStorageProfileOsDisk
        :keyword vm_config_storage_path_id: Id of the storage container that hosts the VM configuration
         file.
        :paramtype vm_config_storage_path_id: str
        """
        super().__init__(**kwargs)
        self.data_disks = data_disks
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.vm_config_storage_path_id = vm_config_storage_path_id


class VirtualMachineInstancePropertiesStorageProfileDataDisksItem(_serialization.Model):
    """VirtualMachineInstancePropertiesStorageProfileDataDisksItem.

    :ivar id: Resource ID of the data disk.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the data disk.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualMachineInstancePropertiesStorageProfileImageReference(_serialization.Model):
    """Which Image to use for the virtual machine instance.

    :ivar id: Resource ID of the image.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the image.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualMachineInstancePropertiesStorageProfileOsDisk(_serialization.Model):
    """VHD to attach as OS disk.

    :ivar id: Resource ID of the OS disk.
    :vartype id: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,**
     **Linux.**. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.azurestackhci.models.OperatingSystemTypes
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of the OS disk.
        :paramtype id: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. Possible values are:
         **Windows,** **Linux.**. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.azurestackhci.models.OperatingSystemTypes
        """
        super().__init__(**kwargs)
        self.id = id
        self.os_type = os_type


class VirtualMachineInstanceStatus(_serialization.Model):
    """The observed state of virtual machine instances.

    :ivar error_code: VirtualMachine provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar power_state: The power state of the virtual machine instance. Known values are:
     "Deallocated", "Deallocating", "Running", "Starting", "Stopped", "Stopping", and "Unknown".
    :vartype power_state: str or ~azure.mgmt.azurestackhci.models.PowerStateEnum
    :ivar provisioning_status:
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhci.models.VirtualMachineInstanceStatusProvisioningStatus
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "power_state": {"key": "powerState", "type": "str"},
        "provisioning_status": {"key": "provisioningStatus", "type": "VirtualMachineInstanceStatusProvisioningStatus"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        power_state: Optional[Union[str, "_models.PowerStateEnum"]] = None,
        provisioning_status: Optional["_models.VirtualMachineInstanceStatusProvisioningStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: VirtualMachine provisioning error code.
        :paramtype error_code: str
        :keyword error_message: Descriptive error message.
        :paramtype error_message: str
        :keyword power_state: The power state of the virtual machine instance. Known values are:
         "Deallocated", "Deallocating", "Running", "Starting", "Stopped", "Stopping", and "Unknown".
        :paramtype power_state: str or ~azure.mgmt.azurestackhci.models.PowerStateEnum
        :keyword provisioning_status:
        :paramtype provisioning_status:
         ~azure.mgmt.azurestackhci.models.VirtualMachineInstanceStatusProvisioningStatus
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message
        self.power_state = power_state
        self.provisioning_status = provisioning_status


class VirtualMachineInstanceStatusProvisioningStatus(_serialization.Model):
    """VirtualMachineInstanceStatusProvisioningStatus.

    :ivar operation_id: The ID of the operation performed on the virtual machine instance.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the virtual machine instance [Succeeded,
     Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhci.models.Status
    """

    _attribute_map = {
        "operation_id": {"key": "operationId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_id: The ID of the operation performed on the virtual machine instance.
        :paramtype operation_id: str
        :keyword status: The status of the operation performed on the virtual machine instance
         [Succeeded, Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
        :paramtype status: str or ~azure.mgmt.azurestackhci.models.Status
        """
        super().__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status


class VirtualMachineInstanceUpdateProperties(_serialization.Model):
    """Defines the resource properties for the update.

    :ivar hardware_profile: HardwareProfile - Specifies the hardware settings for the virtual
     machine instance.
    :vartype hardware_profile: ~azure.mgmt.azurestackhci.models.HardwareProfileUpdate
    :ivar storage_profile:
    :vartype storage_profile: ~azure.mgmt.azurestackhci.models.StorageProfileUpdate
    :ivar network_profile: NetworkProfile - describes the network update configuration the virtual
     machine instance.
    :vartype network_profile: ~azure.mgmt.azurestackhci.models.NetworkProfileUpdate
    :ivar os_profile: OsProfile - describes the update configuration of the operating system.
    :vartype os_profile: ~azure.mgmt.azurestackhci.models.OsProfileUpdate
    """

    _attribute_map = {
        "hardware_profile": {"key": "hardwareProfile", "type": "HardwareProfileUpdate"},
        "storage_profile": {"key": "storageProfile", "type": "StorageProfileUpdate"},
        "network_profile": {"key": "networkProfile", "type": "NetworkProfileUpdate"},
        "os_profile": {"key": "osProfile", "type": "OsProfileUpdate"},
    }

    def __init__(
        self,
        *,
        hardware_profile: Optional["_models.HardwareProfileUpdate"] = None,
        storage_profile: Optional["_models.StorageProfileUpdate"] = None,
        network_profile: Optional["_models.NetworkProfileUpdate"] = None,
        os_profile: Optional["_models.OsProfileUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hardware_profile: HardwareProfile - Specifies the hardware settings for the virtual
         machine instance.
        :paramtype hardware_profile: ~azure.mgmt.azurestackhci.models.HardwareProfileUpdate
        :keyword storage_profile:
        :paramtype storage_profile: ~azure.mgmt.azurestackhci.models.StorageProfileUpdate
        :keyword network_profile: NetworkProfile - describes the network update configuration the
         virtual machine instance.
        :paramtype network_profile: ~azure.mgmt.azurestackhci.models.NetworkProfileUpdate
        :keyword os_profile: OsProfile - describes the update configuration of the operating system.
        :paramtype os_profile: ~azure.mgmt.azurestackhci.models.OsProfileUpdate
        """
        super().__init__(**kwargs)
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.os_profile = os_profile


class VirtualMachineInstanceUpdateRequest(_serialization.Model):
    """The virtual machine instance resource patch definition.

    :ivar properties: Defines the resource properties for the update.
    :vartype properties: ~azure.mgmt.azurestackhci.models.VirtualMachineInstanceUpdateProperties
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.azurestackhci.models.Identity
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "VirtualMachineInstanceUpdateProperties"},
        "identity": {"key": "identity", "type": "Identity"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualMachineInstanceUpdateProperties"] = None,
        identity: Optional["_models.Identity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Defines the resource properties for the update.
        :paramtype properties: ~azure.mgmt.azurestackhci.models.VirtualMachineInstanceUpdateProperties
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.azurestackhci.models.Identity
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.identity = identity


class VirtualMachineInstanceView(_serialization.Model):
    """The instance view of a virtual machine.

    :ivar vm_agent: The VM Config Agent running on the virtual machine.
    :vartype vm_agent: ~azure.mgmt.azurestackhci.models.VirtualMachineConfigAgentInstanceView
    """

    _attribute_map = {
        "vm_agent": {"key": "vmAgent", "type": "VirtualMachineConfigAgentInstanceView"},
    }

    def __init__(
        self, *, vm_agent: Optional["_models.VirtualMachineConfigAgentInstanceView"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword vm_agent: The VM Config Agent running on the virtual machine.
        :paramtype vm_agent: ~azure.mgmt.azurestackhci.models.VirtualMachineConfigAgentInstanceView
        """
        super().__init__(**kwargs)
        self.vm_agent = vm_agent
