# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CommunicationMessageKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of message. Supports text, image, template.
    """

    TEXT = "text"
    """Text message type."""
    IMAGE = "image"
    """Image message type."""
    TEMPLATE = "template"
    """Template message type."""

class CommunicationMessagesChannel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the communication messages channel.
    """

    WHATSAPP = "whatsApp"
    """The WhatsApp communication messages channel type."""

class MessageTemplateBindingsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the message template.
    """

    WHATSAPP = "whatsApp"
    """The WhatsApp template type."""

class MessageTemplateStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The aggregated template status.
    """

    APPROVED = "approved"
    """Message template is approved."""
    REJECTED = "rejected"
    """Message template is rejected."""
    PENDING = "pending"
    """Message template is pending."""
    PAUSED = "paused"
    """Message template is paused."""

class MessageTemplateValueKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the template parameter.
    """

    TEXT = "text"
    """The text template parameter type."""
    IMAGE = "image"
    """The image template parameter type."""
    DOCUMENT = "document"
    """The document template parameter type."""
    VIDEO = "video"
    """The video template parameter type."""
    LOCATION = "location"
    """The location template parameter type."""
    QUICK_ACTION = "quickAction"
    """The quick action template parameter type."""

class RepeatabilityResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Repeatability Result header options.
    """

    ACCEPTED = "accepted"
    """If the request was accepted and the server guarantees that the server state reflects a single
    execution of the operation."""
    REJECTED = "rejected"
    """If the request was rejected because the combination of Repeatability-First-Sent and
    Repeatability-Request-ID were invalid
    or because the Repeatability-First-Sent value was outside the range of values held by the
    server."""

class WhatsAppMessageButtonSubType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The WhatsApp button sub type.
    """

    QUICK_REPLY = "quickReply"
    """The WhatsApp button sub type is quick reply."""
    URL = "url"
    """The WhatsApp button sub type is url."""
