# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CheckNameAvailabilityRequest(_model_base.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    name: Optional[str] = rest_field()
    """The name of the resource for which availability needs to be checked."""
    type: Optional[str] = rest_field()
    """The resource type."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityResponse(_model_base.Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.mongocluster.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is not available.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(name="nameAvailable")
    """Indicates if the resource name is available."""
    reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = rest_field()
    """The reason why the given name is not available. Known values are: \"Invalid\" and
     \"AlreadyExists\"."""
    message: Optional[str] = rest_field()
    """Detailed reason why the given name is not available."""

    @overload
    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ConnectionString(_model_base.Model):
    """Connection string for the mongo cluster.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar connection_string: Value of the connection string.
    :vartype connection_string: str
    :ivar description: Description of the connection string.
    :vartype description: str
    """

    connection_string: Optional[str] = rest_field(name="connectionString", visibility=["read"])
    """Value of the connection string."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Description of the connection string."""


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.mongocluster.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.mongocluster.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.mongocluster.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    """


class FirewallRule(ProxyResource):
    """Represents a mongo cluster firewall rule.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.FirewallRuleProperties
    """

    properties: Optional["_models.FirewallRuleProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.FirewallRuleProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FirewallRuleProperties(_model_base.Model):
    """The properties of a mongo cluster firewall rule.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar provisioning_state: The provisioning state of the firewall rule. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", "Updating", and "Dropping".
    :vartype provisioning_state: str or ~azure.mgmt.mongocluster.models.ProvisioningState
    :ivar start_ip_address: The start IP address of the mongo cluster firewall rule. Must be IPv4
     format. Required.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address of the mongo cluster firewall rule. Must be IPv4
     format. Required.
    :vartype end_ip_address: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the firewall rule. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"InProgress\", \"Updating\", and \"Dropping\"."""
    start_ip_address: str = rest_field(name="startIpAddress")
    """The start IP address of the mongo cluster firewall rule. Must be IPv4 format. Required."""
    end_ip_address: str = rest_field(name="endIpAddress")
    """The end IP address of the mongo cluster firewall rule. Must be IPv4 format. Required."""

    @overload
    def __init__(
        self,
        *,
        start_ip_address: str,
        end_ip_address: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ListConnectionStringsResult(_model_base.Model):
    """The connection strings for the given mongo cluster.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar connection_strings: An array that contains the connection strings for a mongo cluster.
    :vartype connection_strings: list[~azure.mgmt.mongocluster.models.ConnectionString]
    """

    connection_strings: Optional[List["_models.ConnectionString"]] = rest_field(
        name="connectionStrings", visibility=["read"]
    )
    """An array that contains the connection strings for a mongo cluster."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MongoCluster(TrackedResource):
    """Represents a mongo cluster resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.MongoClusterProperties
    """

    properties: Optional["_models.MongoClusterProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.MongoClusterProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MongoClusterProperties(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The properties of a mongo cluster.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar create_mode: The mode to create a mongo cluster. Known values are: "Default" and
     "PointInTimeRestore".
    :vartype create_mode: str or ~azure.mgmt.mongocluster.models.CreateMode
    :ivar restore_parameters: The parameters to create a point-in-time restore mongo cluster.
    :vartype restore_parameters: ~azure.mgmt.mongocluster.models.MongoClusterRestoreParameters
    :ivar administrator_login: The administrator's login for the mongo cluster.
    :vartype administrator_login: str
    :ivar administrator_login_password: The password of the administrator login.
    :vartype administrator_login_password: str
    :ivar server_version: The Mongo DB server version. Defaults to the latest available version if
     not specified.
    :vartype server_version: str
    :ivar connection_string: The default mongo connection string for the cluster.
    :vartype connection_string: str
    :ivar earliest_restore_time: Earliest restore timestamp in UTC ISO8601 format.
    :vartype earliest_restore_time: str
    :ivar provisioning_state: The provisioning state of the mongo cluster. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", "Updating", and "Dropping".
    :vartype provisioning_state: str or ~azure.mgmt.mongocluster.models.ProvisioningState
    :ivar cluster_status: The status of the mongo cluster. Known values are: "Ready",
     "Provisioning", "Updating", "Starting", "Stopping", "Stopped", and "Dropping".
    :vartype cluster_status: str or ~azure.mgmt.mongocluster.models.MongoClusterStatus
    :ivar public_network_access: Whether or not public endpoint access is allowed for this mongo
     cluster. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.mongocluster.models.PublicNetworkAccess
    :ivar node_group_specs: The list of node group specs in the cluster.
    :vartype node_group_specs: list[~azure.mgmt.mongocluster.models.NodeGroupSpec]
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.mongocluster.models.PrivateEndpointConnection]
    """

    create_mode: Optional[Union[str, "_models.CreateMode"]] = rest_field(name="createMode", visibility=["create"])
    """The mode to create a mongo cluster. Known values are: \"Default\" and \"PointInTimeRestore\"."""
    restore_parameters: Optional["_models.MongoClusterRestoreParameters"] = rest_field(
        name="restoreParameters", visibility=["create"]
    )
    """The parameters to create a point-in-time restore mongo cluster."""
    administrator_login: Optional[str] = rest_field(name="administratorLogin", visibility=["read", "create", "update"])
    """The administrator's login for the mongo cluster."""
    administrator_login_password: Optional[str] = rest_field(
        name="administratorLoginPassword", visibility=["create", "update"]
    )
    """The password of the administrator login."""
    server_version: Optional[str] = rest_field(name="serverVersion")
    """The Mongo DB server version. Defaults to the latest available version if not specified."""
    connection_string: Optional[str] = rest_field(name="connectionString", visibility=["read"])
    """The default mongo connection string for the cluster."""
    earliest_restore_time: Optional[str] = rest_field(name="earliestRestoreTime", visibility=["read"])
    """Earliest restore timestamp in UTC ISO8601 format."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the mongo cluster. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"InProgress\", \"Updating\", and \"Dropping\"."""
    cluster_status: Optional[Union[str, "_models.MongoClusterStatus"]] = rest_field(
        name="clusterStatus", visibility=["read"]
    )
    """The status of the mongo cluster. Known values are: \"Ready\", \"Provisioning\", \"Updating\",
     \"Starting\", \"Stopping\", \"Stopped\", and \"Dropping\"."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(name="publicNetworkAccess")
    """Whether or not public endpoint access is allowed for this mongo cluster. Known values are:
     \"Enabled\" and \"Disabled\"."""
    node_group_specs: Optional[List["_models.NodeGroupSpec"]] = rest_field(name="nodeGroupSpecs")
    """The list of node group specs in the cluster."""
    private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """List of private endpoint connections."""

    @overload
    def __init__(
        self,
        *,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        restore_parameters: Optional["_models.MongoClusterRestoreParameters"] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        server_version: Optional[str] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        node_group_specs: Optional[List["_models.NodeGroupSpec"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MongoClusterRestoreParameters(_model_base.Model):
    """Parameters used for restore operations.

    :ivar point_in_time_u_t_c: UTC point in time to restore a mongo cluster.
    :vartype point_in_time_u_t_c: ~datetime.datetime
    :ivar source_resource_id: Resource ID to locate the source cluster to restore.
    :vartype source_resource_id: str
    """

    point_in_time_u_t_c: Optional[datetime.datetime] = rest_field(name="pointInTimeUTC", format="rfc3339")
    """UTC point in time to restore a mongo cluster."""
    source_resource_id: Optional[str] = rest_field(name="sourceResourceId")
    """Resource ID to locate the source cluster to restore."""

    @overload
    def __init__(
        self,
        *,
        point_in_time_u_t_c: Optional[datetime.datetime] = None,
        source_resource_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MongoClusterUpdate(_model_base.Model):
    """The type used for update operations of the MongoCluster.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties:
    :vartype properties: ~azure.mgmt.mongocluster.models.MongoClusterUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    properties: Optional["_models.MongoClusterUpdateProperties"] = rest_field()

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.MongoClusterUpdateProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MongoClusterUpdateProperties(_model_base.Model):
    """The updatable properties of the MongoCluster.

    :ivar administrator_login: The administrator's login for the mongo cluster.
    :vartype administrator_login: str
    :ivar administrator_login_password: The password of the administrator login.
    :vartype administrator_login_password: str
    :ivar server_version: The Mongo DB server version. Defaults to the latest available version if
     not specified.
    :vartype server_version: str
    :ivar public_network_access: Whether or not public endpoint access is allowed for this mongo
     cluster. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.mongocluster.models.PublicNetworkAccess
    :ivar node_group_specs: The list of node group specs in the cluster.
    :vartype node_group_specs: list[~azure.mgmt.mongocluster.models.NodeGroupSpec]
    """

    administrator_login: Optional[str] = rest_field(name="administratorLogin", visibility=["read", "create", "update"])
    """The administrator's login for the mongo cluster."""
    administrator_login_password: Optional[str] = rest_field(
        name="administratorLoginPassword", visibility=["create", "update"]
    )
    """The password of the administrator login."""
    server_version: Optional[str] = rest_field(name="serverVersion")
    """The Mongo DB server version. Defaults to the latest available version if not specified."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(name="publicNetworkAccess")
    """Whether or not public endpoint access is allowed for this mongo cluster. Known values are:
     \"Enabled\" and \"Disabled\"."""
    node_group_specs: Optional[List["_models.NodeGroupSpec"]] = rest_field(name="nodeGroupSpecs")
    """The list of node group specs in the cluster."""

    @overload
    def __init__(
        self,
        *,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        server_version: Optional[str] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        node_group_specs: Optional[List["_models.NodeGroupSpec"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class NodeGroupSpec(_model_base.Model):
    """Specification for a node group.

    :ivar sku: The resource sku for the node group. This defines the size of CPU and memory that is
     provisioned for each node. Example values: 'M30', 'M40'.
    :vartype sku: str
    :ivar disk_size_g_b: The disk storage size for the node group in GB. Example values: 128, 256,
     512, 1024.
    :vartype disk_size_g_b: int
    :ivar enable_ha: Whether high availability is enabled on the node group.
    :vartype enable_ha: bool
    :ivar kind: The node type deployed in the node group. "Shard"
    :vartype kind: str or ~azure.mgmt.mongocluster.models.NodeKind
    :ivar node_count: The number of nodes in the node group.
    :vartype node_count: int
    """

    sku: Optional[str] = rest_field()
    """The resource sku for the node group. This defines the size of CPU and memory that is
     provisioned for each node. Example values: 'M30', 'M40'."""
    disk_size_g_b: Optional[int] = rest_field(name="diskSizeGB")
    """The disk storage size for the node group in GB. Example values: 128, 256, 512, 1024."""
    enable_ha: Optional[bool] = rest_field(name="enableHa")
    """Whether high availability is enabled on the node group."""
    kind: Optional[Union[str, "_models.NodeKind"]] = rest_field()
    """The node type deployed in the node group. \"Shard\""""
    node_count: Optional[int] = rest_field(name="nodeCount")
    """The number of nodes in the node group."""

    @overload
    def __init__(
        self,
        *,
        sku: Optional[str] = None,
        disk_size_g_b: Optional[int] = None,
        enable_ha: Optional[bool] = None,
        kind: Optional[Union[str, "_models.NodeKind"]] = None,
        node_count: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.mongocluster.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.mongocluster.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.mongocluster.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field()
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field()
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field()
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field()
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field()
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_model_base.Model):
    """The Private Endpoint resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier for private endpoint.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The resource identifier for private endpoint."""


class PrivateEndpointConnection(Resource):
    """The private endpoint connection resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The private endpoint connection properties.
    :vartype properties: ~azure.mgmt.mongocluster.models.PrivateEndpointConnectionProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field()
    """The private endpoint connection properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionProperties(_model_base.Model):
    """Properties of the private endpoint connection.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.mongocluster.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.mongocluster.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.mongocluster.models.PrivateEndpointConnectionProvisioningState
    """

    group_ids: Optional[List[str]] = rest_field(name="groupIds", visibility=["read"])
    """The group ids for the private endpoint resource."""
    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(name="privateEndpoint")
    """The private endpoint resource."""
    private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState" = rest_field(
        name="privateLinkServiceConnectionState"
    )
    """A collection of information about the state of the connection between service consumer and
     provider. Required."""
    provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the private endpoint connection resource. Known values are:
     \"Succeeded\", \"Creating\", \"Deleting\", and \"Failed\"."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.PrivateEndpointConnectionProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateLinkResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateLinkResourceProperties(_model_base.Model):
    """Properties of a private link resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """The private link resource group id."""
    required_members: Optional[List[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """The private link resource required member names."""
    required_zone_names: Optional[List[str]] = rest_field(name="requiredZoneNames")
    """The private link resource private link DNS zone name."""

    @overload
    def __init__(
        self,
        *,
        required_zone_names: Optional[List[str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_model_base.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.mongocluster.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = rest_field()
    """Indicates whether the connection has been Approved/Rejected/Removed by the owner of the
     service. Known values are: \"Pending\", \"Approved\", and \"Rejected\"."""
    description: Optional[str] = rest_field()
    """The reason for approval/rejection of the connection."""
    actions_required: Optional[str] = rest_field(name="actionsRequired")
    """A message indicating if changes on the service provider require any updates on the consumer."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.mongocluster.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.mongocluster.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
