# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.network import NetworkManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-network
# USAGE
    python network_virtual_appliance_put.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = NetworkManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.network_virtual_appliances.begin_create_or_update(
        resource_group_name="rg1",
        network_virtual_appliance_name="nva",
        parameters={
            "identity": {
                "type": "UserAssigned",
                "userAssignedIdentities": {
                    "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": {}
                },
            },
            "location": "West US",
            "properties": {
                "additionalNics": [{"hasPublicIp": True, "name": "exrsdwan"}],
                "bootStrapConfigurationBlobs": [
                    "https://csrncvhdstorage1.blob.core.windows.net/csrncvhdstoragecont/csrbootstrapconfig"
                ],
                "cloudInitConfigurationBlobs": [
                    "https://csrncvhdstorage1.blob.core.windows.net/csrncvhdstoragecont/csrcloudinitconfig"
                ],
                "internetIngressPublicIps": [
                    {
                        "id": "/subscriptions/{{subscriptionId}}/resourceGroups/{{rg}}/providers/Microsoft.Network/publicIPAddresses/slbip"
                    }
                ],
                "networkProfile": {
                    "networkInterfaceConfigurations": [
                        {
                            "properties": {
                                "ipConfigurations": [
                                    {"name": "publicnicipconfig", "properties": {"primary": True}},
                                    {"name": "publicnicipconfig-2", "properties": {"primary": False}},
                                ]
                            },
                            "type": "PublicNic",
                        },
                        {
                            "properties": {
                                "ipConfigurations": [
                                    {"name": "privatenicipconfig", "properties": {"primary": True}},
                                    {"name": "privatenicipconfig-2", "properties": {"primary": False}},
                                ]
                            },
                            "type": "PrivateNic",
                        },
                    ]
                },
                "nvaSku": {"bundledScaleUnit": "1", "marketPlaceVersion": "12.1", "vendor": "Cisco SDWAN"},
                "virtualApplianceAsn": 10000,
                "virtualHub": {
                    "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"
                },
            },
            "tags": {"key1": "value1"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/network/resource-manager/Microsoft.Network/stable/2024-01-01/examples/NetworkVirtualAppliancePut.json
if __name__ == "__main__":
    main()
