# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Account(TrackedResource):
    """An account resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.playwrighttesting.models.AccountProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "AccountProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AccountProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.playwrighttesting.models.AccountProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class AccountListResult(_serialization.Model):
    """The response of a Account list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Account items on this page. Required.
    :vartype value: list[~azure.mgmt.playwrighttesting.models.Account]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Account]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Account"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Account items on this page. Required.
        :paramtype value: list[~azure.mgmt.playwrighttesting.models.Account]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AccountProperties(_serialization.Model):
    """Account properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar dashboard_uri: The Playwright testing dashboard URI for the account resource.
    :vartype dashboard_uri: str
    :ivar regional_affinity: This property sets the connection region for Playwright client workers
     to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure region,
     ensuring lower latency. If disabled, workers connect to browsers in the Azure region in which
     the workspace was initially created. Known values are: "Enabled" and "Disabled".
    :vartype regional_affinity: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar scalable_execution: When enabled, Playwright client workers can connect to cloud-hosted
     browsers. This can increase the number of parallel workers for a test run, significantly
     minimizing test completion durations. Known values are: "Enabled" and "Disabled".
    :vartype scalable_execution: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar reporting: When enabled, this feature allows the workspace to upload and display test
     results, including artifacts like traces and screenshots, in the Playwright portal. This
     enables faster and more efficient troubleshooting. Known values are: "Enabled" and "Disabled".
    :vartype reporting: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.playwrighttesting.models.ProvisioningState
    """

    _validation = {
        "dashboard_uri": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "dashboard_uri": {"key": "dashboardUri", "type": "str"},
        "regional_affinity": {"key": "regionalAffinity", "type": "str"},
        "scalable_execution": {"key": "scalableExecution", "type": "str"},
        "reporting": {"key": "reporting", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        regional_affinity: Optional[Union[str, "_models.EnablementStatus"]] = None,
        scalable_execution: Optional[Union[str, "_models.EnablementStatus"]] = None,
        reporting: Optional[Union[str, "_models.EnablementStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword regional_affinity: This property sets the connection region for Playwright client
         workers to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure
         region, ensuring lower latency. If disabled, workers connect to browsers in the Azure region in
         which the workspace was initially created. Known values are: "Enabled" and "Disabled".
        :paramtype regional_affinity: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
        :keyword scalable_execution: When enabled, Playwright client workers can connect to
         cloud-hosted browsers. This can increase the number of parallel workers for a test run,
         significantly minimizing test completion durations. Known values are: "Enabled" and "Disabled".
        :paramtype scalable_execution: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
        :keyword reporting: When enabled, this feature allows the workspace to upload and display test
         results, including artifacts like traces and screenshots, in the Playwright portal. This
         enables faster and more efficient troubleshooting. Known values are: "Enabled" and "Disabled".
        :paramtype reporting: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
        """
        super().__init__(**kwargs)
        self.dashboard_uri = None
        self.regional_affinity = regional_affinity
        self.scalable_execution = scalable_execution
        self.reporting = reporting
        self.provisioning_state = None


class AccountUpdate(_serialization.Model):
    """The type used for update operations of the Account.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the Account.
    :vartype properties: ~azure.mgmt.playwrighttesting.models.AccountUpdateProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "AccountUpdateProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AccountUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the Account.
        :paramtype properties: ~azure.mgmt.playwrighttesting.models.AccountUpdateProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class AccountUpdateProperties(_serialization.Model):
    """The updatable properties of the Account.

    :ivar regional_affinity: This property sets the connection region for Playwright client workers
     to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure region,
     ensuring lower latency. If disabled, workers connect to browsers in the Azure region in which
     the workspace was initially created. Known values are: "Enabled" and "Disabled".
    :vartype regional_affinity: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar scalable_execution: When enabled, Playwright client workers can connect to cloud-hosted
     browsers. This can increase the number of parallel workers for a test run, significantly
     minimizing test completion durations. Known values are: "Enabled" and "Disabled".
    :vartype scalable_execution: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar reporting: When enabled, this feature allows the workspace to upload and display test
     results, including artifacts like traces and screenshots, in the Playwright portal. This
     enables faster and more efficient troubleshooting. Known values are: "Enabled" and "Disabled".
    :vartype reporting: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    """

    _attribute_map = {
        "regional_affinity": {"key": "regionalAffinity", "type": "str"},
        "scalable_execution": {"key": "scalableExecution", "type": "str"},
        "reporting": {"key": "reporting", "type": "str"},
    }

    def __init__(
        self,
        *,
        regional_affinity: Optional[Union[str, "_models.EnablementStatus"]] = None,
        scalable_execution: Optional[Union[str, "_models.EnablementStatus"]] = None,
        reporting: Optional[Union[str, "_models.EnablementStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword regional_affinity: This property sets the connection region for Playwright client
         workers to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure
         region, ensuring lower latency. If disabled, workers connect to browsers in the Azure region in
         which the workspace was initially created. Known values are: "Enabled" and "Disabled".
        :paramtype regional_affinity: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
        :keyword scalable_execution: When enabled, Playwright client workers can connect to
         cloud-hosted browsers. This can increase the number of parallel workers for a test run,
         significantly minimizing test completion durations. Known values are: "Enabled" and "Disabled".
        :paramtype scalable_execution: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
        :keyword reporting: When enabled, this feature allows the workspace to upload and display test
         results, including artifacts like traces and screenshots, in the Playwright portal. This
         enables faster and more efficient troubleshooting. Known values are: "Enabled" and "Disabled".
        :paramtype reporting: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
        """
        super().__init__(**kwargs)
        self.regional_affinity = regional_affinity
        self.scalable_execution = scalable_execution
        self.reporting = reporting


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.playwrighttesting.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.playwrighttesting.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.playwrighttesting.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.playwrighttesting.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FreeTrialProperties(_serialization.Model):
    """The free-trial properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar account_id: The playwright account id. Required.
    :vartype account_id: str
    :ivar created_at: The free-trial createdAt utcDateTime. Required.
    :vartype created_at: ~datetime.datetime
    :ivar expiry_at: The free-trial expiryAt utcDateTime. Required.
    :vartype expiry_at: ~datetime.datetime
    :ivar allocated_value: The free-trial allocated limit value eg. allocated free minutes.
     Required.
    :vartype allocated_value: int
    :ivar used_value: The free-trial used value eg. used free minutes. Required.
    :vartype used_value: int
    :ivar percentage_used: The free-trial percentage used. Required.
    :vartype percentage_used: float
    :ivar state: The free-trial state. Required. Known values are: "Active" and "Expired".
    :vartype state: str or ~azure.mgmt.playwrighttesting.models.FreeTrialState
    """

    _validation = {
        "account_id": {"required": True, "readonly": True},
        "created_at": {"required": True, "readonly": True},
        "expiry_at": {"required": True, "readonly": True},
        "allocated_value": {"required": True, "readonly": True},
        "used_value": {"required": True, "readonly": True},
        "percentage_used": {"required": True, "readonly": True, "maximum": 100, "minimum": 0},
        "state": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "account_id": {"key": "accountId", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "expiry_at": {"key": "expiryAt", "type": "iso-8601"},
        "allocated_value": {"key": "allocatedValue", "type": "int"},
        "used_value": {"key": "usedValue", "type": "int"},
        "percentage_used": {"key": "percentageUsed", "type": "float"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.account_id = None
        self.created_at = None
        self.expiry_at = None
        self.allocated_value = None
        self.used_value = None
        self.percentage_used = None
        self.state = None


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.playwrighttesting.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.playwrighttesting.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.playwrighttesting.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.playwrighttesting.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.playwrighttesting.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class Quota(ProxyResource):
    """A quota resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.playwrighttesting.models.QuotaProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "QuotaProperties"},
    }

    def __init__(self, *, properties: Optional["_models.QuotaProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.playwrighttesting.models.QuotaProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class QuotaListResult(_serialization.Model):
    """The response of a Quota list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Quota items on this page. Required.
    :vartype value: list[~azure.mgmt.playwrighttesting.models.Quota]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Quota]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Quota"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Quota items on this page. Required.
        :paramtype value: list[~azure.mgmt.playwrighttesting.models.Quota]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaProperties(_serialization.Model):
    """Quota properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar free_trial: The free-trial quota.
    :vartype free_trial: ~azure.mgmt.playwrighttesting.models.FreeTrialProperties
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.playwrighttesting.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "free_trial": {"key": "freeTrial", "type": "FreeTrialProperties"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, free_trial: Optional["_models.FreeTrialProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword free_trial: The free-trial quota.
        :paramtype free_trial: ~azure.mgmt.playwrighttesting.models.FreeTrialProperties
        """
        super().__init__(**kwargs)
        self.free_trial = free_trial
        self.provisioning_state = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.playwrighttesting.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.playwrighttesting.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.playwrighttesting.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.playwrighttesting.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
