# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, Literal, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_create_or_update_request(
    resource_group_name: str,
    server_name: str,
    vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
    baseline_name: Union[str, _models.BaselineName],
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    system_database_name: Literal["master"] = kwargs.pop(
        "system_database_name", _params.pop("systemDatabaseName", "master")
    )
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2022-11-01-preview"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "serverName": _SERIALIZER.url("server_name", server_name, "str"),
        "vulnerabilityAssessmentName": _SERIALIZER.url(
            "vulnerability_assessment_name", vulnerability_assessment_name, "str"
        ),
        "baselineName": _SERIALIZER.url("baseline_name", baseline_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["systemDatabaseName"] = _SERIALIZER.query("system_database_name", system_database_name, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


class SqlVulnerabilityAssessmentBaselinesOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.sql.SqlManagementClient`'s
        :attr:`sql_vulnerability_assessment_baselines` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def create_or_update(
        self,
        resource_group_name: str,
        server_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        baseline_name: Union[str, _models.BaselineName],
        parameters: _models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseSqlVulnerabilityAssessmentBaselineSet:
        """Add a database's vulnerability assessment rule baseline list.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param server_name: The name of the server. Required.
        :type server_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param baseline_name: "default" Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.BaselineName
        :param parameters: The requested rule baseline resource. Required.
        :type parameters:
         ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseSqlVulnerabilityAssessmentBaselineSet or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentBaselineSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_update(
        self,
        resource_group_name: str,
        server_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        baseline_name: Union[str, _models.BaselineName],
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseSqlVulnerabilityAssessmentBaselineSet:
        """Add a database's vulnerability assessment rule baseline list.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param server_name: The name of the server. Required.
        :type server_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param baseline_name: "default" Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.BaselineName
        :param parameters: The requested rule baseline resource. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseSqlVulnerabilityAssessmentBaselineSet or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentBaselineSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_or_update(
        self,
        resource_group_name: str,
        server_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        baseline_name: Union[str, _models.BaselineName],
        parameters: Union[_models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput, IO[bytes]],
        **kwargs: Any
    ) -> _models.DatabaseSqlVulnerabilityAssessmentBaselineSet:
        """Add a database's vulnerability assessment rule baseline list.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param server_name: The name of the server. Required.
        :type server_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param baseline_name: "default" Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.BaselineName
        :param parameters: The requested rule baseline resource. Is either a
         DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput type or a IO[bytes] type. Required.
        :type parameters:
         ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput or IO[bytes]
        :return: DatabaseSqlVulnerabilityAssessmentBaselineSet or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentBaselineSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        system_database_name: Literal["master"] = kwargs.pop(
            "system_database_name", _params.pop("systemDatabaseName", "master")
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2022-11-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DatabaseSqlVulnerabilityAssessmentBaselineSet] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput")

        _request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            server_name=server_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            baseline_name=baseline_name,
            subscription_id=self._config.subscription_id,
            system_database_name=system_database_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseSqlVulnerabilityAssessmentBaselineSet", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
