# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservice.aio import ContainerServiceClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceOpenShiftManagedClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.open_shift_managed_clusters.list(
            api_version="2019-09-30-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.open_shift_managed_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2019-09-30-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.open_shift_managed_clusters.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2019-09-30-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.open_shift_managed_clusters.begin_create_or_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                parameters={
                    "location": "str",
                    "agentPoolProfiles": [
                        {
                            "count": 0,
                            "name": "str",
                            "vmSize": "str",
                            "osType": "Linux",
                            "role": "str",
                            "subnetCidr": "10.0.0.0/24",
                        }
                    ],
                    "authProfile": {
                        "identityProviders": [
                            {"name": "str", "provider": "open_shift_managed_cluster_base_identity_provider"}
                        ]
                    },
                    "clusterVersion": "str",
                    "fqdn": "str",
                    "id": "str",
                    "masterPoolProfile": {
                        "count": 0,
                        "vmSize": "str",
                        "name": "str",
                        "osType": "Linux",
                        "subnetCidr": "str",
                    },
                    "monitorProfile": {"enabled": bool, "workspaceResourceID": "str"},
                    "name": "str",
                    "networkProfile": {"peerVnetId": "str", "vnetCidr": "10.0.0.0/8", "vnetId": "str"},
                    "openShiftVersion": "str",
                    "plan": {"name": "str", "product": "str", "promotionCode": "str", "publisher": "str"},
                    "provisioningState": "str",
                    "publicHostname": "str",
                    "routerProfiles": [{"fqdn": "str", "name": "str", "publicSubdomain": "str"}],
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2019-09-30-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update_tags(self, resource_group):
        response = await (
            await self.client.open_shift_managed_clusters.begin_update_tags(
                resource_group_name=resource_group.name,
                resource_name="str",
                parameters={"tags": {"str": "str"}},
                api_version="2019-09-30-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.open_shift_managed_clusters.begin_delete(
                resource_group_name=resource_group.name,
                resource_name="str",
                api_version="2019-09-30-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
