# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class BgpSession(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The properties that define a BGP session.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar session_prefix_v4: The IPv4 prefix that contains both ends' IPv4 addresses.
    :vartype session_prefix_v4: str
    :ivar session_prefix_v6: The IPv6 prefix that contains both ends' IPv6 addresses.
    :vartype session_prefix_v6: str
    :ivar microsoft_session_i_pv4_address: The IPv4 session address on Microsoft's end.
    :vartype microsoft_session_i_pv4_address: str
    :ivar microsoft_session_i_pv6_address: The IPv6 session address on Microsoft's end.
    :vartype microsoft_session_i_pv6_address: str
    :ivar peer_session_i_pv4_address: The IPv4 session address on peer's end.
    :vartype peer_session_i_pv4_address: str
    :ivar peer_session_i_pv6_address: The IPv6 session address on peer's end.
    :vartype peer_session_i_pv6_address: str
    :ivar session_state_v4: The state of the IPv4 session. Known values are: "None", "Idle",
     "Connect", "Active", "OpenSent", "OpenConfirm", "OpenReceived", "Established", "PendingAdd",
     "PendingUpdate", and "PendingRemove".
    :vartype session_state_v4: str or ~azure.mgmt.peering.models.SessionStateV4
    :ivar session_state_v6: The state of the IPv6 session. Known values are: "None", "Idle",
     "Connect", "Active", "OpenSent", "OpenConfirm", "OpenReceived", "Established", "PendingAdd",
     "PendingUpdate", and "PendingRemove".
    :vartype session_state_v6: str or ~azure.mgmt.peering.models.SessionStateV6
    :ivar max_prefixes_advertised_v4: The maximum number of prefixes advertised over the IPv4
     session.
    :vartype max_prefixes_advertised_v4: int
    :ivar max_prefixes_advertised_v6: The maximum number of prefixes advertised over the IPv6
     session.
    :vartype max_prefixes_advertised_v6: int
    :ivar md5_authentication_key: The MD5 authentication key of the session.
    :vartype md5_authentication_key: str
    """

    _validation = {
        "session_state_v4": {"readonly": True},
        "session_state_v6": {"readonly": True},
    }

    _attribute_map = {
        "session_prefix_v4": {"key": "sessionPrefixV4", "type": "str"},
        "session_prefix_v6": {"key": "sessionPrefixV6", "type": "str"},
        "microsoft_session_i_pv4_address": {"key": "microsoftSessionIPv4Address", "type": "str"},
        "microsoft_session_i_pv6_address": {"key": "microsoftSessionIPv6Address", "type": "str"},
        "peer_session_i_pv4_address": {"key": "peerSessionIPv4Address", "type": "str"},
        "peer_session_i_pv6_address": {"key": "peerSessionIPv6Address", "type": "str"},
        "session_state_v4": {"key": "sessionStateV4", "type": "str"},
        "session_state_v6": {"key": "sessionStateV6", "type": "str"},
        "max_prefixes_advertised_v4": {"key": "maxPrefixesAdvertisedV4", "type": "int"},
        "max_prefixes_advertised_v6": {"key": "maxPrefixesAdvertisedV6", "type": "int"},
        "md5_authentication_key": {"key": "md5AuthenticationKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        session_prefix_v4: Optional[str] = None,
        session_prefix_v6: Optional[str] = None,
        microsoft_session_i_pv4_address: Optional[str] = None,
        microsoft_session_i_pv6_address: Optional[str] = None,
        peer_session_i_pv4_address: Optional[str] = None,
        peer_session_i_pv6_address: Optional[str] = None,
        max_prefixes_advertised_v4: Optional[int] = None,
        max_prefixes_advertised_v6: Optional[int] = None,
        md5_authentication_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword session_prefix_v4: The IPv4 prefix that contains both ends' IPv4 addresses.
        :paramtype session_prefix_v4: str
        :keyword session_prefix_v6: The IPv6 prefix that contains both ends' IPv6 addresses.
        :paramtype session_prefix_v6: str
        :keyword microsoft_session_i_pv4_address: The IPv4 session address on Microsoft's end.
        :paramtype microsoft_session_i_pv4_address: str
        :keyword microsoft_session_i_pv6_address: The IPv6 session address on Microsoft's end.
        :paramtype microsoft_session_i_pv6_address: str
        :keyword peer_session_i_pv4_address: The IPv4 session address on peer's end.
        :paramtype peer_session_i_pv4_address: str
        :keyword peer_session_i_pv6_address: The IPv6 session address on peer's end.
        :paramtype peer_session_i_pv6_address: str
        :keyword max_prefixes_advertised_v4: The maximum number of prefixes advertised over the IPv4
         session.
        :paramtype max_prefixes_advertised_v4: int
        :keyword max_prefixes_advertised_v6: The maximum number of prefixes advertised over the IPv6
         session.
        :paramtype max_prefixes_advertised_v6: int
        :keyword md5_authentication_key: The MD5 authentication key of the session.
        :paramtype md5_authentication_key: str
        """
        super().__init__(**kwargs)
        self.session_prefix_v4 = session_prefix_v4
        self.session_prefix_v6 = session_prefix_v6
        self.microsoft_session_i_pv4_address = microsoft_session_i_pv4_address
        self.microsoft_session_i_pv6_address = microsoft_session_i_pv6_address
        self.peer_session_i_pv4_address = peer_session_i_pv4_address
        self.peer_session_i_pv6_address = peer_session_i_pv6_address
        self.session_state_v4 = None
        self.session_state_v6 = None
        self.max_prefixes_advertised_v4 = max_prefixes_advertised_v4
        self.max_prefixes_advertised_v6 = max_prefixes_advertised_v6
        self.md5_authentication_key = md5_authentication_key


class Resource(_serialization.Model):
    """The ARM resource class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None


class CdnPeeringPrefix(Resource):
    """The CDN peering prefix.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar prefix: The prefix.
    :vartype prefix: str
    :ivar azure_region: The Azure region.
    :vartype azure_region: str
    :ivar azure_service: The Azure service.
    :vartype azure_service: str
    :ivar is_primary_region: The flag that indicates whether or not this is the primary region.
    :vartype is_primary_region: bool
    :ivar bgp_community: The BGP Community.
    :vartype bgp_community: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "prefix": {"readonly": True},
        "azure_region": {"readonly": True},
        "azure_service": {"readonly": True},
        "is_primary_region": {"readonly": True},
        "bgp_community": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "prefix": {"key": "properties.prefix", "type": "str"},
        "azure_region": {"key": "properties.azureRegion", "type": "str"},
        "azure_service": {"key": "properties.azureService", "type": "str"},
        "is_primary_region": {"key": "properties.isPrimaryRegion", "type": "bool"},
        "bgp_community": {"key": "properties.bgpCommunity", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.prefix = None
        self.azure_region = None
        self.azure_service = None
        self.is_primary_region = None
        self.bgp_community = None


class CdnPeeringPrefixListResult(_serialization.Model):
    """The paginated list of CDN peering prefixes.

    :ivar value: The list of CDN peering prefixes.
    :vartype value: list[~azure.mgmt.peering.models.CdnPeeringPrefix]
    :ivar next_link: The link to fetch the next page of CDN peering prefixes.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CdnPeeringPrefix]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CdnPeeringPrefix"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of CDN peering prefixes.
        :paramtype value: list[~azure.mgmt.peering.models.CdnPeeringPrefix]
        :keyword next_link: The link to fetch the next page of CDN peering prefixes.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CheckServiceProviderAvailabilityInput(_serialization.Model):
    """Class for CheckServiceProviderAvailabilityInput.

    :ivar peering_service_location: Gets or sets the peering service location.
    :vartype peering_service_location: str
    :ivar peering_service_provider: Gets or sets the peering service provider.
    :vartype peering_service_provider: str
    """

    _attribute_map = {
        "peering_service_location": {"key": "peeringServiceLocation", "type": "str"},
        "peering_service_provider": {"key": "peeringServiceProvider", "type": "str"},
    }

    def __init__(
        self,
        *,
        peering_service_location: Optional[str] = None,
        peering_service_provider: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword peering_service_location: Gets or sets the peering service location.
        :paramtype peering_service_location: str
        :keyword peering_service_provider: Gets or sets the peering service provider.
        :paramtype peering_service_provider: str
        """
        super().__init__(**kwargs)
        self.peering_service_location = peering_service_location
        self.peering_service_provider = peering_service_provider


class ConnectionMonitorTest(Resource):
    """The Connection Monitor Test class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar source_agent: The Connection Monitor test source agent.
    :vartype source_agent: str
    :ivar destination: The Connection Monitor test destination.
    :vartype destination: str
    :ivar destination_port: The Connection Monitor test destination port.
    :vartype destination_port: int
    :ivar test_frequency_in_sec: The Connection Monitor test frequency in seconds.
    :vartype test_frequency_in_sec: int
    :ivar is_test_successful: The flag that indicates if the Connection Monitor test is successful
     or not.
    :vartype is_test_successful: bool
    :ivar path: The path representing the Connection Monitor test.
    :vartype path: list[str]
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "is_test_successful": {"readonly": True},
        "path": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "source_agent": {"key": "properties.sourceAgent", "type": "str"},
        "destination": {"key": "properties.destination", "type": "str"},
        "destination_port": {"key": "properties.destinationPort", "type": "int"},
        "test_frequency_in_sec": {"key": "properties.testFrequencyInSec", "type": "int"},
        "is_test_successful": {"key": "properties.isTestSuccessful", "type": "bool"},
        "path": {"key": "properties.path", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_agent: Optional[str] = None,
        destination: Optional[str] = None,
        destination_port: Optional[int] = None,
        test_frequency_in_sec: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword source_agent: The Connection Monitor test source agent.
        :paramtype source_agent: str
        :keyword destination: The Connection Monitor test destination.
        :paramtype destination: str
        :keyword destination_port: The Connection Monitor test destination port.
        :paramtype destination_port: int
        :keyword test_frequency_in_sec: The Connection Monitor test frequency in seconds.
        :paramtype test_frequency_in_sec: int
        """
        super().__init__(**kwargs)
        self.source_agent = source_agent
        self.destination = destination
        self.destination_port = destination_port
        self.test_frequency_in_sec = test_frequency_in_sec
        self.is_test_successful = None
        self.path = None
        self.provisioning_state = None


class ConnectionMonitorTestListResult(_serialization.Model):
    """The paginated list of Connection Monitor Tests.

    :ivar value: The list of Connection Monitor Tests.
    :vartype value: list[~azure.mgmt.peering.models.ConnectionMonitorTest]
    :ivar next_link: The link to fetch the next page of Connection Monitor Tests.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectionMonitorTest]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConnectionMonitorTest"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of Connection Monitor Tests.
        :paramtype value: list[~azure.mgmt.peering.models.ConnectionMonitorTest]
        :keyword next_link: The link to fetch the next page of Connection Monitor Tests.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ContactDetail(_serialization.Model):
    """The contact detail class.

    :ivar role: The role of the contact. Known values are: "Noc", "Policy", "Technical", "Service",
     "Escalation", and "Other".
    :vartype role: str or ~azure.mgmt.peering.models.Role
    :ivar email: The e-mail address of the contact.
    :vartype email: str
    :ivar phone: The phone number of the contact.
    :vartype phone: str
    """

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(
        self,
        *,
        role: Optional[Union[str, "_models.Role"]] = None,
        email: Optional[str] = None,
        phone: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword role: The role of the contact. Known values are: "Noc", "Policy", "Technical",
         "Service", "Escalation", and "Other".
        :paramtype role: str or ~azure.mgmt.peering.models.Role
        :keyword email: The e-mail address of the contact.
        :paramtype email: str
        :keyword phone: The phone number of the contact.
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.role = role
        self.email = email
        self.phone = phone


class DirectConnection(_serialization.Model):
    """The properties that define a direct connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar bandwidth_in_mbps: The bandwidth of the connection.
    :vartype bandwidth_in_mbps: int
    :ivar provisioned_bandwidth_in_mbps: The bandwidth that is actually provisioned.
    :vartype provisioned_bandwidth_in_mbps: int
    :ivar session_address_provider: The field indicating if Microsoft provides session ip
     addresses. Known values are: "Microsoft" and "Peer".
    :vartype session_address_provider: str or ~azure.mgmt.peering.models.SessionAddressProvider
    :ivar use_for_peering_service: The flag that indicates whether or not the connection is used
     for peering service.
    :vartype use_for_peering_service: bool
    :ivar microsoft_tracking_id: The ID used within Microsoft's peering provisioning system to
     track the connection.
    :vartype microsoft_tracking_id: str
    :ivar peering_db_facility_id: The PeeringDB.com ID of the facility at which the connection has
     to be set up.
    :vartype peering_db_facility_id: int
    :ivar connection_state: The state of the connection. Known values are: "None",
     "PendingApproval", "Approved", "ProvisioningStarted", "ProvisioningFailed",
     "ProvisioningCompleted", "Validating", "Active", "TypeChangeRequested", and
     "TypeChangeInProgress".
    :vartype connection_state: str or ~azure.mgmt.peering.models.ConnectionState
    :ivar bgp_session: The BGP session associated with the connection.
    :vartype bgp_session: ~azure.mgmt.peering.models.BgpSession
    :ivar connection_identifier: The unique identifier (GUID) for the connection.
    :vartype connection_identifier: str
    :ivar error_message: The error message related to the connection state, if any.
    :vartype error_message: str
    """

    _validation = {
        "provisioned_bandwidth_in_mbps": {"readonly": True},
        "microsoft_tracking_id": {"readonly": True},
        "connection_state": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "bandwidth_in_mbps": {"key": "bandwidthInMbps", "type": "int"},
        "provisioned_bandwidth_in_mbps": {"key": "provisionedBandwidthInMbps", "type": "int"},
        "session_address_provider": {"key": "sessionAddressProvider", "type": "str"},
        "use_for_peering_service": {"key": "useForPeeringService", "type": "bool"},
        "microsoft_tracking_id": {"key": "microsoftTrackingId", "type": "str"},
        "peering_db_facility_id": {"key": "peeringDBFacilityId", "type": "int"},
        "connection_state": {"key": "connectionState", "type": "str"},
        "bgp_session": {"key": "bgpSession", "type": "BgpSession"},
        "connection_identifier": {"key": "connectionIdentifier", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        bandwidth_in_mbps: Optional[int] = None,
        session_address_provider: Optional[Union[str, "_models.SessionAddressProvider"]] = None,
        use_for_peering_service: Optional[bool] = None,
        peering_db_facility_id: Optional[int] = None,
        bgp_session: Optional["_models.BgpSession"] = None,
        connection_identifier: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword bandwidth_in_mbps: The bandwidth of the connection.
        :paramtype bandwidth_in_mbps: int
        :keyword session_address_provider: The field indicating if Microsoft provides session ip
         addresses. Known values are: "Microsoft" and "Peer".
        :paramtype session_address_provider: str or ~azure.mgmt.peering.models.SessionAddressProvider
        :keyword use_for_peering_service: The flag that indicates whether or not the connection is used
         for peering service.
        :paramtype use_for_peering_service: bool
        :keyword peering_db_facility_id: The PeeringDB.com ID of the facility at which the connection
         has to be set up.
        :paramtype peering_db_facility_id: int
        :keyword bgp_session: The BGP session associated with the connection.
        :paramtype bgp_session: ~azure.mgmt.peering.models.BgpSession
        :keyword connection_identifier: The unique identifier (GUID) for the connection.
        :paramtype connection_identifier: str
        """
        super().__init__(**kwargs)
        self.bandwidth_in_mbps = bandwidth_in_mbps
        self.provisioned_bandwidth_in_mbps = None
        self.session_address_provider = session_address_provider
        self.use_for_peering_service = use_for_peering_service
        self.microsoft_tracking_id = None
        self.peering_db_facility_id = peering_db_facility_id
        self.connection_state = None
        self.bgp_session = bgp_session
        self.connection_identifier = connection_identifier
        self.error_message = None


class DirectPeeringFacility(_serialization.Model):
    """The properties that define a direct peering facility.

    :ivar address: The address of the direct peering facility.
    :vartype address: str
    :ivar direct_peering_type: The type of the direct peering. Known values are: "Edge", "Transit",
     "Cdn", "Internal", "Ix", "IxRs", "Voice", and "EdgeZoneForOperators".
    :vartype direct_peering_type: str or ~azure.mgmt.peering.models.DirectPeeringType
    :ivar peering_db_facility_id: The PeeringDB.com ID of the facility.
    :vartype peering_db_facility_id: int
    :ivar peering_db_facility_link: The PeeringDB.com URL of the facility.
    :vartype peering_db_facility_link: str
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "direct_peering_type": {"key": "directPeeringType", "type": "str"},
        "peering_db_facility_id": {"key": "peeringDBFacilityId", "type": "int"},
        "peering_db_facility_link": {"key": "peeringDBFacilityLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        direct_peering_type: Optional[Union[str, "_models.DirectPeeringType"]] = None,
        peering_db_facility_id: Optional[int] = None,
        peering_db_facility_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword address: The address of the direct peering facility.
        :paramtype address: str
        :keyword direct_peering_type: The type of the direct peering. Known values are: "Edge",
         "Transit", "Cdn", "Internal", "Ix", "IxRs", "Voice", and "EdgeZoneForOperators".
        :paramtype direct_peering_type: str or ~azure.mgmt.peering.models.DirectPeeringType
        :keyword peering_db_facility_id: The PeeringDB.com ID of the facility.
        :paramtype peering_db_facility_id: int
        :keyword peering_db_facility_link: The PeeringDB.com URL of the facility.
        :paramtype peering_db_facility_link: str
        """
        super().__init__(**kwargs)
        self.address = address
        self.direct_peering_type = direct_peering_type
        self.peering_db_facility_id = peering_db_facility_id
        self.peering_db_facility_link = peering_db_facility_link


class ErrorDetail(_serialization.Model):
    """The error detail that describes why an operation has failed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None


class ErrorResponse(_serialization.Model):
    """The error response that indicates why an operation has failed.

    :ivar error: The error detail that describes why an operation has failed.
    :vartype error: ~azure.mgmt.peering.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error detail that describes why an operation has failed.
        :paramtype error: ~azure.mgmt.peering.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExchangeConnection(_serialization.Model):
    """The properties that define an exchange connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar peering_db_facility_id: The PeeringDB.com ID of the facility at which the connection has
     to be set up.
    :vartype peering_db_facility_id: int
    :ivar connection_state: The state of the connection. Known values are: "None",
     "PendingApproval", "Approved", "ProvisioningStarted", "ProvisioningFailed",
     "ProvisioningCompleted", "Validating", "Active", "TypeChangeRequested", and
     "TypeChangeInProgress".
    :vartype connection_state: str or ~azure.mgmt.peering.models.ConnectionState
    :ivar bgp_session: The BGP session associated with the connection.
    :vartype bgp_session: ~azure.mgmt.peering.models.BgpSession
    :ivar connection_identifier: The unique identifier (GUID) for the connection.
    :vartype connection_identifier: str
    :ivar error_message: The error message related to the connection state, if any.
    :vartype error_message: str
    """

    _validation = {
        "connection_state": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "peering_db_facility_id": {"key": "peeringDBFacilityId", "type": "int"},
        "connection_state": {"key": "connectionState", "type": "str"},
        "bgp_session": {"key": "bgpSession", "type": "BgpSession"},
        "connection_identifier": {"key": "connectionIdentifier", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        peering_db_facility_id: Optional[int] = None,
        bgp_session: Optional["_models.BgpSession"] = None,
        connection_identifier: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword peering_db_facility_id: The PeeringDB.com ID of the facility at which the connection
         has to be set up.
        :paramtype peering_db_facility_id: int
        :keyword bgp_session: The BGP session associated with the connection.
        :paramtype bgp_session: ~azure.mgmt.peering.models.BgpSession
        :keyword connection_identifier: The unique identifier (GUID) for the connection.
        :paramtype connection_identifier: str
        """
        super().__init__(**kwargs)
        self.peering_db_facility_id = peering_db_facility_id
        self.connection_state = None
        self.bgp_session = bgp_session
        self.connection_identifier = connection_identifier
        self.error_message = None


class ExchangePeeringFacility(_serialization.Model):
    """The properties that define an exchange peering facility.

    :ivar exchange_name: The name of the exchange peering facility.
    :vartype exchange_name: str
    :ivar bandwidth_in_mbps: The bandwidth of the connection between Microsoft and the exchange
     peering facility.
    :vartype bandwidth_in_mbps: int
    :ivar microsoft_i_pv4_address: The IPv4 address of Microsoft at the exchange peering facility.
    :vartype microsoft_i_pv4_address: str
    :ivar microsoft_i_pv6_address: The IPv6 address of Microsoft at the exchange peering facility.
    :vartype microsoft_i_pv6_address: str
    :ivar facility_i_pv4_prefix: The IPv4 prefixes associated with the exchange peering facility.
    :vartype facility_i_pv4_prefix: str
    :ivar facility_i_pv6_prefix: The IPv6 prefixes associated with the exchange peering facility.
    :vartype facility_i_pv6_prefix: str
    :ivar peering_db_facility_id: The PeeringDB.com ID of the facility.
    :vartype peering_db_facility_id: int
    :ivar peering_db_facility_link: The PeeringDB.com URL of the facility.
    :vartype peering_db_facility_link: str
    """

    _attribute_map = {
        "exchange_name": {"key": "exchangeName", "type": "str"},
        "bandwidth_in_mbps": {"key": "bandwidthInMbps", "type": "int"},
        "microsoft_i_pv4_address": {"key": "microsoftIPv4Address", "type": "str"},
        "microsoft_i_pv6_address": {"key": "microsoftIPv6Address", "type": "str"},
        "facility_i_pv4_prefix": {"key": "facilityIPv4Prefix", "type": "str"},
        "facility_i_pv6_prefix": {"key": "facilityIPv6Prefix", "type": "str"},
        "peering_db_facility_id": {"key": "peeringDBFacilityId", "type": "int"},
        "peering_db_facility_link": {"key": "peeringDBFacilityLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        exchange_name: Optional[str] = None,
        bandwidth_in_mbps: Optional[int] = None,
        microsoft_i_pv4_address: Optional[str] = None,
        microsoft_i_pv6_address: Optional[str] = None,
        facility_i_pv4_prefix: Optional[str] = None,
        facility_i_pv6_prefix: Optional[str] = None,
        peering_db_facility_id: Optional[int] = None,
        peering_db_facility_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword exchange_name: The name of the exchange peering facility.
        :paramtype exchange_name: str
        :keyword bandwidth_in_mbps: The bandwidth of the connection between Microsoft and the exchange
         peering facility.
        :paramtype bandwidth_in_mbps: int
        :keyword microsoft_i_pv4_address: The IPv4 address of Microsoft at the exchange peering
         facility.
        :paramtype microsoft_i_pv4_address: str
        :keyword microsoft_i_pv6_address: The IPv6 address of Microsoft at the exchange peering
         facility.
        :paramtype microsoft_i_pv6_address: str
        :keyword facility_i_pv4_prefix: The IPv4 prefixes associated with the exchange peering
         facility.
        :paramtype facility_i_pv4_prefix: str
        :keyword facility_i_pv6_prefix: The IPv6 prefixes associated with the exchange peering
         facility.
        :paramtype facility_i_pv6_prefix: str
        :keyword peering_db_facility_id: The PeeringDB.com ID of the facility.
        :paramtype peering_db_facility_id: int
        :keyword peering_db_facility_link: The PeeringDB.com URL of the facility.
        :paramtype peering_db_facility_link: str
        """
        super().__init__(**kwargs)
        self.exchange_name = exchange_name
        self.bandwidth_in_mbps = bandwidth_in_mbps
        self.microsoft_i_pv4_address = microsoft_i_pv4_address
        self.microsoft_i_pv6_address = microsoft_i_pv6_address
        self.facility_i_pv4_prefix = facility_i_pv4_prefix
        self.facility_i_pv6_prefix = facility_i_pv6_prefix
        self.peering_db_facility_id = peering_db_facility_id
        self.peering_db_facility_link = peering_db_facility_link


class LogAnalyticsWorkspaceProperties(_serialization.Model):
    """The properties that define a Log Analytics Workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar workspace_id: The Workspace ID.
    :vartype workspace_id: str
    :ivar key: The Workspace Key.
    :vartype key: str
    :ivar connected_agents: The list of connected agents.
    :vartype connected_agents: list[str]
    """

    _validation = {
        "workspace_id": {"readonly": True},
        "key": {"readonly": True},
        "connected_agents": {"readonly": True},
    }

    _attribute_map = {
        "workspace_id": {"key": "workspaceID", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "connected_agents": {"key": "connectedAgents", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.workspace_id = None
        self.key = None
        self.connected_agents = None


class LookingGlassOutput(_serialization.Model):
    """Looking glass output model.

    :ivar command: Invoked command. Known values are: "Traceroute", "Ping", and "BgpRoute".
    :vartype command: str or ~azure.mgmt.peering.models.Command
    :ivar output: Output of the command.
    :vartype output: str
    """

    _attribute_map = {
        "command": {"key": "command", "type": "str"},
        "output": {"key": "output", "type": "str"},
    }

    def __init__(
        self, *, command: Optional[Union[str, "_models.Command"]] = None, output: Optional[str] = None, **kwargs
    ):
        """
        :keyword command: Invoked command. Known values are: "Traceroute", "Ping", and "BgpRoute".
        :paramtype command: str or ~azure.mgmt.peering.models.Command
        :keyword output: Output of the command.
        :paramtype output: str
        """
        super().__init__(**kwargs)
        self.command = command
        self.output = output


class MetricDimension(_serialization.Model):
    """Dimensions of the metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the dimension.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the dimension.
    :vartype display_name: str
    """

    _validation = {
        "name": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.display_name = None


class MetricSpecification(_serialization.Model):
    """Specifications of the Metrics for Azure Monitoring.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the metric.
    :vartype display_name: str
    :ivar display_description: Localized friendly description of the metric.
    :vartype display_description: str
    :ivar unit: Unit that makes sense for the metric.
    :vartype unit: str
    :ivar aggregation_type: Aggregation type will be set to one of the values: Average, Minimum,
     Maximum, Total, Count.
    :vartype aggregation_type: str
    :ivar supported_time_grain_types: Supported time grain types for the metric.
    :vartype supported_time_grain_types: list[str]
    :ivar dimensions: Dimensions of the metric.
    :vartype dimensions: list[~azure.mgmt.peering.models.MetricDimension]
    """

    _validation = {
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "display_description": {"readonly": True},
        "unit": {"readonly": True},
        "aggregation_type": {"readonly": True},
        "supported_time_grain_types": {"readonly": True},
        "dimensions": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.display_description = None
        self.unit = None
        self.aggregation_type = None
        self.supported_time_grain_types = None
        self.dimensions = None


class Operation(_serialization.Model):
    """The peering API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation.
    :vartype name: str
    :ivar display: The information related to the operation.
    :vartype display: ~azure.mgmt.peering.models.OperationDisplayInfo
    :ivar is_data_action: The flag that indicates whether the operation applies to data plane.
    :vartype is_data_action: bool
    :ivar service_specification: Service specification payload.
    :vartype service_specification: ~azure.mgmt.peering.models.ServiceSpecification
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
        "is_data_action": {"readonly": True},
        "service_specification": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplayInfo"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.display = None
        self.is_data_action = None
        self.service_specification = None


class OperationDisplayInfo(_serialization.Model):
    """The information related to the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The name of the resource provider.
    :vartype provider: str
    :ivar resource: The type of the resource.
    :vartype resource: str
    :ivar operation: The name of the operation.
    :vartype operation: str
    :ivar description: The description of the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """The paginated list of peering API operations.

    :ivar value: The list of peering API operations.
    :vartype value: list[~azure.mgmt.peering.models.Operation]
    :ivar next_link: The link to fetch the next page of peering API operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of peering API operations.
        :paramtype value: list[~azure.mgmt.peering.models.Operation]
        :keyword next_link: The link to fetch the next page of peering API operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeerAsn(Resource):
    """The essential information related to the peer's ASN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar peer_asn: The Autonomous System Number (ASN) of the peer.
    :vartype peer_asn: int
    :ivar peer_contact_detail: The contact details of the peer.
    :vartype peer_contact_detail: list[~azure.mgmt.peering.models.ContactDetail]
    :ivar peer_name: The name of the peer.
    :vartype peer_name: str
    :ivar validation_state: The validation state of the ASN associated with the peer. Known values
     are: "None", "Pending", "Approved", and "Failed".
    :vartype validation_state: str or ~azure.mgmt.peering.models.ValidationState
    :ivar error_message: The error message for the validation state.
    :vartype error_message: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "validation_state": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "peer_asn": {"key": "properties.peerAsn", "type": "int"},
        "peer_contact_detail": {"key": "properties.peerContactDetail", "type": "[ContactDetail]"},
        "peer_name": {"key": "properties.peerName", "type": "str"},
        "validation_state": {"key": "properties.validationState", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        peer_asn: Optional[int] = None,
        peer_contact_detail: Optional[List["_models.ContactDetail"]] = None,
        peer_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword peer_asn: The Autonomous System Number (ASN) of the peer.
        :paramtype peer_asn: int
        :keyword peer_contact_detail: The contact details of the peer.
        :paramtype peer_contact_detail: list[~azure.mgmt.peering.models.ContactDetail]
        :keyword peer_name: The name of the peer.
        :paramtype peer_name: str
        """
        super().__init__(**kwargs)
        self.peer_asn = peer_asn
        self.peer_contact_detail = peer_contact_detail
        self.peer_name = peer_name
        self.validation_state = None
        self.error_message = None


class PeerAsnListResult(_serialization.Model):
    """The paginated list of peer ASNs.

    :ivar value: The list of peer ASNs.
    :vartype value: list[~azure.mgmt.peering.models.PeerAsn]
    :ivar next_link: The link to fetch the next page of peer ASNs.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeerAsn]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PeerAsn"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of peer ASNs.
        :paramtype value: list[~azure.mgmt.peering.models.PeerAsn]
        :keyword next_link: The link to fetch the next page of peer ASNs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Peering(Resource):  # pylint: disable=too-many-instance-attributes
    """Peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar sku: The SKU that defines the tier and kind of the peering. Required.
    :vartype sku: ~azure.mgmt.peering.models.PeeringSku
    :ivar kind: The kind of the peering. Required. Known values are: "Direct" and "Exchange".
    :vartype kind: str or ~azure.mgmt.peering.models.Kind
    :ivar location: The location of the resource. Required.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar direct: The properties that define a direct peering.
    :vartype direct: ~azure.mgmt.peering.models.PeeringPropertiesDirect
    :ivar exchange: The properties that define an exchange peering.
    :vartype exchange: ~azure.mgmt.peering.models.PeeringPropertiesExchange
    :ivar peering_location: The location of the peering.
    :vartype peering_location: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "sku": {"required": True},
        "kind": {"required": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "PeeringSku"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "direct": {"key": "properties.direct", "type": "PeeringPropertiesDirect"},
        "exchange": {"key": "properties.exchange", "type": "PeeringPropertiesExchange"},
        "peering_location": {"key": "properties.peeringLocation", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku: "_models.PeeringSku",
        kind: Union[str, "_models.Kind"],
        location: str,
        tags: Optional[Dict[str, str]] = None,
        direct: Optional["_models.PeeringPropertiesDirect"] = None,
        exchange: Optional["_models.PeeringPropertiesExchange"] = None,
        peering_location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword sku: The SKU that defines the tier and kind of the peering. Required.
        :paramtype sku: ~azure.mgmt.peering.models.PeeringSku
        :keyword kind: The kind of the peering. Required. Known values are: "Direct" and "Exchange".
        :paramtype kind: str or ~azure.mgmt.peering.models.Kind
        :keyword location: The location of the resource. Required.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword direct: The properties that define a direct peering.
        :paramtype direct: ~azure.mgmt.peering.models.PeeringPropertiesDirect
        :keyword exchange: The properties that define an exchange peering.
        :paramtype exchange: ~azure.mgmt.peering.models.PeeringPropertiesExchange
        :keyword peering_location: The location of the peering.
        :paramtype peering_location: str
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.kind = kind
        self.location = location
        self.tags = tags
        self.direct = direct
        self.exchange = exchange
        self.peering_location = peering_location
        self.provisioning_state = None


class PeeringBandwidthOffer(_serialization.Model):
    """The properties that define a peering bandwidth offer.

    :ivar offer_name: The name of the bandwidth offer.
    :vartype offer_name: str
    :ivar value_in_mbps: The value of the bandwidth offer in Mbps.
    :vartype value_in_mbps: int
    """

    _attribute_map = {
        "offer_name": {"key": "offerName", "type": "str"},
        "value_in_mbps": {"key": "valueInMbps", "type": "int"},
    }

    def __init__(self, *, offer_name: Optional[str] = None, value_in_mbps: Optional[int] = None, **kwargs):
        """
        :keyword offer_name: The name of the bandwidth offer.
        :paramtype offer_name: str
        :keyword value_in_mbps: The value of the bandwidth offer in Mbps.
        :paramtype value_in_mbps: int
        """
        super().__init__(**kwargs)
        self.offer_name = offer_name
        self.value_in_mbps = value_in_mbps


class PeeringListResult(_serialization.Model):
    """The paginated list of peerings.

    :ivar value: The list of peerings.
    :vartype value: list[~azure.mgmt.peering.models.Peering]
    :ivar next_link: The link to fetch the next page of peerings.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Peering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Peering"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of peerings.
        :paramtype value: list[~azure.mgmt.peering.models.Peering]
        :keyword next_link: The link to fetch the next page of peerings.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringLocation(Resource):
    """Peering location is where connectivity could be established to the Microsoft Cloud Edge.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar kind: The kind of peering that the peering location supports. Known values are: "Direct"
     and "Exchange".
    :vartype kind: str or ~azure.mgmt.peering.models.Kind
    :ivar direct: The properties that define a direct peering location.
    :vartype direct: ~azure.mgmt.peering.models.PeeringLocationPropertiesDirect
    :ivar exchange: The properties that define an exchange peering location.
    :vartype exchange: ~azure.mgmt.peering.models.PeeringLocationPropertiesExchange
    :ivar peering_location: The name of the peering location.
    :vartype peering_location: str
    :ivar country: The country in which the peering location exists.
    :vartype country: str
    :ivar azure_region: The Azure region associated with the peering location.
    :vartype azure_region: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "direct": {"key": "properties.direct", "type": "PeeringLocationPropertiesDirect"},
        "exchange": {"key": "properties.exchange", "type": "PeeringLocationPropertiesExchange"},
        "peering_location": {"key": "properties.peeringLocation", "type": "str"},
        "country": {"key": "properties.country", "type": "str"},
        "azure_region": {"key": "properties.azureRegion", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        direct: Optional["_models.PeeringLocationPropertiesDirect"] = None,
        exchange: Optional["_models.PeeringLocationPropertiesExchange"] = None,
        peering_location: Optional[str] = None,
        country: Optional[str] = None,
        azure_region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: The kind of peering that the peering location supports. Known values are:
         "Direct" and "Exchange".
        :paramtype kind: str or ~azure.mgmt.peering.models.Kind
        :keyword direct: The properties that define a direct peering location.
        :paramtype direct: ~azure.mgmt.peering.models.PeeringLocationPropertiesDirect
        :keyword exchange: The properties that define an exchange peering location.
        :paramtype exchange: ~azure.mgmt.peering.models.PeeringLocationPropertiesExchange
        :keyword peering_location: The name of the peering location.
        :paramtype peering_location: str
        :keyword country: The country in which the peering location exists.
        :paramtype country: str
        :keyword azure_region: The Azure region associated with the peering location.
        :paramtype azure_region: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.direct = direct
        self.exchange = exchange
        self.peering_location = peering_location
        self.country = country
        self.azure_region = azure_region


class PeeringLocationListResult(_serialization.Model):
    """The paginated list of peering locations.

    :ivar value: The list of peering locations.
    :vartype value: list[~azure.mgmt.peering.models.PeeringLocation]
    :ivar next_link: The link to fetch the next page of peering locations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeeringLocation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PeeringLocation"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of peering locations.
        :paramtype value: list[~azure.mgmt.peering.models.PeeringLocation]
        :keyword next_link: The link to fetch the next page of peering locations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringLocationPropertiesDirect(_serialization.Model):
    """The properties that define a direct peering location.

    :ivar peering_facilities: The list of direct peering facilities at the peering location.
    :vartype peering_facilities: list[~azure.mgmt.peering.models.DirectPeeringFacility]
    :ivar bandwidth_offers: The list of bandwidth offers available at the peering location.
    :vartype bandwidth_offers: list[~azure.mgmt.peering.models.PeeringBandwidthOffer]
    """

    _attribute_map = {
        "peering_facilities": {"key": "peeringFacilities", "type": "[DirectPeeringFacility]"},
        "bandwidth_offers": {"key": "bandwidthOffers", "type": "[PeeringBandwidthOffer]"},
    }

    def __init__(
        self,
        *,
        peering_facilities: Optional[List["_models.DirectPeeringFacility"]] = None,
        bandwidth_offers: Optional[List["_models.PeeringBandwidthOffer"]] = None,
        **kwargs
    ):
        """
        :keyword peering_facilities: The list of direct peering facilities at the peering location.
        :paramtype peering_facilities: list[~azure.mgmt.peering.models.DirectPeeringFacility]
        :keyword bandwidth_offers: The list of bandwidth offers available at the peering location.
        :paramtype bandwidth_offers: list[~azure.mgmt.peering.models.PeeringBandwidthOffer]
        """
        super().__init__(**kwargs)
        self.peering_facilities = peering_facilities
        self.bandwidth_offers = bandwidth_offers


class PeeringLocationPropertiesExchange(_serialization.Model):
    """The properties that define an exchange peering location.

    :ivar peering_facilities: The list of exchange peering facilities at the peering location.
    :vartype peering_facilities: list[~azure.mgmt.peering.models.ExchangePeeringFacility]
    """

    _attribute_map = {
        "peering_facilities": {"key": "peeringFacilities", "type": "[ExchangePeeringFacility]"},
    }

    def __init__(self, *, peering_facilities: Optional[List["_models.ExchangePeeringFacility"]] = None, **kwargs):
        """
        :keyword peering_facilities: The list of exchange peering facilities at the peering location.
        :paramtype peering_facilities: list[~azure.mgmt.peering.models.ExchangePeeringFacility]
        """
        super().__init__(**kwargs)
        self.peering_facilities = peering_facilities


class PeeringPropertiesDirect(_serialization.Model):
    """The properties that define a direct peering.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar connections: The set of connections that constitute a direct peering.
    :vartype connections: list[~azure.mgmt.peering.models.DirectConnection]
    :ivar use_for_peering_service: The flag that indicates whether or not the peering is used for
     peering service.
    :vartype use_for_peering_service: bool
    :ivar peer_asn: The reference of the peer ASN.
    :vartype peer_asn: ~azure.mgmt.peering.models.SubResource
    :ivar direct_peering_type: The type of direct peering. Known values are: "Edge", "Transit",
     "Cdn", "Internal", "Ix", "IxRs", "Voice", and "EdgeZoneForOperators".
    :vartype direct_peering_type: str or ~azure.mgmt.peering.models.DirectPeeringType
    """

    _validation = {
        "use_for_peering_service": {"readonly": True},
    }

    _attribute_map = {
        "connections": {"key": "connections", "type": "[DirectConnection]"},
        "use_for_peering_service": {"key": "useForPeeringService", "type": "bool"},
        "peer_asn": {"key": "peerAsn", "type": "SubResource"},
        "direct_peering_type": {"key": "directPeeringType", "type": "str"},
    }

    def __init__(
        self,
        *,
        connections: Optional[List["_models.DirectConnection"]] = None,
        peer_asn: Optional["_models.SubResource"] = None,
        direct_peering_type: Optional[Union[str, "_models.DirectPeeringType"]] = None,
        **kwargs
    ):
        """
        :keyword connections: The set of connections that constitute a direct peering.
        :paramtype connections: list[~azure.mgmt.peering.models.DirectConnection]
        :keyword peer_asn: The reference of the peer ASN.
        :paramtype peer_asn: ~azure.mgmt.peering.models.SubResource
        :keyword direct_peering_type: The type of direct peering. Known values are: "Edge", "Transit",
         "Cdn", "Internal", "Ix", "IxRs", "Voice", and "EdgeZoneForOperators".
        :paramtype direct_peering_type: str or ~azure.mgmt.peering.models.DirectPeeringType
        """
        super().__init__(**kwargs)
        self.connections = connections
        self.use_for_peering_service = None
        self.peer_asn = peer_asn
        self.direct_peering_type = direct_peering_type


class PeeringPropertiesExchange(_serialization.Model):
    """The properties that define an exchange peering.

    :ivar connections: The set of connections that constitute an exchange peering.
    :vartype connections: list[~azure.mgmt.peering.models.ExchangeConnection]
    :ivar peer_asn: The reference of the peer ASN.
    :vartype peer_asn: ~azure.mgmt.peering.models.SubResource
    """

    _attribute_map = {
        "connections": {"key": "connections", "type": "[ExchangeConnection]"},
        "peer_asn": {"key": "peerAsn", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        connections: Optional[List["_models.ExchangeConnection"]] = None,
        peer_asn: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword connections: The set of connections that constitute an exchange peering.
        :paramtype connections: list[~azure.mgmt.peering.models.ExchangeConnection]
        :keyword peer_asn: The reference of the peer ASN.
        :paramtype peer_asn: ~azure.mgmt.peering.models.SubResource
        """
        super().__init__(**kwargs)
        self.connections = connections
        self.peer_asn = peer_asn


class PeeringReceivedRoute(_serialization.Model):
    """The properties that define a received route.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar prefix: The prefix.
    :vartype prefix: str
    :ivar next_hop: The next hop for the prefix.
    :vartype next_hop: str
    :ivar as_path: The AS path for the prefix.
    :vartype as_path: str
    :ivar origin_as_validation_state: The origin AS change information for the prefix.
    :vartype origin_as_validation_state: str
    :ivar rpki_validation_state: The RPKI validation state for the prefix and origin AS that's
     listed in the AS path.
    :vartype rpki_validation_state: str
    :ivar trust_anchor: The authority which holds the Route Origin Authorization record for the
     prefix, if any.
    :vartype trust_anchor: str
    :ivar received_timestamp: The received timestamp associated with the prefix.
    :vartype received_timestamp: str
    """

    _validation = {
        "prefix": {"readonly": True},
        "next_hop": {"readonly": True},
        "as_path": {"readonly": True},
        "origin_as_validation_state": {"readonly": True},
        "rpki_validation_state": {"readonly": True},
        "trust_anchor": {"readonly": True},
        "received_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
        "as_path": {"key": "asPath", "type": "str"},
        "origin_as_validation_state": {"key": "originAsValidationState", "type": "str"},
        "rpki_validation_state": {"key": "rpkiValidationState", "type": "str"},
        "trust_anchor": {"key": "trustAnchor", "type": "str"},
        "received_timestamp": {"key": "receivedTimestamp", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.prefix = None
        self.next_hop = None
        self.as_path = None
        self.origin_as_validation_state = None
        self.rpki_validation_state = None
        self.trust_anchor = None
        self.received_timestamp = None


class PeeringReceivedRouteListResult(_serialization.Model):
    """The paginated list of received routes for the peering.

    :ivar value: The list of received routes for the peering.
    :vartype value: list[~azure.mgmt.peering.models.PeeringReceivedRoute]
    :ivar next_link: The link to fetch the next page of received routes for the peering.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeeringReceivedRoute]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PeeringReceivedRoute"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of received routes for the peering.
        :paramtype value: list[~azure.mgmt.peering.models.PeeringReceivedRoute]
        :keyword next_link: The link to fetch the next page of received routes for the peering.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringRegisteredAsn(Resource):
    """The customer's ASN that is registered by the peering service provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar asn: The customer's ASN from which traffic originates.
    :vartype asn: int
    :ivar peering_service_prefix_key: The peering service prefix key that is to be shared with the
     customer.
    :vartype peering_service_prefix_key: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "peering_service_prefix_key": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "asn": {"key": "properties.asn", "type": "int"},
        "peering_service_prefix_key": {"key": "properties.peeringServicePrefixKey", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, asn: Optional[int] = None, **kwargs):
        """
        :keyword asn: The customer's ASN from which traffic originates.
        :paramtype asn: int
        """
        super().__init__(**kwargs)
        self.asn = asn
        self.peering_service_prefix_key = None
        self.provisioning_state = None


class PeeringRegisteredAsnListResult(_serialization.Model):
    """The paginated list of peering registered ASNs.

    :ivar value: The list of peering registered ASNs.
    :vartype value: list[~azure.mgmt.peering.models.PeeringRegisteredAsn]
    :ivar next_link: The link to fetch the next page of peering registered ASNs.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeeringRegisteredAsn]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PeeringRegisteredAsn"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of peering registered ASNs.
        :paramtype value: list[~azure.mgmt.peering.models.PeeringRegisteredAsn]
        :keyword next_link: The link to fetch the next page of peering registered ASNs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringRegisteredPrefix(Resource):
    """The customer's prefix that is registered by the peering service provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar prefix: The customer's prefix from which traffic originates.
    :vartype prefix: str
    :ivar prefix_validation_state: The prefix validation state. Known values are: "None",
     "Invalid", "Verified", "Failed", "Pending", "Warning", and "Unknown".
    :vartype prefix_validation_state: str or ~azure.mgmt.peering.models.PrefixValidationState
    :ivar peering_service_prefix_key: The peering service prefix key that is to be shared with the
     customer.
    :vartype peering_service_prefix_key: str
    :ivar error_message: The error message associated with the validation state, if any.
    :vartype error_message: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "prefix_validation_state": {"readonly": True},
        "peering_service_prefix_key": {"readonly": True},
        "error_message": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "prefix": {"key": "properties.prefix", "type": "str"},
        "prefix_validation_state": {"key": "properties.prefixValidationState", "type": "str"},
        "peering_service_prefix_key": {"key": "properties.peeringServicePrefixKey", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, prefix: Optional[str] = None, **kwargs):
        """
        :keyword prefix: The customer's prefix from which traffic originates.
        :paramtype prefix: str
        """
        super().__init__(**kwargs)
        self.prefix = prefix
        self.prefix_validation_state = None
        self.peering_service_prefix_key = None
        self.error_message = None
        self.provisioning_state = None


class PeeringRegisteredPrefixListResult(_serialization.Model):
    """The paginated list of peering registered prefixes.

    :ivar value: The list of peering registered prefixes.
    :vartype value: list[~azure.mgmt.peering.models.PeeringRegisteredPrefix]
    :ivar next_link: The link to fetch the next page of peering registered prefixes.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeeringRegisteredPrefix]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PeeringRegisteredPrefix"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of peering registered prefixes.
        :paramtype value: list[~azure.mgmt.peering.models.PeeringRegisteredPrefix]
        :keyword next_link: The link to fetch the next page of peering registered prefixes.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringService(Resource):  # pylint: disable=too-many-instance-attributes
    """Peering Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar sku: The SKU that defines the type of the peering service.
    :vartype sku: ~azure.mgmt.peering.models.PeeringServiceSku
    :ivar location: The location of the resource. Required.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar peering_service_location: The location (state/province) of the customer.
    :vartype peering_service_location: str
    :ivar peering_service_provider: The name of the service provider.
    :vartype peering_service_provider: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    :ivar provider_primary_peering_location: The primary peering (Microsoft/service provider)
     location to be used for customer traffic.
    :vartype provider_primary_peering_location: str
    :ivar provider_backup_peering_location: The backup peering (Microsoft/service provider)
     location to be used for customer traffic.
    :vartype provider_backup_peering_location: str
    :ivar log_analytics_workspace_properties: The Log Analytics Workspace Properties.
    :vartype log_analytics_workspace_properties:
     ~azure.mgmt.peering.models.LogAnalyticsWorkspaceProperties
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "PeeringServiceSku"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "peering_service_location": {"key": "properties.peeringServiceLocation", "type": "str"},
        "peering_service_provider": {"key": "properties.peeringServiceProvider", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "provider_primary_peering_location": {"key": "properties.providerPrimaryPeeringLocation", "type": "str"},
        "provider_backup_peering_location": {"key": "properties.providerBackupPeeringLocation", "type": "str"},
        "log_analytics_workspace_properties": {
            "key": "properties.logAnalyticsWorkspaceProperties",
            "type": "LogAnalyticsWorkspaceProperties",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        sku: Optional["_models.PeeringServiceSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        peering_service_location: Optional[str] = None,
        peering_service_provider: Optional[str] = None,
        provider_primary_peering_location: Optional[str] = None,
        provider_backup_peering_location: Optional[str] = None,
        log_analytics_workspace_properties: Optional["_models.LogAnalyticsWorkspaceProperties"] = None,
        **kwargs
    ):
        """
        :keyword sku: The SKU that defines the type of the peering service.
        :paramtype sku: ~azure.mgmt.peering.models.PeeringServiceSku
        :keyword location: The location of the resource. Required.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword peering_service_location: The location (state/province) of the customer.
        :paramtype peering_service_location: str
        :keyword peering_service_provider: The name of the service provider.
        :paramtype peering_service_provider: str
        :keyword provider_primary_peering_location: The primary peering (Microsoft/service provider)
         location to be used for customer traffic.
        :paramtype provider_primary_peering_location: str
        :keyword provider_backup_peering_location: The backup peering (Microsoft/service provider)
         location to be used for customer traffic.
        :paramtype provider_backup_peering_location: str
        :keyword log_analytics_workspace_properties: The Log Analytics Workspace Properties.
        :paramtype log_analytics_workspace_properties:
         ~azure.mgmt.peering.models.LogAnalyticsWorkspaceProperties
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.location = location
        self.tags = tags
        self.peering_service_location = peering_service_location
        self.peering_service_provider = peering_service_provider
        self.provisioning_state = None
        self.provider_primary_peering_location = provider_primary_peering_location
        self.provider_backup_peering_location = provider_backup_peering_location
        self.log_analytics_workspace_properties = log_analytics_workspace_properties


class PeeringServiceCountry(Resource):
    """The peering service country.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class PeeringServiceCountryListResult(_serialization.Model):
    """The paginated list of peering service countries.

    :ivar value: The list of peering service countries.
    :vartype value: list[~azure.mgmt.peering.models.PeeringServiceCountry]
    :ivar next_link: The link to fetch the next page of peering service countries.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeeringServiceCountry]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PeeringServiceCountry"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of peering service countries.
        :paramtype value: list[~azure.mgmt.peering.models.PeeringServiceCountry]
        :keyword next_link: The link to fetch the next page of peering service countries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringServiceListResult(_serialization.Model):
    """The paginated list of peering services.

    :ivar value: The list of peering services.
    :vartype value: list[~azure.mgmt.peering.models.PeeringService]
    :ivar next_link: The link to fetch the next page of peering services.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeeringService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PeeringService"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of peering services.
        :paramtype value: list[~azure.mgmt.peering.models.PeeringService]
        :keyword next_link: The link to fetch the next page of peering services.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringServiceLocation(Resource):
    """The peering service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar country: Country of the customer.
    :vartype country: str
    :ivar state: State of the customer.
    :vartype state: str
    :ivar azure_region: Azure region for the location.
    :vartype azure_region: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "country": {"key": "properties.country", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "azure_region": {"key": "properties.azureRegion", "type": "str"},
    }

    def __init__(
        self,
        *,
        country: Optional[str] = None,
        state: Optional[str] = None,
        azure_region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword country: Country of the customer.
        :paramtype country: str
        :keyword state: State of the customer.
        :paramtype state: str
        :keyword azure_region: Azure region for the location.
        :paramtype azure_region: str
        """
        super().__init__(**kwargs)
        self.country = country
        self.state = state
        self.azure_region = azure_region


class PeeringServiceLocationListResult(_serialization.Model):
    """The paginated list of peering service locations.

    :ivar value: The list of peering service locations.
    :vartype value: list[~azure.mgmt.peering.models.PeeringServiceLocation]
    :ivar next_link: The link to fetch the next page of peering service locations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeeringServiceLocation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PeeringServiceLocation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of peering service locations.
        :paramtype value: list[~azure.mgmt.peering.models.PeeringServiceLocation]
        :keyword next_link: The link to fetch the next page of peering service locations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringServicePrefix(Resource):
    """The peering service prefix class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar prefix: The prefix from which your traffic originates.
    :vartype prefix: str
    :ivar prefix_validation_state: The prefix validation state. Known values are: "None",
     "Invalid", "Verified", "Failed", "Pending", "Warning", and "Unknown".
    :vartype prefix_validation_state: str or ~azure.mgmt.peering.models.PrefixValidationState
    :ivar learned_type: The prefix learned type. Known values are: "None", "ViaServiceProvider",
     and "ViaSession".
    :vartype learned_type: str or ~azure.mgmt.peering.models.LearnedType
    :ivar error_message: The error message for validation state.
    :vartype error_message: str
    :ivar events: The list of events for peering service prefix.
    :vartype events: list[~azure.mgmt.peering.models.PeeringServicePrefixEvent]
    :ivar peering_service_prefix_key: The peering service prefix key.
    :vartype peering_service_prefix_key: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "prefix_validation_state": {"readonly": True},
        "learned_type": {"readonly": True},
        "error_message": {"readonly": True},
        "events": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "prefix": {"key": "properties.prefix", "type": "str"},
        "prefix_validation_state": {"key": "properties.prefixValidationState", "type": "str"},
        "learned_type": {"key": "properties.learnedType", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
        "events": {"key": "properties.events", "type": "[PeeringServicePrefixEvent]"},
        "peering_service_prefix_key": {"key": "properties.peeringServicePrefixKey", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, prefix: Optional[str] = None, peering_service_prefix_key: Optional[str] = None, **kwargs):
        """
        :keyword prefix: The prefix from which your traffic originates.
        :paramtype prefix: str
        :keyword peering_service_prefix_key: The peering service prefix key.
        :paramtype peering_service_prefix_key: str
        """
        super().__init__(**kwargs)
        self.prefix = prefix
        self.prefix_validation_state = None
        self.learned_type = None
        self.error_message = None
        self.events = None
        self.peering_service_prefix_key = peering_service_prefix_key
        self.provisioning_state = None


class PeeringServicePrefixEvent(_serialization.Model):
    """The details of the event associated with a prefix.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar event_timestamp: The timestamp of the event associated with a prefix.
    :vartype event_timestamp: ~datetime.datetime
    :ivar event_type: The type of the event associated with a prefix.
    :vartype event_type: str
    :ivar event_summary: The summary of the event associated with a prefix.
    :vartype event_summary: str
    :ivar event_level: The level of the event associated with a prefix.
    :vartype event_level: str
    :ivar event_description: The description of the event associated with a prefix.
    :vartype event_description: str
    """

    _validation = {
        "event_timestamp": {"readonly": True},
        "event_type": {"readonly": True},
        "event_summary": {"readonly": True},
        "event_level": {"readonly": True},
        "event_description": {"readonly": True},
    }

    _attribute_map = {
        "event_timestamp": {"key": "eventTimestamp", "type": "iso-8601"},
        "event_type": {"key": "eventType", "type": "str"},
        "event_summary": {"key": "eventSummary", "type": "str"},
        "event_level": {"key": "eventLevel", "type": "str"},
        "event_description": {"key": "eventDescription", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.event_timestamp = None
        self.event_type = None
        self.event_summary = None
        self.event_level = None
        self.event_description = None


class PeeringServicePrefixListResult(_serialization.Model):
    """The paginated list of peering service prefixes.

    :ivar value: The list of peering service prefixes.
    :vartype value: list[~azure.mgmt.peering.models.PeeringServicePrefix]
    :ivar next_link: The link to fetch the next page of peering service prefixes.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeeringServicePrefix]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PeeringServicePrefix"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of peering service prefixes.
        :paramtype value: list[~azure.mgmt.peering.models.PeeringServicePrefix]
        :keyword next_link: The link to fetch the next page of peering service prefixes.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringServiceProvider(Resource):
    """PeeringService provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar service_provider_name: The name of the service provider.
    :vartype service_provider_name: str
    :ivar peering_locations: The list of locations at which the service provider peers with
     Microsoft.
    :vartype peering_locations: list[str]
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_provider_name": {"key": "properties.serviceProviderName", "type": "str"},
        "peering_locations": {"key": "properties.peeringLocations", "type": "[str]"},
    }

    def __init__(
        self, *, service_provider_name: Optional[str] = None, peering_locations: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword service_provider_name: The name of the service provider.
        :paramtype service_provider_name: str
        :keyword peering_locations: The list of locations at which the service provider peers with
         Microsoft.
        :paramtype peering_locations: list[str]
        """
        super().__init__(**kwargs)
        self.service_provider_name = service_provider_name
        self.peering_locations = peering_locations


class PeeringServiceProviderListResult(_serialization.Model):
    """The paginated list of peering service providers.

    :ivar value: The list of peering service providers.
    :vartype value: list[~azure.mgmt.peering.models.PeeringServiceProvider]
    :ivar next_link: The link to fetch the next page of peering service providers.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeeringServiceProvider]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PeeringServiceProvider"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of peering service providers.
        :paramtype value: list[~azure.mgmt.peering.models.PeeringServiceProvider]
        :keyword next_link: The link to fetch the next page of peering service providers.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PeeringServiceSku(_serialization.Model):
    """The SKU that defines the type of the peering service.

    :ivar name: The name of the peering service SKU.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs):
        """
        :keyword name: The name of the peering service SKU.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class PeeringSku(_serialization.Model):
    """The SKU that defines the tier and kind of the peering.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the peering SKU.
    :vartype name: str
    :ivar tier: The tier of the peering SKU. Known values are: "Basic" and "Premium".
    :vartype tier: str or ~azure.mgmt.peering.models.Tier
    :ivar family: The family of the peering SKU. Known values are: "Direct" and "Exchange".
    :vartype family: str or ~azure.mgmt.peering.models.Family
    :ivar size: The size of the peering SKU. Known values are: "Free", "Metered", and "Unlimited".
    :vartype size: str or ~azure.mgmt.peering.models.Size
    """

    _validation = {
        "tier": {"readonly": True},
        "family": {"readonly": True},
        "size": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "size": {"key": "size", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs):
        """
        :keyword name: The name of the peering SKU.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = None
        self.family = None
        self.size = None


class ResourceTags(_serialization.Model):
    """The resource tags.

    :ivar tags: Gets or sets the tags, a dictionary of descriptors arm object.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Gets or sets the tags, a dictionary of descriptors arm object.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class RpUnbilledPrefix(_serialization.Model):
    """The Routing Preference unbilled prefix.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar prefix: The prefix.
    :vartype prefix: str
    :ivar azure_region: The Azure region.
    :vartype azure_region: str
    :ivar peer_asn: The peer ASN.
    :vartype peer_asn: int
    """

    _validation = {
        "prefix": {"readonly": True},
        "azure_region": {"readonly": True},
        "peer_asn": {"readonly": True},
    }

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
        "azure_region": {"key": "azureRegion", "type": "str"},
        "peer_asn": {"key": "peerAsn", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.prefix = None
        self.azure_region = None
        self.peer_asn = None


class RpUnbilledPrefixListResult(_serialization.Model):
    """The paginated list of RP unbilled prefixes.

    :ivar value: The list of RP unbilled prefixes.
    :vartype value: list[~azure.mgmt.peering.models.RpUnbilledPrefix]
    :ivar next_link: The link to fetch the next page of RP unbilled prefixes.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RpUnbilledPrefix]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RpUnbilledPrefix"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of RP unbilled prefixes.
        :paramtype value: list[~azure.mgmt.peering.models.RpUnbilledPrefix]
        :keyword next_link: The link to fetch the next page of RP unbilled prefixes.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceSpecification(_serialization.Model):
    """Service specification payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metric_specifications: Specifications of the Metrics for Azure Monitoring.
    :vartype metric_specifications: list[~azure.mgmt.peering.models.MetricSpecification]
    """

    _validation = {
        "metric_specifications": {"readonly": True},
    }

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.metric_specifications = None


class SubResource(_serialization.Model):
    """The sub resource.

    :ivar id: The identifier of the referenced resource.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The identifier of the referenced resource.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
