# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIConnectedEnvironmentsStoragesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_storages_list(self, resource_group):
        response = self.client.connected_environments_storages.list(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_storages_get(self, resource_group):
        response = self.client.connected_environments_storages.get(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            storage_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_storages_begin_create_or_update(self, resource_group):
        response = self.client.connected_environments_storages.begin_create_or_update(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            storage_name="str",
            storage_envelope={
                "id": "str",
                "name": "str",
                "properties": {
                    "azureFile": {
                        "accessMode": "str",
                        "accountKey": "str",
                        "accountKeyVaultProperties": {"identity": "str", "keyVaultUrl": "str"},
                        "accountName": "str",
                        "shareName": "str",
                    },
                    "deploymentErrors": "str",
                    "provisioningState": "str",
                    "smb": {
                        "accessMode": "str",
                        "domain": "str",
                        "host": "str",
                        "password": "str",
                        "shareName": "str",
                        "username": "str",
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-02-02-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_connected_environments_storages_begin_delete(self, resource_group):
        response = self.client.connected_environments_storages.begin_delete(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            storage_name="str",
            api_version="2025-02-02-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
