# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementVirtualMachinesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_list_by_location(self, resource_group):
        response = self.client.virtual_machines.list_by_location(
            location="str",
            api_version="2025-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_list_all(self, resource_group):
        response = self.client.virtual_machines.list_all(
            api_version="2025-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_list(self, resource_group):
        response = self.client.virtual_machines.list(
            resource_group_name=resource_group.name,
            api_version="2025-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_get(self, resource_group):
        response = await self.client.virtual_machines.get(
            resource_group_name=resource_group.name,
            vm_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_create_or_update(
                resource_group_name=resource_group.name,
                vm_name="str",
                parameters={
                    "location": "str",
                    "additionalCapabilities": {"hibernationEnabled": bool, "ultraSSDEnabled": bool},
                    "applicationProfile": {
                        "galleryApplications": [
                            {
                                "packageReferenceId": "str",
                                "configurationReference": "str",
                                "enableAutomaticUpgrade": bool,
                                "order": 0,
                                "tags": "str",
                                "treatFailureAsDeploymentFailure": bool,
                            }
                        ]
                    },
                    "availabilitySet": {"id": "str"},
                    "billingProfile": {"maxPrice": 0.0},
                    "capacityReservation": {"capacityReservationGroup": {"id": "str"}},
                    "diagnosticsProfile": {"bootDiagnostics": {"enabled": bool, "storageUri": "str"}},
                    "etag": "str",
                    "evictionPolicy": "str",
                    "extendedLocation": {"name": "str", "type": "str"},
                    "extensionsTimeBudget": "str",
                    "hardwareProfile": {"vmSize": "str", "vmSizeProperties": {"vCPUsAvailable": 0, "vCPUsPerCore": 0}},
                    "host": {"id": "str"},
                    "hostGroup": {"id": "str"},
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "instanceView": {
                        "assignedHost": "str",
                        "bootDiagnostics": {
                            "consoleScreenshotBlobUri": "str",
                            "serialConsoleLogBlobUri": "str",
                            "status": {
                                "code": "str",
                                "displayStatus": "str",
                                "level": "str",
                                "message": "str",
                                "time": "2020-02-20 00:00:00",
                            },
                        },
                        "computerName": "str",
                        "disks": [
                            {
                                "encryptionSettings": [
                                    {
                                        "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                                        "enabled": bool,
                                        "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                                    }
                                ],
                                "name": "str",
                                "statuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                            }
                        ],
                        "extensions": [
                            {
                                "name": "str",
                                "statuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "substatuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "type": "str",
                                "typeHandlerVersion": "str",
                            }
                        ],
                        "hyperVGeneration": "str",
                        "isVMInStandbyPool": bool,
                        "maintenanceRedeployStatus": {
                            "isCustomerInitiatedMaintenanceAllowed": bool,
                            "lastOperationMessage": "str",
                            "lastOperationResultCode": "str",
                            "maintenanceWindowEndTime": "2020-02-20 00:00:00",
                            "maintenanceWindowStartTime": "2020-02-20 00:00:00",
                            "preMaintenanceWindowEndTime": "2020-02-20 00:00:00",
                            "preMaintenanceWindowStartTime": "2020-02-20 00:00:00",
                        },
                        "osName": "str",
                        "osVersion": "str",
                        "patchStatus": {
                            "availablePatchSummary": {
                                "assessmentActivityId": "str",
                                "criticalAndSecurityPatchCount": 0,
                                "error": {
                                    "code": "str",
                                    "details": [{"code": "str", "message": "str", "target": "str"}],
                                    "innererror": {"errordetail": "str", "exceptiontype": "str"},
                                    "message": "str",
                                    "target": "str",
                                },
                                "lastModifiedTime": "2020-02-20 00:00:00",
                                "otherPatchCount": 0,
                                "rebootPending": bool,
                                "startTime": "2020-02-20 00:00:00",
                                "status": "str",
                            },
                            "configurationStatuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                            "lastPatchInstallationSummary": {
                                "error": {
                                    "code": "str",
                                    "details": [{"code": "str", "message": "str", "target": "str"}],
                                    "innererror": {"errordetail": "str", "exceptiontype": "str"},
                                    "message": "str",
                                    "target": "str",
                                },
                                "excludedPatchCount": 0,
                                "failedPatchCount": 0,
                                "installationActivityId": "str",
                                "installedPatchCount": 0,
                                "lastModifiedTime": "2020-02-20 00:00:00",
                                "maintenanceWindowExceeded": bool,
                                "notSelectedPatchCount": 0,
                                "pendingPatchCount": 0,
                                "startTime": "2020-02-20 00:00:00",
                                "status": "str",
                            },
                        },
                        "platformFaultDomain": 0,
                        "platformUpdateDomain": 0,
                        "rdpThumbPrint": "str",
                        "statuses": [
                            {
                                "code": "str",
                                "displayStatus": "str",
                                "level": "str",
                                "message": "str",
                                "time": "2020-02-20 00:00:00",
                            }
                        ],
                        "vmAgent": {
                            "extensionHandlers": [
                                {
                                    "status": {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    },
                                    "type": "str",
                                    "typeHandlerVersion": "str",
                                }
                            ],
                            "statuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                            "vmAgentVersion": "str",
                        },
                        "vmHealth": {
                            "status": {
                                "code": "str",
                                "displayStatus": "str",
                                "level": "str",
                                "message": "str",
                                "time": "2020-02-20 00:00:00",
                            }
                        },
                    },
                    "licenseType": "str",
                    "managedBy": "str",
                    "name": "str",
                    "networkProfile": {
                        "networkApiVersion": "str",
                        "networkInterfaceConfigurations": [
                            {
                                "name": "str",
                                "auxiliaryMode": "str",
                                "auxiliarySku": "str",
                                "deleteOption": "str",
                                "disableTcpStateTracking": bool,
                                "dnsSettings": {"dnsServers": ["str"]},
                                "dscpConfiguration": {"id": "str"},
                                "enableAcceleratedNetworking": bool,
                                "enableFpga": bool,
                                "enableIPForwarding": bool,
                                "ipConfigurations": [
                                    {
                                        "name": "str",
                                        "applicationGatewayBackendAddressPools": [{"id": "str"}],
                                        "applicationSecurityGroups": [{"id": "str"}],
                                        "loadBalancerBackendAddressPools": [{"id": "str"}],
                                        "primary": bool,
                                        "privateIPAddressVersion": "str",
                                        "publicIPAddressConfiguration": {
                                            "name": "str",
                                            "deleteOption": "str",
                                            "dnsSettings": {"domainNameLabel": "str", "domainNameLabelScope": "str"},
                                            "idleTimeoutInMinutes": 0,
                                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                            "publicIPAddressVersion": "str",
                                            "publicIPAllocationMethod": "str",
                                            "publicIPPrefix": {"id": "str"},
                                            "sku": {"name": "str", "tier": "str"},
                                            "tags": {"str": "str"},
                                        },
                                        "subnet": {"id": "str"},
                                    }
                                ],
                                "networkSecurityGroup": {"id": "str"},
                                "primary": bool,
                                "tags": {"str": "str"},
                            }
                        ],
                        "networkInterfaces": [{"deleteOption": "str", "id": "str", "primary": bool}],
                    },
                    "osProfile": {
                        "adminPassword": "str",
                        "adminUsername": "str",
                        "allowExtensionOperations": bool,
                        "computerName": "str",
                        "customData": "str",
                        "linuxConfiguration": {
                            "disablePasswordAuthentication": bool,
                            "enableVMAgentPlatformUpdates": bool,
                            "patchSettings": {
                                "assessmentMode": "str",
                                "automaticByPlatformSettings": {
                                    "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                    "rebootSetting": "str",
                                },
                                "patchMode": "str",
                            },
                            "provisionVMAgent": bool,
                            "ssh": {"publicKeys": [{"keyData": "str", "path": "str"}]},
                        },
                        "requireGuestProvisionSignal": bool,
                        "secrets": [
                            {
                                "sourceVault": {"id": "str"},
                                "vaultCertificates": [{"certificateStore": "str", "certificateUrl": "str"}],
                            }
                        ],
                        "windowsConfiguration": {
                            "additionalUnattendContent": [
                                {
                                    "componentName": "Microsoft-Windows-Shell-Setup",
                                    "content": "str",
                                    "passName": "OobeSystem",
                                    "settingName": "str",
                                }
                            ],
                            "enableAutomaticUpdates": bool,
                            "enableVMAgentPlatformUpdates": bool,
                            "patchSettings": {
                                "assessmentMode": "str",
                                "automaticByPlatformSettings": {
                                    "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                    "rebootSetting": "str",
                                },
                                "enableHotpatching": bool,
                                "patchMode": "str",
                            },
                            "provisionVMAgent": bool,
                            "timeZone": "str",
                            "winRM": {"listeners": [{"certificateUrl": "str", "protocol": "str"}]},
                        },
                    },
                    "placement": {"excludeZones": ["str"], "includeZones": ["str"], "zonePlacementPolicy": "str"},
                    "plan": {"name": "str", "product": "str", "promotionCode": "str", "publisher": "str"},
                    "platformFaultDomain": 0,
                    "priority": "str",
                    "provisioningState": "str",
                    "proximityPlacementGroup": {"id": "str"},
                    "resources": [
                        {
                            "location": "str",
                            "autoUpgradeMinorVersion": bool,
                            "enableAutomaticUpgrade": bool,
                            "forceUpdateTag": "str",
                            "id": "str",
                            "instanceView": {
                                "name": "str",
                                "statuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "substatuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "type": "str",
                                "typeHandlerVersion": "str",
                            },
                            "name": "str",
                            "protectedSettings": {},
                            "protectedSettingsFromKeyVault": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                            "provisionAfterExtensions": ["str"],
                            "provisioningState": "str",
                            "publisher": "str",
                            "settings": {},
                            "suppressFailures": bool,
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "tags": {"str": "str"},
                            "type": "str",
                            "typeHandlerVersion": "str",
                        }
                    ],
                    "scheduledEventsPolicy": {
                        "allInstancesDown": {"automaticallyApprove": bool},
                        "scheduledEventsAdditionalPublishingTargets": {
                            "eventGridAndResourceGraph": {"enable": bool, "scheduledEventsApiVersion": "str"}
                        },
                        "userInitiatedReboot": {"automaticallyApprove": bool},
                        "userInitiatedRedeploy": {"automaticallyApprove": bool},
                    },
                    "scheduledEventsProfile": {
                        "osImageNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                        "terminateNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                    },
                    "securityProfile": {
                        "encryptionAtHost": bool,
                        "encryptionIdentity": {"userAssignedIdentityResourceId": "str"},
                        "proxyAgentSettings": {
                            "addProxyAgentExtension": bool,
                            "enabled": bool,
                            "imds": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                            "keyIncarnationId": 0,
                            "mode": "str",
                            "wireServer": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                        },
                        "securityType": "str",
                        "uefiSettings": {"secureBootEnabled": bool, "vTpmEnabled": bool},
                    },
                    "storageProfile": {
                        "alignRegionalDisksToVMZone": bool,
                        "dataDisks": [
                            {
                                "createOption": "str",
                                "lun": 0,
                                "caching": "str",
                                "deleteOption": "str",
                                "detachOption": "str",
                                "diskIOPSReadWrite": 0,
                                "diskMBpsReadWrite": 0,
                                "diskSizeGB": 0,
                                "image": {"uri": "str"},
                                "managedDisk": {
                                    "diskEncryptionSet": {"id": "str"},
                                    "id": "str",
                                    "securityProfile": {
                                        "diskEncryptionSet": {"id": "str"},
                                        "securityEncryptionType": "str",
                                    },
                                    "storageAccountType": "str",
                                },
                                "name": "str",
                                "sourceResource": {"id": "str"},
                                "toBeDetached": bool,
                                "vhd": {"uri": "str"},
                                "writeAcceleratorEnabled": bool,
                            }
                        ],
                        "diskControllerType": "str",
                        "imageReference": {
                            "communityGalleryImageId": "str",
                            "exactVersion": "str",
                            "id": "str",
                            "offer": "str",
                            "publisher": "str",
                            "sharedGalleryImageId": "str",
                            "sku": "str",
                            "version": "str",
                        },
                        "osDisk": {
                            "createOption": "str",
                            "caching": "str",
                            "deleteOption": "str",
                            "diffDiskSettings": {"option": "str", "placement": "str"},
                            "diskSizeGB": 0,
                            "encryptionSettings": {
                                "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                                "enabled": bool,
                                "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                            },
                            "image": {"uri": "str"},
                            "managedDisk": {
                                "diskEncryptionSet": {"id": "str"},
                                "id": "str",
                                "securityProfile": {
                                    "diskEncryptionSet": {"id": "str"},
                                    "securityEncryptionType": "str",
                                },
                                "storageAccountType": "str",
                            },
                            "name": "str",
                            "osType": "str",
                            "vhd": {"uri": "str"},
                            "writeAcceleratorEnabled": bool,
                        },
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "timeCreated": "2020-02-20 00:00:00",
                    "type": "str",
                    "userData": "str",
                    "virtualMachineScaleSet": {"id": "str"},
                    "vmId": "str",
                    "zones": ["str"],
                },
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_update(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_update(
                resource_group_name=resource_group.name,
                vm_name="str",
                parameters={
                    "additionalCapabilities": {"hibernationEnabled": bool, "ultraSSDEnabled": bool},
                    "applicationProfile": {
                        "galleryApplications": [
                            {
                                "packageReferenceId": "str",
                                "configurationReference": "str",
                                "enableAutomaticUpgrade": bool,
                                "order": 0,
                                "tags": "str",
                                "treatFailureAsDeploymentFailure": bool,
                            }
                        ]
                    },
                    "availabilitySet": {"id": "str"},
                    "billingProfile": {"maxPrice": 0.0},
                    "capacityReservation": {"capacityReservationGroup": {"id": "str"}},
                    "diagnosticsProfile": {"bootDiagnostics": {"enabled": bool, "storageUri": "str"}},
                    "evictionPolicy": "str",
                    "extensionsTimeBudget": "str",
                    "hardwareProfile": {"vmSize": "str", "vmSizeProperties": {"vCPUsAvailable": 0, "vCPUsPerCore": 0}},
                    "host": {"id": "str"},
                    "hostGroup": {"id": "str"},
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "instanceView": {
                        "assignedHost": "str",
                        "bootDiagnostics": {
                            "consoleScreenshotBlobUri": "str",
                            "serialConsoleLogBlobUri": "str",
                            "status": {
                                "code": "str",
                                "displayStatus": "str",
                                "level": "str",
                                "message": "str",
                                "time": "2020-02-20 00:00:00",
                            },
                        },
                        "computerName": "str",
                        "disks": [
                            {
                                "encryptionSettings": [
                                    {
                                        "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                                        "enabled": bool,
                                        "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                                    }
                                ],
                                "name": "str",
                                "statuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                            }
                        ],
                        "extensions": [
                            {
                                "name": "str",
                                "statuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "substatuses": [
                                    {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    }
                                ],
                                "type": "str",
                                "typeHandlerVersion": "str",
                            }
                        ],
                        "hyperVGeneration": "str",
                        "isVMInStandbyPool": bool,
                        "maintenanceRedeployStatus": {
                            "isCustomerInitiatedMaintenanceAllowed": bool,
                            "lastOperationMessage": "str",
                            "lastOperationResultCode": "str",
                            "maintenanceWindowEndTime": "2020-02-20 00:00:00",
                            "maintenanceWindowStartTime": "2020-02-20 00:00:00",
                            "preMaintenanceWindowEndTime": "2020-02-20 00:00:00",
                            "preMaintenanceWindowStartTime": "2020-02-20 00:00:00",
                        },
                        "osName": "str",
                        "osVersion": "str",
                        "patchStatus": {
                            "availablePatchSummary": {
                                "assessmentActivityId": "str",
                                "criticalAndSecurityPatchCount": 0,
                                "error": {
                                    "code": "str",
                                    "details": [{"code": "str", "message": "str", "target": "str"}],
                                    "innererror": {"errordetail": "str", "exceptiontype": "str"},
                                    "message": "str",
                                    "target": "str",
                                },
                                "lastModifiedTime": "2020-02-20 00:00:00",
                                "otherPatchCount": 0,
                                "rebootPending": bool,
                                "startTime": "2020-02-20 00:00:00",
                                "status": "str",
                            },
                            "configurationStatuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                            "lastPatchInstallationSummary": {
                                "error": {
                                    "code": "str",
                                    "details": [{"code": "str", "message": "str", "target": "str"}],
                                    "innererror": {"errordetail": "str", "exceptiontype": "str"},
                                    "message": "str",
                                    "target": "str",
                                },
                                "excludedPatchCount": 0,
                                "failedPatchCount": 0,
                                "installationActivityId": "str",
                                "installedPatchCount": 0,
                                "lastModifiedTime": "2020-02-20 00:00:00",
                                "maintenanceWindowExceeded": bool,
                                "notSelectedPatchCount": 0,
                                "pendingPatchCount": 0,
                                "startTime": "2020-02-20 00:00:00",
                                "status": "str",
                            },
                        },
                        "platformFaultDomain": 0,
                        "platformUpdateDomain": 0,
                        "rdpThumbPrint": "str",
                        "statuses": [
                            {
                                "code": "str",
                                "displayStatus": "str",
                                "level": "str",
                                "message": "str",
                                "time": "2020-02-20 00:00:00",
                            }
                        ],
                        "vmAgent": {
                            "extensionHandlers": [
                                {
                                    "status": {
                                        "code": "str",
                                        "displayStatus": "str",
                                        "level": "str",
                                        "message": "str",
                                        "time": "2020-02-20 00:00:00",
                                    },
                                    "type": "str",
                                    "typeHandlerVersion": "str",
                                }
                            ],
                            "statuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                            "vmAgentVersion": "str",
                        },
                        "vmHealth": {
                            "status": {
                                "code": "str",
                                "displayStatus": "str",
                                "level": "str",
                                "message": "str",
                                "time": "2020-02-20 00:00:00",
                            }
                        },
                    },
                    "licenseType": "str",
                    "networkProfile": {
                        "networkApiVersion": "str",
                        "networkInterfaceConfigurations": [
                            {
                                "name": "str",
                                "auxiliaryMode": "str",
                                "auxiliarySku": "str",
                                "deleteOption": "str",
                                "disableTcpStateTracking": bool,
                                "dnsSettings": {"dnsServers": ["str"]},
                                "dscpConfiguration": {"id": "str"},
                                "enableAcceleratedNetworking": bool,
                                "enableFpga": bool,
                                "enableIPForwarding": bool,
                                "ipConfigurations": [
                                    {
                                        "name": "str",
                                        "applicationGatewayBackendAddressPools": [{"id": "str"}],
                                        "applicationSecurityGroups": [{"id": "str"}],
                                        "loadBalancerBackendAddressPools": [{"id": "str"}],
                                        "primary": bool,
                                        "privateIPAddressVersion": "str",
                                        "publicIPAddressConfiguration": {
                                            "name": "str",
                                            "deleteOption": "str",
                                            "dnsSettings": {"domainNameLabel": "str", "domainNameLabelScope": "str"},
                                            "idleTimeoutInMinutes": 0,
                                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                            "publicIPAddressVersion": "str",
                                            "publicIPAllocationMethod": "str",
                                            "publicIPPrefix": {"id": "str"},
                                            "sku": {"name": "str", "tier": "str"},
                                            "tags": {"str": "str"},
                                        },
                                        "subnet": {"id": "str"},
                                    }
                                ],
                                "networkSecurityGroup": {"id": "str"},
                                "primary": bool,
                                "tags": {"str": "str"},
                            }
                        ],
                        "networkInterfaces": [{"deleteOption": "str", "id": "str", "primary": bool}],
                    },
                    "osProfile": {
                        "adminPassword": "str",
                        "adminUsername": "str",
                        "allowExtensionOperations": bool,
                        "computerName": "str",
                        "customData": "str",
                        "linuxConfiguration": {
                            "disablePasswordAuthentication": bool,
                            "enableVMAgentPlatformUpdates": bool,
                            "patchSettings": {
                                "assessmentMode": "str",
                                "automaticByPlatformSettings": {
                                    "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                    "rebootSetting": "str",
                                },
                                "patchMode": "str",
                            },
                            "provisionVMAgent": bool,
                            "ssh": {"publicKeys": [{"keyData": "str", "path": "str"}]},
                        },
                        "requireGuestProvisionSignal": bool,
                        "secrets": [
                            {
                                "sourceVault": {"id": "str"},
                                "vaultCertificates": [{"certificateStore": "str", "certificateUrl": "str"}],
                            }
                        ],
                        "windowsConfiguration": {
                            "additionalUnattendContent": [
                                {
                                    "componentName": "Microsoft-Windows-Shell-Setup",
                                    "content": "str",
                                    "passName": "OobeSystem",
                                    "settingName": "str",
                                }
                            ],
                            "enableAutomaticUpdates": bool,
                            "enableVMAgentPlatformUpdates": bool,
                            "patchSettings": {
                                "assessmentMode": "str",
                                "automaticByPlatformSettings": {
                                    "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                    "rebootSetting": "str",
                                },
                                "enableHotpatching": bool,
                                "patchMode": "str",
                            },
                            "provisionVMAgent": bool,
                            "timeZone": "str",
                            "winRM": {"listeners": [{"certificateUrl": "str", "protocol": "str"}]},
                        },
                    },
                    "plan": {"name": "str", "product": "str", "promotionCode": "str", "publisher": "str"},
                    "platformFaultDomain": 0,
                    "priority": "str",
                    "provisioningState": "str",
                    "proximityPlacementGroup": {"id": "str"},
                    "scheduledEventsPolicy": {
                        "allInstancesDown": {"automaticallyApprove": bool},
                        "scheduledEventsAdditionalPublishingTargets": {
                            "eventGridAndResourceGraph": {"enable": bool, "scheduledEventsApiVersion": "str"}
                        },
                        "userInitiatedReboot": {"automaticallyApprove": bool},
                        "userInitiatedRedeploy": {"automaticallyApprove": bool},
                    },
                    "scheduledEventsProfile": {
                        "osImageNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                        "terminateNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                    },
                    "securityProfile": {
                        "encryptionAtHost": bool,
                        "encryptionIdentity": {"userAssignedIdentityResourceId": "str"},
                        "proxyAgentSettings": {
                            "addProxyAgentExtension": bool,
                            "enabled": bool,
                            "imds": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                            "keyIncarnationId": 0,
                            "mode": "str",
                            "wireServer": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                        },
                        "securityType": "str",
                        "uefiSettings": {"secureBootEnabled": bool, "vTpmEnabled": bool},
                    },
                    "storageProfile": {
                        "alignRegionalDisksToVMZone": bool,
                        "dataDisks": [
                            {
                                "createOption": "str",
                                "lun": 0,
                                "caching": "str",
                                "deleteOption": "str",
                                "detachOption": "str",
                                "diskIOPSReadWrite": 0,
                                "diskMBpsReadWrite": 0,
                                "diskSizeGB": 0,
                                "image": {"uri": "str"},
                                "managedDisk": {
                                    "diskEncryptionSet": {"id": "str"},
                                    "id": "str",
                                    "securityProfile": {
                                        "diskEncryptionSet": {"id": "str"},
                                        "securityEncryptionType": "str",
                                    },
                                    "storageAccountType": "str",
                                },
                                "name": "str",
                                "sourceResource": {"id": "str"},
                                "toBeDetached": bool,
                                "vhd": {"uri": "str"},
                                "writeAcceleratorEnabled": bool,
                            }
                        ],
                        "diskControllerType": "str",
                        "imageReference": {
                            "communityGalleryImageId": "str",
                            "exactVersion": "str",
                            "id": "str",
                            "offer": "str",
                            "publisher": "str",
                            "sharedGalleryImageId": "str",
                            "sku": "str",
                            "version": "str",
                        },
                        "osDisk": {
                            "createOption": "str",
                            "caching": "str",
                            "deleteOption": "str",
                            "diffDiskSettings": {"option": "str", "placement": "str"},
                            "diskSizeGB": 0,
                            "encryptionSettings": {
                                "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                                "enabled": bool,
                                "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                            },
                            "image": {"uri": "str"},
                            "managedDisk": {
                                "diskEncryptionSet": {"id": "str"},
                                "id": "str",
                                "securityProfile": {
                                    "diskEncryptionSet": {"id": "str"},
                                    "securityEncryptionType": "str",
                                },
                                "storageAccountType": "str",
                            },
                            "name": "str",
                            "osType": "str",
                            "vhd": {"uri": "str"},
                            "writeAcceleratorEnabled": bool,
                        },
                    },
                    "tags": {"str": "str"},
                    "timeCreated": "2020-02-20 00:00:00",
                    "userData": "str",
                    "virtualMachineScaleSet": {"id": "str"},
                    "vmId": "str",
                    "zones": ["str"],
                },
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_delete(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_delete(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_assess_patches(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_assess_patches(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_attach_detach_data_disks(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_attach_detach_data_disks(
                resource_group_name=resource_group.name,
                vm_name="str",
                parameters={
                    "dataDisksToAttach": [
                        {
                            "diskId": "str",
                            "caching": "str",
                            "deleteOption": "str",
                            "diskEncryptionSet": {"id": "str"},
                            "lun": 0,
                            "writeAcceleratorEnabled": bool,
                        }
                    ],
                    "dataDisksToDetach": [{"diskId": "str", "detachOption": "str"}],
                },
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_capture(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_capture(
                resource_group_name=resource_group.name,
                vm_name="str",
                parameters={"destinationContainerName": "str", "overwriteVhds": bool, "vhdPrefix": "str"},
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_convert_to_managed_disks(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_convert_to_managed_disks(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_deallocate(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_deallocate(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_generalize(self, resource_group):
        response = await self.client.virtual_machines.generalize(
            resource_group_name=resource_group.name,
            vm_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_install_patches(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_install_patches(
                resource_group_name=resource_group.name,
                vm_name="str",
                install_patches_input={
                    "rebootSetting": "str",
                    "linuxParameters": {
                        "classificationsToInclude": ["str"],
                        "maintenanceRunId": "str",
                        "packageNameMasksToExclude": ["str"],
                        "packageNameMasksToInclude": ["str"],
                    },
                    "maximumDuration": "1 day, 0:00:00",
                    "windowsParameters": {
                        "classificationsToInclude": ["str"],
                        "excludeKbsRequiringReboot": bool,
                        "kbNumbersToExclude": ["str"],
                        "kbNumbersToInclude": ["str"],
                        "maxPatchPublishDate": "2020-02-20 00:00:00",
                        "patchNameMasksToExclude": ["str"],
                        "patchNameMasksToInclude": ["str"],
                    },
                },
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_instance_view(self, resource_group):
        response = await self.client.virtual_machines.instance_view(
            resource_group_name=resource_group.name,
            vm_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_migrate_to_vm_scale_set(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_migrate_to_vm_scale_set(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_perform_maintenance(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_perform_maintenance(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_power_off(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_power_off(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_reapply(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_reapply(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_redeploy(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_redeploy(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_reimage(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_reimage(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_restart(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_restart(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_retrieve_boot_diagnostics_data(self, resource_group):
        response = await self.client.virtual_machines.retrieve_boot_diagnostics_data(
            resource_group_name=resource_group.name,
            vm_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_run_command(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_run_command(
                resource_group_name=resource_group.name,
                vm_name="str",
                parameters={"commandId": "str", "parameters": [{"name": "str", "value": "str"}], "script": ["str"]},
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_simulate_eviction(self, resource_group):
        response = await self.client.virtual_machines.simulate_eviction(
            resource_group_name=resource_group.name,
            vm_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_start(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_start(
                resource_group_name=resource_group.name,
                vm_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_list_available_sizes(self, resource_group):
        response = self.client.virtual_machines.list_available_sizes(
            resource_group_name=resource_group.name,
            vm_name="str",
            api_version="2025-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
