# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ClientIncidentDetails(_model_base.Model):
    """Client incident details ex: incidentId , incident source.

    :ivar client_incident_id: Client incident id. ex : id of the incident created to investigate
     and address the impact if any.
    :vartype client_incident_id: str
    :ivar client_incident_source: Client incident source. ex : source system name where the
     incident is created. Known values are: "AzureDevops", "ICM", "Jira", "ServiceNow", and "Other".
    :vartype client_incident_source: str or ~azure.mgmt.impactreporting.models.IncidentSource
    """

    client_incident_id: Optional[str] = rest_field(
        name="clientIncidentId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Client incident id. ex : id of the incident created to investigate and address the impact if
     any."""
    client_incident_source: Optional[Union[str, "_models.IncidentSource"]] = rest_field(
        name="clientIncidentSource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Client incident source. ex : source system name where the incident is created. Known values
     are: \"AzureDevops\", \"ICM\", \"Jira\", \"ServiceNow\", and \"Other\"."""

    @overload
    def __init__(
        self,
        *,
        client_incident_id: Optional[str] = None,
        client_incident_source: Optional[Union[str, "_models.IncidentSource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Connectivity(_model_base.Model):
    """Details about connectivity issue. Applicable when root resource causing the issue is not
    identified. For example, when a VM is impacted due to a network issue, the impacted resource
    could be VM or the network. In such cases, the connectivity field will have the details about
    both VM and network.

    :ivar protocol: Protocol used for the connection. Known values are: "TCP", "UDP", "HTTP",
     "HTTPS", "RDP", "FTP", "SSH", and "Other".
    :vartype protocol: str or ~azure.mgmt.impactreporting.models.Protocol
    :ivar port: Port number for the connection.
    :vartype port: int
    :ivar source: Source from which the connection was attempted.
    :vartype source: ~azure.mgmt.impactreporting.models.SourceOrTarget
    :ivar target: target which connection was attempted.
    :vartype target: ~azure.mgmt.impactreporting.models.SourceOrTarget
    """

    protocol: Optional[Union[str, "_models.Protocol"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Protocol used for the connection. Known values are: \"TCP\", \"UDP\", \"HTTP\", \"HTTPS\",
     \"RDP\", \"FTP\", \"SSH\", and \"Other\"."""
    port: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Port number for the connection."""
    source: Optional["_models.SourceOrTarget"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source from which the connection was attempted."""
    target: Optional["_models.SourceOrTarget"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """target which connection was attempted."""

    @overload
    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.Protocol"]] = None,
        port: Optional[int] = None,
        source: Optional["_models.SourceOrTarget"] = None,
        target: Optional["_models.SourceOrTarget"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.impactreporting.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.impactreporting.models.SystemData
    """


class Connector(ProxyResource):
    """A connector is a resource that can be used to proactively report impacts against workloads in
    Azure to Microsoft.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.impactreporting.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.impactreporting.models.ConnectorProperties
    """

    properties: Optional["_models.ConnectorProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ConnectorProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConnectorProperties(_model_base.Model):
    """Details of the Connector.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar provisioning_state: Resource provisioning state. Known values are: "Succeeded", "Failed",
     and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.impactreporting.models.ProvisioningState
    :ivar connector_id: unique id of the connector. Required.
    :vartype connector_id: str
    :ivar tenant_id: tenant id of this connector. Required.
    :vartype tenant_id: str
    :ivar connector_type: connector type. Required. "AzureMonitor"
    :vartype connector_type: str or ~azure.mgmt.impactreporting.models.Platform
    :ivar last_run_time_stamp: last run time stamp of this connector in UTC time zone. Required.
    :vartype last_run_time_stamp: ~datetime.datetime
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    connector_id: str = rest_field(name="connectorId", visibility=["read"])
    """unique id of the connector. Required."""
    tenant_id: str = rest_field(name="tenantId", visibility=["read"])
    """tenant id of this connector. Required."""
    connector_type: Union[str, "_models.Platform"] = rest_field(
        name="connectorType", visibility=["read", "create", "update", "delete", "query"]
    )
    """connector type. Required. \"AzureMonitor\""""
    last_run_time_stamp: datetime.datetime = rest_field(name="lastRunTimeStamp", visibility=["read"], format="rfc3339")
    """last run time stamp of this connector in UTC time zone. Required."""

    @overload
    def __init__(
        self,
        *,
        connector_type: Union[str, "_models.Platform"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConnectorUpdate(_model_base.Model):
    """The type used for update operations of the Connector.

    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.impactreporting.models.ConnectorUpdateProperties
    """

    properties: Optional["_models.ConnectorUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ConnectorUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConnectorUpdateProperties(_model_base.Model):
    """The updatable properties of the Connector.

    :ivar connector_type: connector type. "AzureMonitor"
    :vartype connector_type: str or ~azure.mgmt.impactreporting.models.Platform
    """

    connector_type: Optional[Union[str, "_models.Platform"]] = rest_field(
        name="connectorType", visibility=["read", "create", "update", "delete", "query"]
    )
    """connector type. \"AzureMonitor\""""

    @overload
    def __init__(
        self,
        *,
        connector_type: Optional[Union[str, "_models.Platform"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Content(_model_base.Model):
    """Article details of the insight like title, description etc.


    :ivar title: Title of the insight. Required.
    :vartype title: str
    :ivar description: Description of the insight. Required.
    :vartype description: str
    """

    title: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Title of the insight. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the insight. Required."""

    @overload
    def __init__(
        self,
        *,
        title: str,
        description: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.impactreporting.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.impactreporting.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorDetailProperties(_model_base.Model):
    """ARM error code and error message associated with the impact.

    :ivar error_code: ARM Error code associated with the impact.
    :vartype error_code: str
    :ivar error_message: ARM Error Message associated with the impact.
    :vartype error_message: str
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """ARM Error code associated with the impact."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """ARM Error Message associated with the impact."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.impactreporting.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExpectedValueRange(_model_base.Model):
    """Max and Min Threshold values for the metric.


    :ivar min: Min threshold value for the metric. Required.
    :vartype min: float
    :ivar max: Max threshold value for the metric. Required.
    :vartype max: float
    """

    min: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Min threshold value for the metric. Required."""
    max: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Max threshold value for the metric. Required."""

    @overload
    def __init__(
        self,
        *,
        min: float,  # pylint: disable=redefined-builtin
        max: float,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImpactCategory(ProxyResource):
    """ImpactCategory resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.impactreporting.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.impactreporting.models.ImpactCategoryProperties
    """

    properties: Optional["_models.ImpactCategoryProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ImpactCategoryProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImpactCategoryProperties(_model_base.Model):
    """Impact category properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar provisioning_state: Resource provisioning state. Known values are: "Succeeded", "Failed",
     and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.impactreporting.models.ProvisioningState
    :ivar category_id: Unique ID of the category. Required.
    :vartype category_id: str
    :ivar parent_category_id: Unique ID of the parent category.
    :vartype parent_category_id: str
    :ivar description: Description of the category.
    :vartype description: str
    :ivar required_impact_properties: The workloadImpact properties which are required when
     reporting with the impact category.
    :vartype required_impact_properties:
     list[~azure.mgmt.impactreporting.models.RequiredImpactProperties]
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    category_id: str = rest_field(name="categoryId", visibility=["read", "create", "update", "delete", "query"])
    """Unique ID of the category. Required."""
    parent_category_id: Optional[str] = rest_field(
        name="parentCategoryId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unique ID of the parent category."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the category."""
    required_impact_properties: Optional[List["_models.RequiredImpactProperties"]] = rest_field(
        name="requiredImpactProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """The workloadImpact properties which are required when reporting with the impact category."""

    @overload
    def __init__(
        self,
        *,
        category_id: str,
        parent_category_id: Optional[str] = None,
        description: Optional[str] = None,
        required_impact_properties: Optional[List["_models.RequiredImpactProperties"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImpactDetails(_model_base.Model):
    """details of of the impact for which insight has been generated.


    :ivar impacted_resource_id: List of impacted Azure resources. Required.
    :vartype impacted_resource_id: str
    :ivar start_time: Time at which impact was started according to reported impact. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Time at which impact was ended according to reported impact.
    :vartype end_time: ~datetime.datetime
    :ivar impact_id: Azure Id of the impact. Required.
    :vartype impact_id: str
    """

    impacted_resource_id: str = rest_field(
        name="impactedResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of impacted Azure resources. Required."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Time at which impact was started according to reported impact. Required."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Time at which impact was ended according to reported impact."""
    impact_id: str = rest_field(name="impactId", visibility=["read", "create", "update", "delete", "query"])
    """Azure Id of the impact. Required."""

    @overload
    def __init__(
        self,
        *,
        impacted_resource_id: str,
        start_time: datetime.datetime,
        impact_id: str,
        end_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Insight(ProxyResource):
    """Insight resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.impactreporting.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.impactreporting.models.InsightProperties
    """

    properties: Optional["_models.InsightProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.InsightProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InsightProperties(_model_base.Model):
    """Impact category properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar provisioning_state: Resource provisioning state. Known values are: "Succeeded", "Failed",
     and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.impactreporting.models.ProvisioningState
    :ivar category: category of the insight. Required.
    :vartype category: str
    :ivar status: status of the insight. example resolved, repaired, other.
    :vartype status: str
    :ivar event_id: Identifier of the event that has been correlated with this insight. This can be
     used to aggregate insights for the same event.
    :vartype event_id: str
    :ivar group_id: Identifier that can be used to group similar insights.
    :vartype group_id: str
    :ivar content: Contains title & description for the insight. Required.
    :vartype content: ~azure.mgmt.impactreporting.models.Content
    :ivar event_time: Time of the event, which has been correlated the impact.
    :vartype event_time: ~datetime.datetime
    :ivar insight_unique_id: unique id of the insight. Required.
    :vartype insight_unique_id: str
    :ivar impact: details of of the impact for which insight has been generated. Required.
    :vartype impact: ~azure.mgmt.impactreporting.models.ImpactDetails
    :ivar additional_details: additional details of the insight.
    :vartype additional_details: any
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """category of the insight. Required."""
    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """status of the insight. example resolved, repaired, other."""
    event_id: Optional[str] = rest_field(name="eventId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier of the event that has been correlated with this insight. This can be used to
     aggregate insights for the same event."""
    group_id: Optional[str] = rest_field(name="groupId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier that can be used to group similar insights."""
    content: "_models.Content" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Contains title & description for the insight. Required."""
    event_time: Optional[datetime.datetime] = rest_field(
        name="eventTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Time of the event, which has been correlated the impact."""
    insight_unique_id: str = rest_field(
        name="insightUniqueId", visibility=["read", "create", "update", "delete", "query"]
    )
    """unique id of the insight. Required."""
    impact: "_models.ImpactDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """details of of the impact for which insight has been generated. Required."""
    additional_details: Optional[Any] = rest_field(
        name="additionalDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """additional details of the insight."""

    @overload
    def __init__(
        self,
        *,
        category: str,
        content: "_models.Content",
        insight_unique_id: str,
        impact: "_models.ImpactDetails",
        status: Optional[str] = None,
        event_id: Optional[str] = None,
        group_id: Optional[str] = None,
        event_time: Optional[datetime.datetime] = None,
        additional_details: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.impactreporting.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.impactreporting.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.impactreporting.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class Performance(_model_base.Model):
    """Details about impacted performance metrics. Applicable for performance related impact.

    :ivar metric_name: Name of the Metric examples:  Disk, IOPs, CPU, GPU, Memory, details can be
     found from /impactCategories API.
    :vartype metric_name: str
    :ivar expected: Threshold value for the metric.
    :vartype expected: float
    :ivar actual: Observed value for the metric.
    :vartype actual: float
    :ivar expected_value_range: Max and Min Threshold values for the metric.
    :vartype expected_value_range: ~azure.mgmt.impactreporting.models.ExpectedValueRange
    :ivar unit: Unit of the metric ex: Bytes, Percentage, Count, Seconds, Milliseconds,
     Bytes/Second, Count/Second, etc.., Other. Known values are: "ByteSeconds", "Bytes",
     "BytesPerSecond", "Cores", "Count", "CountPerSecond", "MilliCores", "MilliSeconds",
     "NanoCores", "Percent", "Seconds", and "Other".
    :vartype unit: str or ~azure.mgmt.impactreporting.models.MetricUnit
    """

    metric_name: Optional[str] = rest_field(
        name="metricName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the Metric examples:  Disk, IOPs, CPU, GPU, Memory, details can be found from
     /impactCategories API."""
    expected: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Threshold value for the metric."""
    actual: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Observed value for the metric."""
    expected_value_range: Optional["_models.ExpectedValueRange"] = rest_field(
        name="expectedValueRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """Max and Min Threshold values for the metric."""
    unit: Optional[Union[str, "_models.MetricUnit"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Unit of the metric ex: Bytes, Percentage, Count, Seconds, Milliseconds, Bytes/Second,
     Count/Second, etc.., Other. Known values are: \"ByteSeconds\", \"Bytes\", \"BytesPerSecond\",
     \"Cores\", \"Count\", \"CountPerSecond\", \"MilliCores\", \"MilliSeconds\", \"NanoCores\",
     \"Percent\", \"Seconds\", and \"Other\"."""

    @overload
    def __init__(
        self,
        *,
        metric_name: Optional[str] = None,
        expected: Optional[float] = None,
        actual: Optional[float] = None,
        expected_value_range: Optional["_models.ExpectedValueRange"] = None,
        unit: Optional[Union[str, "_models.MetricUnit"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RequiredImpactProperties(_model_base.Model):
    """Required impact properties.


    :ivar name: Name of the property. Required.
    :vartype name: str
    :ivar allowed_values: Allowed values values for the property.
    :vartype allowed_values: list[str]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the property. Required."""
    allowed_values: Optional[List[str]] = rest_field(
        name="allowedValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allowed values values for the property."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        allowed_values: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceOrTarget(_model_base.Model):
    """Resource details.

    :ivar azure_resource_id: Azure resource id, example
     /subscription/{subscription}/resourceGroup/{rg}/Microsoft.compute/virtualMachine/{vmName}.
    :vartype azure_resource_id: str
    """

    azure_resource_id: Optional[str] = rest_field(
        name="azureResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource id, example
     /subscription/{subscription}/resourceGroup/{rg}/Microsoft.compute/virtualMachine/{vmName}."""

    @overload
    def __init__(
        self,
        *,
        azure_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.impactreporting.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.impactreporting.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Workload(_model_base.Model):
    """Information about the impacted workload.

    :ivar context: the scenario for the workload.
    :vartype context: str
    :ivar toolset: Tool used to interact with Azure. SDK, AzPortal, etc.., Other. Known values are:
     "Terraform", "Puppet", "Chef", "SDK", "Ansible", "ARM", "Portal", "Shell", and "Other".
    :vartype toolset: str or ~azure.mgmt.impactreporting.models.Toolset
    """

    context: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """the scenario for the workload."""
    toolset: Optional[Union[str, "_models.Toolset"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Tool used to interact with Azure. SDK, AzPortal, etc.., Other. Known values are: \"Terraform\",
     \"Puppet\", \"Chef\", \"SDK\", \"Ansible\", \"ARM\", \"Portal\", \"Shell\", and \"Other\"."""

    @overload
    def __init__(
        self,
        *,
        context: Optional[str] = None,
        toolset: Optional[Union[str, "_models.Toolset"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadImpact(ProxyResource):
    """Workload Impact properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.impactreporting.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.impactreporting.models.WorkloadImpactProperties
    """

    properties: Optional["_models.WorkloadImpactProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadImpactProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadImpactProperties(_model_base.Model):
    """Workload impact properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar provisioning_state: Resource provisioning state. Known values are: "Succeeded", "Failed",
     and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.impactreporting.models.ProvisioningState
    :ivar start_date_time: Time at which impact was observed. Required.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: Time at which impact has ended.
    :vartype end_date_time: ~datetime.datetime
    :ivar impacted_resource_id: Azure resource id of the impacted resource. Required.
    :vartype impacted_resource_id: str
    :ivar impact_unique_id: Unique ID of the impact (UUID).
    :vartype impact_unique_id: str
    :ivar reported_time_utc: Time at which impact is reported.
    :vartype reported_time_utc: ~datetime.datetime
    :ivar impact_category: Category of the impact,  details can found from /impactCategories API.
     Required.
    :vartype impact_category: str
    :ivar impact_description: A detailed description of the impact.
    :vartype impact_description: str
    :ivar arm_correlation_ids: The ARM correlation ids, this is important field for control plane
     related impacts.
    :vartype arm_correlation_ids: list[str]
    :ivar performance: Details about performance issue. Applicable for performance impacts.
    :vartype performance: list[~azure.mgmt.impactreporting.models.Performance]
    :ivar connectivity: Details about connectivity issue. Applicable when root resource causing the
     issue is not identified. For example, when a VM is impacted due to a network issue, the
     impacted resource is identified as the VM, but the root cause is the network. In such cases,
     the connectivity field will have the details about the network issue.
    :vartype connectivity: ~azure.mgmt.impactreporting.models.Connectivity
    :ivar additional_properties: Additional fields related to impact, applicable fields per
     resource type are list under /impactCategories API.
    :vartype additional_properties: any
    :ivar error_details: ARM error code and error message associated with the impact.
    :vartype error_details: ~azure.mgmt.impactreporting.models.ErrorDetailProperties
    :ivar workload: Information about the impacted workload.
    :vartype workload: ~azure.mgmt.impactreporting.models.Workload
    :ivar impact_group_id: Use this field to group impacts.
    :vartype impact_group_id: str
    :ivar confidence_level: Degree of confidence on the impact being a platform issue. Known values
     are: "Low", "Medium", and "High".
    :vartype confidence_level: str or ~azure.mgmt.impactreporting.models.ConfidenceLevel
    :ivar client_incident_details: Client incident details ex: incidentId , incident source.
    :vartype client_incident_details: ~azure.mgmt.impactreporting.models.ClientIncidentDetails
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    start_date_time: datetime.datetime = rest_field(
        name="startDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Time at which impact was observed. Required."""
    end_date_time: Optional[datetime.datetime] = rest_field(
        name="endDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Time at which impact has ended."""
    impacted_resource_id: str = rest_field(
        name="impactedResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource id of the impacted resource. Required."""
    impact_unique_id: Optional[str] = rest_field(name="impactUniqueId", visibility=["read"])
    """Unique ID of the impact (UUID)."""
    reported_time_utc: Optional[datetime.datetime] = rest_field(
        name="reportedTimeUtc", visibility=["read"], format="rfc3339"
    )
    """Time at which impact is reported."""
    impact_category: str = rest_field(name="impactCategory", visibility=["read", "create", "update", "delete", "query"])
    """Category of the impact,  details can found from /impactCategories API. Required."""
    impact_description: Optional[str] = rest_field(
        name="impactDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """A detailed description of the impact."""
    arm_correlation_ids: Optional[List[str]] = rest_field(
        name="armCorrelationIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ARM correlation ids, this is important field for control plane related impacts."""
    performance: Optional[List["_models.Performance"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Details about performance issue. Applicable for performance impacts."""
    connectivity: Optional["_models.Connectivity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Details about connectivity issue. Applicable when root resource causing the issue is not
     identified. For example, when a VM is impacted due to a network issue, the impacted resource is
     identified as the VM, but the root cause is the network. In such cases, the connectivity field
     will have the details about the network issue."""
    additional_properties: Optional[Any] = rest_field(
        name="additionalProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional fields related to impact, applicable fields per resource type are list under
     /impactCategories API."""
    error_details: Optional["_models.ErrorDetailProperties"] = rest_field(
        name="errorDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """ARM error code and error message associated with the impact."""
    workload: Optional["_models.Workload"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Information about the impacted workload."""
    impact_group_id: Optional[str] = rest_field(
        name="impactGroupId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Use this field to group impacts."""
    confidence_level: Optional[Union[str, "_models.ConfidenceLevel"]] = rest_field(
        name="confidenceLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """Degree of confidence on the impact being a platform issue. Known values are: \"Low\",
     \"Medium\", and \"High\"."""
    client_incident_details: Optional["_models.ClientIncidentDetails"] = rest_field(
        name="clientIncidentDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Client incident details ex: incidentId , incident source."""

    @overload
    def __init__(
        self,
        *,
        start_date_time: datetime.datetime,
        impacted_resource_id: str,
        impact_category: str,
        end_date_time: Optional[datetime.datetime] = None,
        impact_description: Optional[str] = None,
        arm_correlation_ids: Optional[List[str]] = None,
        performance: Optional[List["_models.Performance"]] = None,
        connectivity: Optional["_models.Connectivity"] = None,
        additional_properties: Optional[Any] = None,
        error_details: Optional["_models.ErrorDetailProperties"] = None,
        workload: Optional["_models.Workload"] = None,
        impact_group_id: Optional[str] = None,
        confidence_level: Optional[Union[str, "_models.ConfidenceLevel"]] = None,
        client_incident_details: Optional["_models.ClientIncidentDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
