# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storage.aio import StorageManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageManagementObjectReplicationPoliciesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_object_replication_policies_list(self, resource_group):
        response = self.client.object_replication_policies.list(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_object_replication_policies_get(self, resource_group):
        response = await self.client.object_replication_policies.get(
            resource_group_name=resource_group.name,
            account_name="str",
            object_replication_policy_id="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_object_replication_policies_create_or_update(self, resource_group):
        response = await self.client.object_replication_policies.create_or_update(
            resource_group_name=resource_group.name,
            account_name="str",
            object_replication_policy_id="str",
            properties={
                "destinationAccount": "str",
                "enabledTime": "2020-02-20 00:00:00",
                "id": "str",
                "metrics": {"enabled": bool},
                "name": "str",
                "policyId": "str",
                "rules": [
                    {
                        "destinationContainer": "str",
                        "sourceContainer": "str",
                        "filters": {"minCreationTime": "str", "prefixMatch": ["str"]},
                        "ruleId": "str",
                    }
                ],
                "sourceAccount": "str",
                "type": "str",
            },
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_object_replication_policies_delete(self, resource_group):
        response = await self.client.object_replication_policies.delete(
            resource_group_name=resource_group.name,
            account_name="str",
            object_replication_policy_id="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...
