# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class AccessPolicy(_serialization.Model):
    """An Access policy.

    :ivar start: the date-time the policy is active.
    :vartype start: str
    :ivar expiry: the date-time the policy expires.
    :vartype expiry: str
    :ivar permission: the permissions for the acl policy.
    :vartype permission: str
    """

    _attribute_map = {
        "start": {"key": "Start", "type": "str"},
        "expiry": {"key": "Expiry", "type": "str"},
        "permission": {"key": "Permission", "type": "str"},
    }

    def __init__(
        self,
        *,
        start: Optional[str] = None,
        expiry: Optional[str] = None,
        permission: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start: the date-time the policy is active.
        :paramtype start: str
        :keyword expiry: the date-time the policy expires.
        :paramtype expiry: str
        :keyword permission: the permissions for the acl policy.
        :paramtype permission: str
        """
        super().__init__(**kwargs)
        self.start = start
        self.expiry = expiry
        self.permission = permission


class CorsRule(_serialization.Model):
    """CORS is an HTTP feature that enables a web application running under one domain to access
    resources in another domain. Web browsers implement a security restriction known as same-origin
    policy that prevents a web page from calling APIs in a different domain; CORS provides a secure
    way to allow one domain (the origin domain) to call APIs in another domain.

    All required parameters must be populated in order to send to server.

    :ivar allowed_origins: The origin domains that are permitted to make a request against the
     storage service via CORS. The origin domain is the domain from which the request originates.
     Note that the origin must be an exact case-sensitive match with the origin that the user age
     sends to the service. You can also use the wildcard character '*' to allow all origin domains
     to make requests via CORS. Required.
    :vartype allowed_origins: str
    :ivar allowed_methods: The methods (HTTP request verbs) that the origin domain may use for a
     CORS request. (comma separated). Required.
    :vartype allowed_methods: str
    :ivar allowed_headers: the request headers that the origin domain may specify on the CORS
     request. Required.
    :vartype allowed_headers: str
    :ivar exposed_headers: The response headers that may be sent in the response to the CORS
     request and exposed by the browser to the request issuer. Required.
    :vartype exposed_headers: str
    :ivar max_age_in_seconds: The maximum amount time that a browser should cache the preflight
     OPTIONS request. Required.
    :vartype max_age_in_seconds: int
    """

    _validation = {
        "allowed_origins": {"required": True},
        "allowed_methods": {"required": True},
        "allowed_headers": {"required": True},
        "exposed_headers": {"required": True},
        "max_age_in_seconds": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "allowed_origins": {"key": "AllowedOrigins", "type": "str"},
        "allowed_methods": {"key": "AllowedMethods", "type": "str"},
        "allowed_headers": {"key": "AllowedHeaders", "type": "str"},
        "exposed_headers": {"key": "ExposedHeaders", "type": "str"},
        "max_age_in_seconds": {"key": "MaxAgeInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        allowed_origins: str,
        allowed_methods: str,
        allowed_headers: str,
        exposed_headers: str,
        max_age_in_seconds: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_origins: The origin domains that are permitted to make a request against the
         storage service via CORS. The origin domain is the domain from which the request originates.
         Note that the origin must be an exact case-sensitive match with the origin that the user age
         sends to the service. You can also use the wildcard character '*' to allow all origin domains
         to make requests via CORS. Required.
        :paramtype allowed_origins: str
        :keyword allowed_methods: The methods (HTTP request verbs) that the origin domain may use for a
         CORS request. (comma separated). Required.
        :paramtype allowed_methods: str
        :keyword allowed_headers: the request headers that the origin domain may specify on the CORS
         request. Required.
        :paramtype allowed_headers: str
        :keyword exposed_headers: The response headers that may be sent in the response to the CORS
         request and exposed by the browser to the request issuer. Required.
        :paramtype exposed_headers: str
        :keyword max_age_in_seconds: The maximum amount time that a browser should cache the preflight
         OPTIONS request. Required.
        :paramtype max_age_in_seconds: int
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.allowed_headers = allowed_headers
        self.exposed_headers = exposed_headers
        self.max_age_in_seconds = max_age_in_seconds


class DequeuedMessageItem(_serialization.Model):
    """The object returned in the QueueMessageList array when calling Get Messages on a Queue.

    All required parameters must be populated in order to send to server.

    :ivar message_id: The Id of the Message. Required.
    :vartype message_id: str
    :ivar insertion_time: The time the Message was inserted into the Queue. Required.
    :vartype insertion_time: ~datetime.datetime
    :ivar expiration_time: The time that the Message will expire and be automatically deleted.
     Required.
    :vartype expiration_time: ~datetime.datetime
    :ivar pop_receipt: This value is required to delete the Message. If deletion fails using this
     popreceipt then the message has been dequeued by another client. Required.
    :vartype pop_receipt: str
    :ivar time_next_visible: The time that the message will again become visible in the Queue.
     Required.
    :vartype time_next_visible: ~datetime.datetime
    :ivar dequeue_count: The number of times the message has been dequeued. Required.
    :vartype dequeue_count: int
    :ivar message_text: The content of the Message. Required.
    :vartype message_text: str
    """

    _validation = {
        "message_id": {"required": True},
        "insertion_time": {"required": True},
        "expiration_time": {"required": True},
        "pop_receipt": {"required": True},
        "time_next_visible": {"required": True},
        "dequeue_count": {"required": True},
        "message_text": {"required": True},
    }

    _attribute_map = {
        "message_id": {"key": "MessageId", "type": "str"},
        "insertion_time": {"key": "InsertionTime", "type": "rfc-1123"},
        "expiration_time": {"key": "ExpirationTime", "type": "rfc-1123"},
        "pop_receipt": {"key": "PopReceipt", "type": "str"},
        "time_next_visible": {"key": "TimeNextVisible", "type": "rfc-1123"},
        "dequeue_count": {"key": "DequeueCount", "type": "int"},
        "message_text": {"key": "MessageText", "type": "str"},
    }
    _xml_map = {"name": "QueueMessage"}

    def __init__(
        self,
        *,
        message_id: str,
        insertion_time: datetime.datetime,
        expiration_time: datetime.datetime,
        pop_receipt: str,
        time_next_visible: datetime.datetime,
        dequeue_count: int,
        message_text: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword message_id: The Id of the Message. Required.
        :paramtype message_id: str
        :keyword insertion_time: The time the Message was inserted into the Queue. Required.
        :paramtype insertion_time: ~datetime.datetime
        :keyword expiration_time: The time that the Message will expire and be automatically deleted.
         Required.
        :paramtype expiration_time: ~datetime.datetime
        :keyword pop_receipt: This value is required to delete the Message. If deletion fails using
         this popreceipt then the message has been dequeued by another client. Required.
        :paramtype pop_receipt: str
        :keyword time_next_visible: The time that the message will again become visible in the Queue.
         Required.
        :paramtype time_next_visible: ~datetime.datetime
        :keyword dequeue_count: The number of times the message has been dequeued. Required.
        :paramtype dequeue_count: int
        :keyword message_text: The content of the Message. Required.
        :paramtype message_text: str
        """
        super().__init__(**kwargs)
        self.message_id = message_id
        self.insertion_time = insertion_time
        self.expiration_time = expiration_time
        self.pop_receipt = pop_receipt
        self.time_next_visible = time_next_visible
        self.dequeue_count = dequeue_count
        self.message_text = message_text


class EnqueuedMessage(_serialization.Model):
    """The object returned in the QueueMessageList array when calling Put Message on a Queue.

    All required parameters must be populated in order to send to server.

    :ivar message_id: The Id of the Message. Required.
    :vartype message_id: str
    :ivar insertion_time: The time the Message was inserted into the Queue. Required.
    :vartype insertion_time: ~datetime.datetime
    :ivar expiration_time: The time that the Message will expire and be automatically deleted.
     Required.
    :vartype expiration_time: ~datetime.datetime
    :ivar pop_receipt: This value is required to delete the Message. If deletion fails using this
     popreceipt then the message has been dequeued by another client. Required.
    :vartype pop_receipt: str
    :ivar time_next_visible: The time that the message will again become visible in the Queue.
     Required.
    :vartype time_next_visible: ~datetime.datetime
    """

    _validation = {
        "message_id": {"required": True},
        "insertion_time": {"required": True},
        "expiration_time": {"required": True},
        "pop_receipt": {"required": True},
        "time_next_visible": {"required": True},
    }

    _attribute_map = {
        "message_id": {"key": "MessageId", "type": "str"},
        "insertion_time": {"key": "InsertionTime", "type": "rfc-1123"},
        "expiration_time": {"key": "ExpirationTime", "type": "rfc-1123"},
        "pop_receipt": {"key": "PopReceipt", "type": "str"},
        "time_next_visible": {"key": "TimeNextVisible", "type": "rfc-1123"},
    }
    _xml_map = {"name": "QueueMessage"}

    def __init__(
        self,
        *,
        message_id: str,
        insertion_time: datetime.datetime,
        expiration_time: datetime.datetime,
        pop_receipt: str,
        time_next_visible: datetime.datetime,
        **kwargs: Any
    ) -> None:
        """
        :keyword message_id: The Id of the Message. Required.
        :paramtype message_id: str
        :keyword insertion_time: The time the Message was inserted into the Queue. Required.
        :paramtype insertion_time: ~datetime.datetime
        :keyword expiration_time: The time that the Message will expire and be automatically deleted.
         Required.
        :paramtype expiration_time: ~datetime.datetime
        :keyword pop_receipt: This value is required to delete the Message. If deletion fails using
         this popreceipt then the message has been dequeued by another client. Required.
        :paramtype pop_receipt: str
        :keyword time_next_visible: The time that the message will again become visible in the Queue.
         Required.
        :paramtype time_next_visible: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.message_id = message_id
        self.insertion_time = insertion_time
        self.expiration_time = expiration_time
        self.pop_receipt = pop_receipt
        self.time_next_visible = time_next_visible


class GeoReplication(_serialization.Model):
    """GeoReplication.

    All required parameters must be populated in order to send to server.

    :ivar status: The status of the secondary location. Required. Known values are: "live",
     "bootstrap", and "unavailable".
    :vartype status: str or ~azure.storage.queue.models.GeoReplicationStatusType
    :ivar last_sync_time: A GMT date/time value, to the second. All primary writes preceding this
     value are guaranteed to be available for read operations at the secondary. Primary writes after
     this point in time may or may not be available for reads. Required.
    :vartype last_sync_time: ~datetime.datetime
    """

    _validation = {
        "status": {"required": True},
        "last_sync_time": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "Status", "type": "str"},
        "last_sync_time": {"key": "LastSyncTime", "type": "rfc-1123"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.GeoReplicationStatusType"],
        last_sync_time: datetime.datetime,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The status of the secondary location. Required. Known values are: "live",
         "bootstrap", and "unavailable".
        :paramtype status: str or ~azure.storage.queue.models.GeoReplicationStatusType
        :keyword last_sync_time: A GMT date/time value, to the second. All primary writes preceding
         this value are guaranteed to be available for read operations at the secondary. Primary writes
         after this point in time may or may not be available for reads. Required.
        :paramtype last_sync_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.last_sync_time = last_sync_time


class ListQueuesSegmentResponse(_serialization.Model):
    """The object returned when calling List Queues on a Queue Service.

    All required parameters must be populated in order to send to server.

    :ivar service_endpoint: Required.
    :vartype service_endpoint: str
    :ivar prefix: Required.
    :vartype prefix: str
    :ivar marker:
    :vartype marker: str
    :ivar max_results: Required.
    :vartype max_results: int
    :ivar queue_items:
    :vartype queue_items: list[~azure.storage.queue.models.QueueItem]
    :ivar next_marker: Required.
    :vartype next_marker: str
    """

    _validation = {
        "service_endpoint": {"required": True},
        "prefix": {"required": True},
        "max_results": {"required": True},
        "next_marker": {"required": True},
    }

    _attribute_map = {
        "service_endpoint": {"key": "ServiceEndpoint", "type": "str", "xml": {"attr": True}},
        "prefix": {"key": "Prefix", "type": "str"},
        "marker": {"key": "Marker", "type": "str"},
        "max_results": {"key": "MaxResults", "type": "int"},
        "queue_items": {
            "key": "QueueItems",
            "type": "[QueueItem]",
            "xml": {"name": "Queues", "wrapped": True, "itemsName": "Queue"},
        },
        "next_marker": {"key": "NextMarker", "type": "str"},
    }
    _xml_map = {"name": "EnumerationResults"}

    def __init__(
        self,
        *,
        service_endpoint: str,
        prefix: str,
        max_results: int,
        next_marker: str,
        marker: Optional[str] = None,
        queue_items: Optional[List["_models.QueueItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_endpoint: Required.
        :paramtype service_endpoint: str
        :keyword prefix: Required.
        :paramtype prefix: str
        :keyword marker:
        :paramtype marker: str
        :keyword max_results: Required.
        :paramtype max_results: int
        :keyword queue_items:
        :paramtype queue_items: list[~azure.storage.queue.models.QueueItem]
        :keyword next_marker: Required.
        :paramtype next_marker: str
        """
        super().__init__(**kwargs)
        self.service_endpoint = service_endpoint
        self.prefix = prefix
        self.marker = marker
        self.max_results = max_results
        self.queue_items = queue_items
        self.next_marker = next_marker


class Logging(_serialization.Model):
    """Azure Analytics Logging settings.

    All required parameters must be populated in order to send to server.

    :ivar version: The version of Storage Analytics to configure. Required.
    :vartype version: str
    :ivar delete: Indicates whether all delete requests should be logged. Required.
    :vartype delete: bool
    :ivar read: Indicates whether all read requests should be logged. Required.
    :vartype read: bool
    :ivar write: Indicates whether all write requests should be logged. Required.
    :vartype write: bool
    :ivar retention_policy: the retention policy. Required.
    :vartype retention_policy: ~azure.storage.queue.models.RetentionPolicy
    """

    _validation = {
        "version": {"required": True},
        "delete": {"required": True},
        "read": {"required": True},
        "write": {"required": True},
        "retention_policy": {"required": True},
    }

    _attribute_map = {
        "version": {"key": "Version", "type": "str"},
        "delete": {"key": "Delete", "type": "bool"},
        "read": {"key": "Read", "type": "bool"},
        "write": {"key": "Write", "type": "bool"},
        "retention_policy": {"key": "RetentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        version: str,
        delete: bool,
        read: bool,
        write: bool,
        retention_policy: "_models.RetentionPolicy",
        **kwargs: Any
    ) -> None:
        """
        :keyword version: The version of Storage Analytics to configure. Required.
        :paramtype version: str
        :keyword delete: Indicates whether all delete requests should be logged. Required.
        :paramtype delete: bool
        :keyword read: Indicates whether all read requests should be logged. Required.
        :paramtype read: bool
        :keyword write: Indicates whether all write requests should be logged. Required.
        :paramtype write: bool
        :keyword retention_policy: the retention policy. Required.
        :paramtype retention_policy: ~azure.storage.queue.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.version = version
        self.delete = delete
        self.read = read
        self.write = write
        self.retention_policy = retention_policy


class Metrics(_serialization.Model):
    """a summary of request statistics grouped by API in hour or minute aggregates for queues.

    All required parameters must be populated in order to send to server.

    :ivar version: The version of Storage Analytics to configure.
    :vartype version: str
    :ivar enabled: Indicates whether metrics are enabled for the Queue service. Required.
    :vartype enabled: bool
    :ivar include_apis: Indicates whether metrics should generate summary statistics for called API
     operations.
    :vartype include_apis: bool
    :ivar retention_policy: the retention policy.
    :vartype retention_policy: ~azure.storage.queue.models.RetentionPolicy
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "version": {"key": "Version", "type": "str"},
        "enabled": {"key": "Enabled", "type": "bool"},
        "include_apis": {"key": "IncludeAPIs", "type": "bool"},
        "retention_policy": {"key": "RetentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        version: Optional[str] = None,
        include_apis: Optional[bool] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: The version of Storage Analytics to configure.
        :paramtype version: str
        :keyword enabled: Indicates whether metrics are enabled for the Queue service. Required.
        :paramtype enabled: bool
        :keyword include_apis: Indicates whether metrics should generate summary statistics for called
         API operations.
        :paramtype include_apis: bool
        :keyword retention_policy: the retention policy.
        :paramtype retention_policy: ~azure.storage.queue.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.version = version
        self.enabled = enabled
        self.include_apis = include_apis
        self.retention_policy = retention_policy


class PeekedMessageItem(_serialization.Model):
    """The object returned in the QueueMessageList array when calling Peek Messages on a Queue.

    All required parameters must be populated in order to send to server.

    :ivar message_id: The Id of the Message. Required.
    :vartype message_id: str
    :ivar insertion_time: The time the Message was inserted into the Queue. Required.
    :vartype insertion_time: ~datetime.datetime
    :ivar expiration_time: The time that the Message will expire and be automatically deleted.
     Required.
    :vartype expiration_time: ~datetime.datetime
    :ivar dequeue_count: The number of times the message has been dequeued. Required.
    :vartype dequeue_count: int
    :ivar message_text: The content of the Message. Required.
    :vartype message_text: str
    """

    _validation = {
        "message_id": {"required": True},
        "insertion_time": {"required": True},
        "expiration_time": {"required": True},
        "dequeue_count": {"required": True},
        "message_text": {"required": True},
    }

    _attribute_map = {
        "message_id": {"key": "MessageId", "type": "str"},
        "insertion_time": {"key": "InsertionTime", "type": "rfc-1123"},
        "expiration_time": {"key": "ExpirationTime", "type": "rfc-1123"},
        "dequeue_count": {"key": "DequeueCount", "type": "int"},
        "message_text": {"key": "MessageText", "type": "str"},
    }
    _xml_map = {"name": "QueueMessage"}

    def __init__(
        self,
        *,
        message_id: str,
        insertion_time: datetime.datetime,
        expiration_time: datetime.datetime,
        dequeue_count: int,
        message_text: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword message_id: The Id of the Message. Required.
        :paramtype message_id: str
        :keyword insertion_time: The time the Message was inserted into the Queue. Required.
        :paramtype insertion_time: ~datetime.datetime
        :keyword expiration_time: The time that the Message will expire and be automatically deleted.
         Required.
        :paramtype expiration_time: ~datetime.datetime
        :keyword dequeue_count: The number of times the message has been dequeued. Required.
        :paramtype dequeue_count: int
        :keyword message_text: The content of the Message. Required.
        :paramtype message_text: str
        """
        super().__init__(**kwargs)
        self.message_id = message_id
        self.insertion_time = insertion_time
        self.expiration_time = expiration_time
        self.dequeue_count = dequeue_count
        self.message_text = message_text


class QueueItem(_serialization.Model):
    """An Azure Storage Queue.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the Queue. Required.
    :vartype name: str
    :ivar metadata: Dictionary of :code:`<string>`.
    :vartype metadata: dict[str, str]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "Name", "type": "str"},
        "metadata": {"key": "Metadata", "type": "{str}"},
    }
    _xml_map = {"name": "Queue"}

    def __init__(self, *, name: str, metadata: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the Queue. Required.
        :paramtype name: str
        :keyword metadata: Dictionary of :code:`<string>`.
        :paramtype metadata: dict[str, str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.metadata = metadata


class QueueMessage(_serialization.Model):
    """A Message object which can be stored in a Queue.

    All required parameters must be populated in order to send to server.

    :ivar message_text: The content of the message. Required.
    :vartype message_text: str
    """

    _validation = {
        "message_text": {"required": True},
    }

    _attribute_map = {
        "message_text": {"key": "MessageText", "type": "str"},
    }

    def __init__(self, *, message_text: str, **kwargs: Any) -> None:
        """
        :keyword message_text: The content of the message. Required.
        :paramtype message_text: str
        """
        super().__init__(**kwargs)
        self.message_text = message_text


class RetentionPolicy(_serialization.Model):
    """the retention policy.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Indicates whether a retention policy is enabled for the storage service.
     Required.
    :vartype enabled: bool
    :ivar days: Indicates the number of days that metrics or logging or soft-deleted data should be
     retained. All data older than this value will be deleted.
    :vartype days: int
    """

    _validation = {
        "enabled": {"required": True},
        "days": {"minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "Enabled", "type": "bool"},
        "days": {"key": "Days", "type": "int"},
    }

    def __init__(self, *, enabled: bool, days: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Indicates whether a retention policy is enabled for the storage service.
         Required.
        :paramtype enabled: bool
        :keyword days: Indicates the number of days that metrics or logging or soft-deleted data should
         be retained. All data older than this value will be deleted.
        :paramtype days: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class SignedIdentifier(_serialization.Model):
    """signed identifier.

    All required parameters must be populated in order to send to server.

    :ivar id: a unique id. Required.
    :vartype id: str
    :ivar access_policy: The access policy.
    :vartype access_policy: ~azure.storage.queue.models.AccessPolicy
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "Id", "type": "str"},
        "access_policy": {"key": "AccessPolicy", "type": "AccessPolicy"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        access_policy: Optional["_models.AccessPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: a unique id. Required.
        :paramtype id: str
        :keyword access_policy: The access policy.
        :paramtype access_policy: ~azure.storage.queue.models.AccessPolicy
        """
        super().__init__(**kwargs)
        self.id = id
        self.access_policy = access_policy


class StorageError(_serialization.Model):
    """StorageError.

    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        "message": {"key": "Message", "type": "str"},
    }

    def __init__(self, *, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword message:
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.message = message


class StorageServiceProperties(_serialization.Model):
    """Storage Service Properties.

    :ivar logging: Azure Analytics Logging settings.
    :vartype logging: ~azure.storage.queue.models.Logging
    :ivar hour_metrics: A summary of request statistics grouped by API in hourly aggregates for
     queues.
    :vartype hour_metrics: ~azure.storage.queue.models.Metrics
    :ivar minute_metrics: a summary of request statistics grouped by API in minute aggregates for
     queues.
    :vartype minute_metrics: ~azure.storage.queue.models.Metrics
    :ivar cors: The set of CORS rules.
    :vartype cors: list[~azure.storage.queue.models.CorsRule]
    """

    _attribute_map = {
        "logging": {"key": "Logging", "type": "Logging"},
        "hour_metrics": {"key": "HourMetrics", "type": "Metrics"},
        "minute_metrics": {"key": "MinuteMetrics", "type": "Metrics"},
        "cors": {"key": "Cors", "type": "[CorsRule]", "xml": {"wrapped": True}},
    }

    def __init__(
        self,
        *,
        logging: Optional["_models.Logging"] = None,
        hour_metrics: Optional["_models.Metrics"] = None,
        minute_metrics: Optional["_models.Metrics"] = None,
        cors: Optional[List["_models.CorsRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword logging: Azure Analytics Logging settings.
        :paramtype logging: ~azure.storage.queue.models.Logging
        :keyword hour_metrics: A summary of request statistics grouped by API in hourly aggregates for
         queues.
        :paramtype hour_metrics: ~azure.storage.queue.models.Metrics
        :keyword minute_metrics: a summary of request statistics grouped by API in minute aggregates
         for queues.
        :paramtype minute_metrics: ~azure.storage.queue.models.Metrics
        :keyword cors: The set of CORS rules.
        :paramtype cors: list[~azure.storage.queue.models.CorsRule]
        """
        super().__init__(**kwargs)
        self.logging = logging
        self.hour_metrics = hour_metrics
        self.minute_metrics = minute_metrics
        self.cors = cors


class StorageServiceStats(_serialization.Model):
    """Stats for the storage service.

    :ivar geo_replication: Geo-Replication information for the Secondary Storage Service.
    :vartype geo_replication: ~azure.storage.queue.models.GeoReplication
    """

    _attribute_map = {
        "geo_replication": {"key": "GeoReplication", "type": "GeoReplication"},
    }

    def __init__(self, *, geo_replication: Optional["_models.GeoReplication"] = None, **kwargs: Any) -> None:
        """
        :keyword geo_replication: Geo-Replication information for the Secondary Storage Service.
        :paramtype geo_replication: ~azure.storage.queue.models.GeoReplication
        """
        super().__init__(**kwargs)
        self.geo_replication = geo_replication
