/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "txfunctions.h"
#include "global.h"
#include "configparams.h"
#include <qmutex.h>
#include "imagecoder.h"
#include "synthes.h"
#include "modes/modes.h"
#include "dispatcher.h"
#include "cw.h"
#include <QApplication>
#include <assert.h>

QMutex txMutex;

esstvMode modeIndexTx;
int templateIndex;
bool useTemplate;
bool useCW;
bool useVOX;

txFunction::txFunction()
{
  synthesPtr=new synthesizer(txClock);
  currentMode=0;
  txState=TXIDLE;
}

txFunction::~txFunction()
{
  delete synthesPtr;
  if(currentMode) delete currentMode;
}

void txFunction::run()
{
	abortRun=FALSE;
	init();
	while(!abortRun)
    {
      progressTXEvent *ce;
      switch (txState)
        {
          case TXIDLE:
            msleep(1);
          break;
          case TXACTIVE:
            msleep(1);
          break;
          case TXSENDTONE:
            addToLog("txFunc: entered TXSENDTONE",DBTXFUNC);
            synthesPtr->sendTone(toneDuration,toneLowerFrequency,toneUpperFrequency,FALSE);
            addToLog("txFunc: TXSENDTONE waiting for end",DBTXFUNC);
            waitEnd();
            txState=TXIDLE;
          break;

          case TXFAXSTART:
            addToLog("txFunc: TXFAXSTART",DBTXFUNC);
//            initSSTVImage();
            faxStart();
            addToLog("txFunc: TXFAXSTART waiting for end",DBTXFUNC);
            waitEnd();
            txState=TXIDLE;
          break;

          case TXSSTVIMAGE:
            addToLog("txFunc: entered TXIMAGE",DBTXFUNC);
//            initSSTVImage();
            ce=new progressTXEvent(calcTxTime());
            QApplication::postEvent( dispatchPtr, ce );  // Qt will delete it when done
            if(txSSTVParam.mode==FAX480)
              {
                for (int i=0;i<1220;i++)
                  {
                    synthesPtr->sendTone(0.00205,1500,0,TRUE);
                    synthesPtr->sendTone(0.00205,2300,0,TRUE);
                  }
               }
            else
              {
               sendPreamble();
               sendVIS();
              }
            addToLog("txFunc: sendImage",DBTXFUNC);
            sendImage();
            addToLog("txFunc: endImage",DBTXFUNC);
            txState=TXSSTVPOST;
          break;
          case TXSSTVPOST:
            addToLog("txFunc: TXSSTVPOST ",DBTXFUNC);
            sendCW();
            waitEnd();
            txState=TXIDLE;
          break;
          case TXTEST:
            sendTestPattern();
          break;

        }
      }
    addToLog("txFunc stopped",DBTXFUNC);
}


void txFunction::init()
{
  addToLog("txFunc: Init",DBTXFUNC);
	sampleCounter=0;
	
}


bool txFunction::create(esstvMode m,DSPFLOAT clock)
{
  if(currentMode) delete currentMode;
  currentMode=0;
  switch (m)
    {
      case M1:
      case M2:
        currentMode=new modeGBR(m,TXSTRIPE,TRUE);
      break;
      case S1:
      case S2:
      case SDX:
        currentMode=new modeGBR2(m,TXSTRIPE,TRUE);
      break;
      case R36:
        currentMode=new modeRobot1(m,TXSTRIPE,TRUE);
      break;
      case R24:
      case R72:
          currentMode=new modeRobot2(m,TXSTRIPE,TRUE);
    break;
      case SC2_60:
      case SC2_120:
      case SC2_180:
      case P3:
      case P5:
      case P7:
          currentMode=new modeRGB(m,TXSTRIPE,TRUE);
      break;
      case FAX480:
      case BW8:
      case BW12:
          currentMode=new modeBW(m,TXSTRIPE,TRUE);
      break;
      case AVT24:
      case AVT90:
      case AVT94:
          currentMode=new modeAVT(m,TXSTRIPE,TRUE);
      break;
      case PD50:
      case PD90:
      case PD120:
      case PD160:
      case PD180:
      case PD240:
      case PD290:
      case MP73:
      case MP115:
      case MP140:
      case MP175:
          currentMode=new modePD(m,TXSTRIPE,TRUE);
      break;
      default:
        m=NOTVALID;
      break;
    }
  if (m!=NOTVALID)
    {
      initializeSSTVParametersIndex(m,TRUE);
      QString s=getSSTVModeNameLong(m);
      addToLog("create: create TX mode",DBTXFUNC);
      assert(currentMode);
     currentMode->init(clock);
      return TRUE;
    }
  return FALSE;
}



void txFunction::abort()
{
  addToLog("abort(): abort called",DBTXFUNC);
  abortRun=TRUE;
}



void txFunction::sendTestPattern()
{
  if(patternNumber==TPBURST) syncBurst();
}



/** send a burst of syncs */
/*
void txFunction::syncBurst()
{
  // we will send 5msec 1200Hz followed by 50 msec silence
//	synthesPtr->sendTone(0.005,1200.);
  for (int i=300;i<3000;i++)
    {
      synthesPtr->sendTone(0.005,(double) i);
    }
  synthesPtr->sendSilence(0.100);;
}
*/

/** send a burst of syncs */
void txFunction::syncBurst()
{
  // send 5msec 1200Hz followed by 50 msec silence
//	synthesPtr->sendTone(0.005,1200.);
  for (int i=0;i<50;i++)
    {
      synthesPtr->sendTone(0.005,1200,0,TRUE);
      synthesPtr->sendTone(0.020,1700,0,TRUE);
    }
  synthesPtr->sendSilence(0.100);;
}

void txFunction::faxStart()
{
  // send 300Hz modulated 1500Hz/2300Hz tone
//	synthesPtr->sendTone(0.005,1200.);
  for (int i=0;i<100;i++)
    {
      synthesPtr->sendTone(0.0333,1500,0,TRUE);
      synthesPtr->sendTone(0.0333,2300,0,TRUE);
    }
  synthesPtr->sendSilence(0.100);;
}




void txFunction::startTestPattern(uint tpnum)
{
  patternNumber=tpnum;
  txState=TXTEST;
}


//void txFunction:: initSSTVImage()
//{
//  create(modeIndexTx,txClock);
//}

void txFunction:: sendPreamble()
{
  addToLog("txFunc:sendPreamble",DBTXFUNC);
  if(useVOX) synthesPtr->sendTone(1.,1700.,0,FALSE);
  synthesPtr->sendTone(0.1,1900.,0,TRUE);
  synthesPtr->sendTone(0.1,1500.,0,TRUE);
  synthesPtr->sendTone(0.1,1900.,0,TRUE);
  synthesPtr->sendTone(0.1,1500.,0,TRUE);
  synthesPtr->sendTone(0.1,2300.,0,TRUE);
  synthesPtr->sendTone(0.1,1500.,0,TRUE);
  synthesPtr->sendTone(0.1,2300.,0,TRUE);
  synthesPtr->sendTone(0.1,1500.,0,TRUE);
  synthesPtr->sendTone(0.3,1900.,0,TRUE);
  synthesPtr->sendTone(0.01,1200.,0,TRUE);
  synthesPtr->sendTone(0.3,1900.,0,TRUE);
}



void txFunction:: sendVIS()
{
  int i,l;
  int t=txSSTVParam.VISCode;
  addToLog("txFunc:sendVis",DBTXFUNC);
  if ((t&0xFF)==0x23) l=16;
  else l=8;
  synthesPtr->sendTone(0.030,1200,0,FALSE); // startbit
  for (i=0;i<l;i++)
    {
      if((t&1)==1) synthesPtr->sendTone(0.030,1100,0,TRUE);
      else synthesPtr->sendTone(0.030,1300,0,TRUE);
      t>>=1;
    }
  synthesPtr->sendTone(0.030,1200,0,TRUE); // stopbit
}


void txFunction::sendCW()
{
  if(!useCW) return;
  addToLog("txFunc:sendCW",DBTXFUNC);
  float tone;
  float duration;
  initCW(cwText);
  synthesPtr->sendSilence(0.5);
  while(sendTextCW(tone,duration))
    {
      synthesPtr->sendTone(duration,tone,0,TRUE);
    }
}

void txFunction::waitEnd()
{
  synthesPtr->sendTone(0.300,00,0,FALSE);
  addToLog("waitEnd() posting endTXImage",DBTXFUNC);
  endImageTXEvent *ce=new endImageTXEvent;
  QApplication::postEvent(dispatchPtr, ce );  // Qt will delete it when done
}

double txFunction::calcTxTime()
{
  double tim;
  float tone;
  float duration;
  initializeSSTVParametersIndex(modeIndexTx,TRUE);
  int t=txSSTVParam.VISCode;
  initCW(cwText);
  tim=1.41; //preamble;
  if ((t&0xFF)==0x23) tim+=18.*0.03;
  else tim+=10.*0.03;
  tim+=txSSTVParam.imageTime;
  tim+=0.5 ;//CW silence gap
  if(useCW)
    {
      while(sendTextCW(tone,duration))
        {
          tim+=duration;
        }
    }
  tim+=0.3; // trailer;
  addToLog(QString("txFunc: calcTimeTx %1").arg(tim),DBTXFUNC);
  return tim;
}


void txFunction::sendImage()
{
  addToLog("txFunc: sendImage",DBTXFUNC);
  currentMode->transmitImage(txViewer);
}

void txFunction::logStatus()
{
  QString stat,statr;
  if(isRunning()) statr="TRUE"; else statr="FALSE";
  addToLog(QString("TX Is running %1").arg(statr),DBDISPAT);
  stat="TX state: ";
  switch (txState)
    {
      case TXIDLE: stat+="IDLE";  break;
      case TXACTIVE: stat+="ACTIVE";  break;
      case TXSENDTONE: stat+="SENDTONE";  break;
      case TXSSTVIMAGE: stat+="SSTVIMAGE";  break;
      case TXSSTVPOST: stat+="SSTVPOST";  break;
      case TXFAXSTART: stat+="FAXSTART";  break;
      case TXTEST: stat+="TEST";  break;
  }
   addToLog(stat,DBDISPAT);
}





