/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "modegbr.h"


modeGBR::modeGBR(esstvMode m,unsigned int len, bool tx):modeBase(m,len,tx)
{
	
}


modeGBR::~modeGBR()
{
}


void modeGBR::setupParams(double clock)
{
	visibleLineLength=(lineLength(mode,clock)-fp-bp-2*blank-syncDuration)/3.;
}

modeBase::embState modeGBR::rxSetupLine()
{	
  start=lineTimeTableRX[lineCounter];
  //if(subLine==0) addToLog(QString("modeGBR: subLine %1, line=%2, absSampleCounter %3").arg(subLine).arg(lineCounter).arg(start+rxSampleCounter),DBMODES);
	
  switch(subLine)
		{
			case 0:
				calcPixelPositionTable(GREENLINE,false);
				pixelArrayPtr=greenArrayPtr;
				return MBPIXELS;
			case 1:
				debugState=stG1;
				marker=(unsigned int)round(start+bp+blank+visibleLineLength);
				return MBRXWAIT;
			case 2:
				calcPixelPositionTable(BLUELINE,false);
				pixelArrayPtr=blueArrayPtr;
				return MBPIXELS;
			case 3:
				debugState=stG2;
				marker=(unsigned int)round(start+bp+2*blank+2*visibleLineLength);
				return MBRXWAIT;
			case 4:
				calcPixelPositionTable(REDLINE,false);
				pixelArrayPtr=redArrayPtr;
				return MBPIXELS;
			case 5:
				debugState=stSync;
        syncPosition=(unsigned int) round(lineTimeTableRX[lineCounter+1]);
				return MBSYNC;
			break;
			default:
				return MBENDOFLINE;
		}
}

void modeGBR::calcPixelPositionTable(unsigned int colorLine,bool tx)
{
	unsigned int i;
	int ofx=0;
	if(tx) ofx=1;
	debugState=stColorLine0+colorLine;
	
	switch (colorLine)
		{
			case GREENLINE:
				start+=bp;
 //       addToLog(QString("calcPixelPosition: startGreen %1").arg(start+rxSampleCounter),DBMODES);
			break;
			case BLUELINE:
        start+=(bp+visibleLineLength+blank);
 //       addToLog(QString("calcPixelPosition: startBlue %1").arg(start+rxSampleCounter),DBMODES);
			break;
			case REDLINE:
        start+=(bp+2.*visibleLineLength+2.*blank);
 //        addToLog(QString("calcPixelPosition: startRed %1").arg(start+rxSampleCounter),DBMODES);
			break;
		}
  for(i=0;i<activeSSTVParam->numberOfPixels;i++)
		{
      pixelPositionTable[i]=(unsigned int)round(start+(((float)(i+ofx)*visibleLineLength)/activeSSTVParam->numberOfPixels));
		}
}


modeBase::embState modeGBR::txSetupLine()
{
  start=lineTimeTableTX[lineCounter];
  switch(subLine)
		{
			case 0:
				calcPixelPositionTable(GREENLINE,true);
				pixelArrayPtr=greenArrayPtr;
				return MBPIXELS;
			case 1:
				txFreq=1500.;
				txDur=(unsigned int)rint(blank);
				return MBTXGAP;
			case 2:
				calcPixelPositionTable(BLUELINE,true);
				pixelArrayPtr=blueArrayPtr;
				return MBPIXELS;
			case 3:
				txFreq=1500.;
				txDur=(unsigned int)rint(blank);
				return MBTXGAP;
			case 4:
				calcPixelPositionTable(REDLINE,true);
				pixelArrayPtr=redArrayPtr;
				return MBPIXELS;
			case 5:
				txFreq=1500;
				txDur=(unsigned int)rint(fp);
				return MBTXGAP;
			case 6:
				txFreq=1200;
				txDur=(unsigned int)rint(syncDuration);
				return MBTXGAP;
      case 7:
        txFreq=1500;
        txDur=(unsigned int)rint(bp);
      return MBTXGAP;
      default:
				return MBENDOFLINE;
		}
}

