% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAtomicVector.R
\name{readAtomicVector}
\alias{readAtomicVector}
\alias{loadAtomicVector}
\title{Read an atomic vector from disk}
\usage{
readAtomicVector(path, metadata, ...)
}
\arguments{
\item{path}{Path to a directory created with any of the vector methods for \code{\link{saveObject}}.}

\item{metadata}{Named list containing metadata for the object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments, ignored.}
}
\value{
The vector described by \code{info}.
}
\description{
Read a vector consisting of atomic elements from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
tmp <- tempfile()
saveObject(setNames(runif(26), letters), tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,integer-method}"}, for one of the staging methods.
}
\author{
Aaron Lun
}
