% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allPackage.R
\docType{package}
\name{dada2-package}
\alias{dada2-package}
\title{DADA2 package}
\description{
The dada2 package is centered around the DADA2 algorithm for accurate high-resolution
of sample composition from amplicon sequencing data. The DADA2 algorithm is both more
sensitive and more specific than commonly used OTU methods, and resolves amplicon
sequence variants (ASVs) that differ by as little as one nucleotide.
}
\details{
The dada2 package also provides a full set of tools for taking raw amplicon sequencing
data all the way through to a feature table representing sample composition. Provided
facilities include:

\itemize{
 \item Quality filtering (\code{\link{filterAndTrim}}, \code{\link{fastqFilter}}, \code{\link{fastqPairedFilter}})
 \item Dereplication (\code{\link{derepFastq}})
 \item Learn error rates (\code{\link{learnErrors}})
 \item Sample Inference (\code{\link{dada}})
 \item Chimera Removal (\code{\link{removeBimeraDenovo}}, \code{\link{isBimeraDenovo}}, \code{\link{isBimeraDenovoTable}})
 \item Merging of Paired Reads (\code{\link{mergePairs}})
 \item Taxonomic Classification (\code{\link{assignTaxonomy}}, \code{\link{assignSpecies}})
}
}
\author{
Benjamin Callahan \email{benjamin.j.callahan@gmail.com}

Paul J McMurdie II \email{mcmurdie@stanford.edu}

Michael Rosen \email{eigenrosen@gmail.com}

Susan Holmes \email{susan@stat.stanford.edu}
}
\keyword{package}
