% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomTrack-class.R
\docType{class}
\name{CustomTrack-class}
\alias{CustomTrack-class}
\alias{initialize,CustomTrack-method}
\alias{CustomTrack}
\alias{drawGD,CustomTrack-method}
\alias{show,CustomTrack-method}
\title{CustomTrack class and methods}
\usage{
\S4method{initialize}{CustomTrack}(.Object, plottingFunction, variables, ...)

CustomTrack(
  plottingFunction = function(GdObject, prepare = FALSE, ...) {
 },
  variables = list(),
  name = "CustomTrack",
  ...
)

\S4method{drawGD}{CustomTrack}(GdObject, minBase, maxBase, prepare = FALSE, ...)

\S4method{show}{CustomTrack}(object)
}
\arguments{
\item{.Object}{.Object}

\item{plottingFunction}{A user-defined function to be executed once the
track coordinates have been properly set up. The function needs to accept
two mandatory arguments: \code{GdObject}, the \code{CustomTrack} object to
be plotted, and \code{prepare}, a logical flag indicating whether the
function has been called in preparation mode or in drawing mode. It also
needs to return the input \code{GdObject}, potentially with modifications.}

\item{variables}{A list of additional variables for the user-defined
plotting function.}

\item{\dots}{Additional items which will all be interpreted as further
display parameters. See \code{settings} and the "Display Parameters"
section below for details.}

\item{name}{Character scalar of the track's name.}

\item{GdObject}{Object of \code{GdObject-class}.}

\item{minBase}{minBase}

\item{maxBase}{maxBase}

\item{prepare}{\code{logical}}

\item{object}{object}
}
\value{
The return value of the constructor function is a new object of class
\code{CustomTrack}.
}
\description{
A fully customizable track object to be populated via a user-defined
plotting function.
}
\details{
A track to allow for any sort of plotting, with the currently displayed
genomic location set. Essentially this acts as a simple callback into the
\code{Gviz} plotting machinery after all the track panels and coordinates
have been set up. It is entirely up to the user what to plot in the track,
or even to use the predefined coordinate system. The only prerequisite is
that all plotting operations need to utilize Grid graphics.
}
\section{Functions}{
\itemize{
\item \code{initialize(CustomTrack)}: Initialize.

\item \code{CustomTrack()}: Objects can be created using the constructor function.

\item \code{drawGD(CustomTrack)}: plot the object to a graphics device.
The return value of this method is the input object, potentially updated
during the plotting operation. Internally, there are two modes in which the
method can be called. Either in 'prepare' mode, in which case no plotting is
done but the object is preprocessed based on the available space, or in
'plotting' mode, in which case the actual graphical output is created.
Since subsetting of the object can be potentially costly, this can be
switched off in case subsetting has already been performed before or
is not necessary.

\item \code{show(CustomTrack)}: Show method.

}}
\examples{
## Object construction:

## An empty object
CustomTrack()
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
