% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\title{Do predictions using a fitted MOFA model}
\usage{
predict(object, views = "all", factors = "all", type = c("inRange",
  "response", "link"))
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{views}{character vector with the view name(s), or numeric vector with the view index(es). 
Default is "all".}

\item{factors}{character vector with the factor name(s) or numeric vector with the factor index(es). 
Default is "all".}

\item{type}{type of prediction returned, either: 
\itemize{
 \item{\strong{response}:}{ gives the response vector, the mean for Gaussian and Poisson,
  and success probabilities for Bernoulli.}
 \item{\strong{link}:}{ gives the linear predictions.}
 \item{\strong{inRange}:}{ rounds the fitted values of integer-valued distributions 
 (Poisson and Bernoulli) to the next integer.
 This is the default option.}
}}
}
\value{
Returns a list with data predictions.
}
\description{
This function uses the factors and the corresponding weights to do data predictions.
}
\details{
Matrix factorization models generate a denoised and condensed low-dimensional representation 
of the data which capture the main sources of heterogeneity of the data. 
Such representation can be used to do predictions (data reconstruction) and imputation (see \code{\link{impute}}). \cr
For mathematical details, see the Methods section of the MOFA article.
}
\examples{
library(ggplot2)

# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)

# predict drug response data using all factors
predictedDrugs <- predict(MOFA_CLL, view="Drugs")

# predict all views using all factors (default)
predictedAll <- predict(MOFA_CLL)

# predict Mutation data using all factors, returning Bernoulli probabilities
predictedMutations <- predict(MOFA_CLL, view="Mutations", type="response")

# predict Mutation data using all factors, returning binary classes
predictedMutationsBinary <- predict(MOFA_CLL, view="Mutations", type="inRange")

# Compare the predictions with the true data
pred <- as.numeric(predictedAll$Drugs)
true <- as.numeric(getTrainData(MOFA_CLL)$Drugs)
qplot(pred,true) + geom_hex(bins=100) + coord_equal() + 
   geom_abline(intercept=0, slope=1, col="red")

# Example on the scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)

# Predict all views using all factors (default)
predictedAll <- predict(MOFA_scMT)
 
# Compare the predictions with the true data
view <- "RNA expression"
pred <- as.numeric(predictedAll[[view]])
true <- as.numeric(getTrainData(MOFA_scMT)[[view]])
qplot(pred,true) + geom_hex(bins=100) + coord_equal() + 
   geom_abline(intercept=0, slope=1, col="red") 
}
