% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterVcfMuTect.R
\name{filterVcfMuTect}
\alias{filterVcfMuTect}
\title{Filter VCF MuTect}
\usage{
filterVcfMuTect(
  vcf,
  tumor.id.in.vcf = NULL,
  stats.file = NULL,
  ignore = c("clustered_read_position", "fstar_tumor_lod", "nearby_gap_events",
    "poor_mapping_region_alternate_allele_mapq", "poor_mapping_region_mapq0",
    "possible_contamination", "strand_artifact", "seen_in_panel_of_normals"),
  ...
)
}
\arguments{
\item{vcf}{\code{CollapsedVCF} object, read in with the \code{readVcf}
function from the VariantAnnotation package.}

\item{tumor.id.in.vcf}{The tumor id in the VCF file, optional.}

\item{stats.file}{MuTect stats file. If \code{NULL}, will check if VCF
was generated by MuTect2 and if yes will call \code{\link{filterVcfMuTect2}}
instead.}

\item{ignore}{MuTect flags that mark variants for exclusion.}

\item{\dots}{Additional arguments passed to \code{\link{filterVcfBasic}}.}
}
\value{
A list with elements \code{vcf}, \code{flag} and
\code{flag_comment}.  \code{vcf} contains the filtered \code{CollapsedVCF},
\code{flag} a \code{logical(1)} flag if problems were identified, further
described in \code{flag_comment}.
}
\description{
Function to remove artifacts and low confidence/quality calls from a MuTect
generated VCF file. Also applies filters defined in \code{filterVcfBasic}.
This function will only keep variants listed in the stats file and those not
matching the specified failure reasons.
}
\examples{

### This function is typically only called by runAbsolute via the 
### fun.filterVcf and args.filterVcf comments.
library(VariantAnnotation)    
vcf.file <- system.file("extdata", "example.vcf.gz", package="PureCN")
vcf <- readVcf(vcf.file, "hg19")
vcf.filtered <- filterVcfMuTect(vcf)        

}
\seealso{
\code{\link{filterVcfBasic}}
}
\author{
Markus Riester
}
