% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/307-extractDrugAtomCount.R
\name{extractDrugAtomCount}
\alias{extractDrugAtomCount}
\title{Calculate the Number of Atom Descriptor}
\usage{
extractDrugAtomCount(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{nAtom}.
}
\description{
Calculate the Number of Atom Descriptor
}
\details{
Calculates the number of atoms of a certain element type in a molecule.
By default it returns the count of all atoms.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugAtomCount(mol)
head(dat)}
}
