% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{TCGAanalyze_EAcomplete}
\alias{TCGAanalyze_EAcomplete}
\title{Enrichment analysis for Gene Ontology (GO) [BP,MF,CC] and Pathways}
\usage{
TCGAanalyze_EAcomplete(TFname, RegulonList)
}
\arguments{
\item{TFname}{is the name of the list of genes or TF's regulon.}

\item{RegulonList}{List of genes such as TF's regulon or DEGs where to find enrichment.}
}
\value{
Enrichment analysis GO[BP,MF,CC] and Pathways complete table enriched by genelist.
}
\description{
Researchers, in order to better understand the underlying biological
  processes, often want to retrieve a functional profile of a set of genes
  that might have an important role. This can be done by performing an
  enrichment analysis.

We will perform an enrichment analysis on gene sets using the TCGAanalyze_EAcomplete
function. Given a set of genes that are
up-regulated under certain conditions, an enrichment analysis will find
identify classes of genes or proteins that are #'over-represented using
annotations for that gene set.
}
\examples{
Genelist <- c("FN1","COL1A1")
ansEA <- TCGAanalyze_EAcomplete(TFname="DEA genes Normal Vs Tumor",Genelist)
\dontrun{
Genelist <- rownames(dataDEGsFiltLevel)
system.time(ansEA <- TCGAanalyze_EAcomplete(TFname="DEA genes Normal Vs Tumor",Genelist))
}
}
