% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argparser.R
\name{parse_args}
\alias{parse_args}
\title{Parse arguments with a parser.}
\usage{
parse_args(parser, argv = NULL)
}
\arguments{
\item{parser}{an \code{arg.parser} object}

\item{argv}{a character vector to parse (arguments and values should 
already be split by whitespace);
if \code{NULL}, values will be obtained from \code{argv} if
\code{argv} exists in the global scope, or from
\code{commandArgs(trailingOnly=TRUE)}.}
}
\value{
a list with argument values
}
\description{
This function uses an \code{arg.parser} object to parse command line arguments or a
character vector.
}
\examples{
p <- arg_parser('pi')
p <- add_argument(p, "--digits",
  help="number of significant digits to print", default=7)

\dontrun{
# If arguments are passed from the command line,
# then we would use the following:
argv <- parse_args(p)
}

# For testing purposes, we can pass a character vector:
argv <- parse_args(p, c("-d", "30"))

# Now, the script runs based on the passed arguments
digits <- if (argv$digits > 22) 22 else argv$digits
print(pi, digits=digits)

\dontrun{
# We can also save an argument list for later use
saveRDS(argv, "arguments.rds")

# To use the saved arguments, use the --opts argument at the command line
#$ ./script.R --opts arguments.rds
} 

}
