% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_predict.R
\name{loo_R2.brmsfit}
\alias{loo_R2.brmsfit}
\alias{loo_R2}
\title{Compute a LOO-adjusted R-squared for regression models}
\usage{
\method{loo_R2}{brmsfit}(object, resp = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{...}{Further arguments passed to 
\code{\link[brms:pp_expect.brmsfit]{pp_expect}} and
\code{\link[brms:log_lik.brmsfit]{log_lik}},
which are used in the computation of the R-squared values.}
}
\value{
A real value per response variable indicating 
the LOO-adjusted R-squared.
}
\description{
Compute a LOO-adjusted R-squared for regression models
}
\examples{
\dontrun{
fit <- brm(mpg ~ wt + cyl, data = mtcars)
summary(fit)
loo_R2(fit)

# compute R2 with new data
nd <- data.frame(mpg = c(10, 20, 30), wt = c(4, 3, 2), cyl = c(8, 6, 4))
loo_R2(fit, newdata = nd)
}

}
