% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brms_tidiers.R
\name{brms_tidiers}
\alias{brms_tidiers}
\alias{tidy.brmsfit}
\alias{glance.brmsfit}
\alias{augment.brmsfit}
\title{Tidying methods for a brms model}
\usage{
\method{tidy}{brmsfit}(
  x,
  parameters = NA,
  effects = c("fixed", "ran_pars"),
  robust = FALSE,
  conf.int = TRUE,
  conf.level = 0.95,
  conf.method = c("quantile", "HPDinterval"),
  fix.intercept = TRUE,
  ...
)

\method{glance}{brmsfit}(x, looic = FALSE, ...)

\method{augment}{brmsfit}(x, data = stats::model.frame(x), newdata = NULL, se.fit = TRUE, ...)
}
\arguments{
\item{x}{Fitted model object from the \pkg{brms} package. See
\code{\link[brms]{brmsfit-class}}.}

\item{parameters}{Names of parameters for which a summary should be
returned, as given by a character vector or regular expressions.
If \code{NA} (the default) summarized parameters are specified
by the \code{effects} argument.}

\item{effects}{A character vector including one or more of \code{"fixed"},
\code{"ran_vals"}, or \code{"ran_pars"}.
See the Value section for details.}

\item{robust}{Whether to use median and median absolute deviation of
the posterior distribution, rather
  than mean and standard deviation, to derive point estimates and uncertainty}

\item{conf.int}{If \code{TRUE} columns for the lower (\code{conf.low})
and upper bounds (\code{conf.high}) of posterior uncertainty intervals are included.}

\item{conf.level}{Defines the range of the posterior uncertainty conf.int,
such that \code{100 * conf.level}\% of the parameter's posterior distributio
lies within the corresponding interval.
Only used if \code{conf.int = TRUE}.}

\item{conf.method}{method for computing confidence intervals
("quantile" or "HPDinterval")}

\item{fix.intercept}{rename "Intercept" parameter to "(Intercept)", to match
behaviour of other model types?}

\item{...}{Extra arguments, not used}

\item{looic}{Should the LOO Information Criterion (and related info) be
included? See \code{\link[rstan]{loo.stanfit}} for details. (This
can be slow for models fit to large datasets.)}

\item{data}{data frame}

\item{newdata}{new data frame}

\item{se.fit}{return standard errors of fit?}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

When \code{parameters = NA}, the \code{effects} argument is used
to determine which parameters to summarize.

Generally, \code{tidy.brmsfit} returns
one row for each coefficient, with at least three columns:
\item{term}{The name of the model parameter.}
\item{estimate}{A point estimate of the coefficient (mean or median).}
\item{std.error}{A standard error for the point estimate (sd or mad).}

When \code{effects = "fixed"}, only population-level
effects are returned.

When \code{effects = "ran_vals"}, only group-level effects are returned.
In this case, two additional columns are added:
\item{group}{The name of the grouping factor.}
\item{level}{The name of the level of the grouping factor.}

Specifying \code{effects = "ran_pars"} selects the
standard deviations and correlations of the group-level parameters.

If \code{conf.int = TRUE}, columns for the \code{lower} and
\code{upper} bounds of the posterior conf.int computed.
}
\description{
These methods tidy the estimates from
\code{\link[brms:brmsfit-class]{brmsfit-objects}}
(fitted model objects from the \pkg{brms} package) into a summary.
}
\note{
The names \sQuote{fixed}, \sQuote{ran_pars}, and \sQuote{ran_vals}
(corresponding to "non-varying", "hierarchical", and "varying" respectively
in previous versions of the package), while technically inappropriate in
a Bayesian setting where "fixed" and "random" effects are not well-defined,
are used for compatibility with other (frequentist) mixed model types.

At present, the components of parameter estimates are separated by parsing the column names of \code{posterior_samples} (e.g. \code{r_patient[1,Intercept]} for the random effect on the intercept for patient 1, or \code{b_Trt1} for the fixed effect \code{Trt1}. We try to detect underscores in parameter names and warn, but detection may be imperfect.
}
\examples{
 ## original model
 \dontrun{
    brms_crossedRE <- brm(mpg ~ wt + (1|cyl) + (1+wt|gear), data = mtcars,
           iter = 500, chains = 2)
 }
 if (.Platform$OS.type!="windows" && require("brms")) {
   ## too slow on Windows, skip (>5 seconds on r-devel-windows)
   ## load stored object
   load(system.file("extdata", "brms_example.rda", package="broom.mixed"))

   fit <- brms_crossedRE
   tidy(fit)
   tidy(fit, parameters = "^sd_", conf.int = FALSE)
   tidy(fit, effects = "fixed", conf.method="HPDinterval")
   tidy(fit, effects = "ran_vals")
   tidy(fit, effects = "ran_pars", robust = TRUE)
   # glance method
   glance(fit)
   ## this example will give a warning that it should be run with
   ## reloo=TRUE; however, doing this will fail
   ## because the \code{fit} object has been stripped down to save space
   suppressWarnings(glance(fit, looic = TRUE, cores = 1))
   head(augment(fit))
}

}
\seealso{
\code{\link[brms]{brms}}, \code{\link[brms]{brmsfit-class}}
}
