% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholder.R
\name{thresholder}
\alias{thresholder}
\title{Generate Data to Choose a Probability Threshold}
\usage{
thresholder(x, threshold, final = TRUE)
}
\arguments{
\item{x}{A \code{\link{train}} object where the values of
\code{savePredictions} was either \code{TRUE}, \code{"all"},
or \code{"final"} in \code{\link{trainControl}}. Also, the 
control argument \code{clasProbs} should have been \code{TRUE}.}

\item{threshold}{A numeric vector of candidate probability thresholds
between [0,1]. If the class probability corresponding to the first
level of the outcome is greater than the threshold, the data point
is classified as that level.}

\item{final}{A logical: should only the final tuning parameters
chosen by \code{\link{train}} be used when 
\code{savePredictions = 'all'}?}
}
\value{
A data frame with columns for each of the tuning parameters
 from the model along with an additional column called
 \code{prob_threshold} for the probability threshold. There are
 also columns for summary statistics averaged over resamples with
 column names \code{Sensitivity}, \code{Specificity}, \code{J},
 \code{Dist}. The last two correspond to Youden's J statistic 
 and the distance to the best possible cutoff (i.e. perfect
 sensitivity and specificity).
}
\description{
This function uses the resampling results from a \code{\link{train}}
 object to generate performance statistics over a set of probability
 thresholds for two-class problems.
}
\examples{
\dontrun{
set.seed(2444)
dat <- twoClassSim(500, intercept = -10)
table(dat$Class)

ctrl <- trainControl(method = "cv", 
                     classProbs = TRUE,
                     savePredictions = "all",
                     summaryFunction = twoClassSummary)

set.seed(2863)
mod <- train(Class ~ ., data = dat, 
             method = "rda",
             tuneLength = 4,
             metric = "ROC",
             trControl = ctrl)

resample_stats <- thresholder(mod, 
                              threshold = seq(.5, 1, by = 0.05), 
                              final = TRUE)

ggplot(resample_stats, aes(x = prob_threshold, y = J)) + 
  geom_point()
ggplot(resample_stats, aes(x = prob_threshold, y = Dist)) + 
  geom_point()
ggplot(resample_stats, aes(x = prob_threshold, y = Sensitivity)) + 
  geom_point() + 
  geom_point(aes(y = Specificity), col = "red")
}
}
