% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkEnvironment.r
\name{checkEnvironment}
\alias{assertEnvironment}
\alias{checkEnvironment}
\alias{testEnvironment}
\title{Check if an argument is an environment}
\usage{
checkEnvironment(x, contains = character(0L))

assertEnvironment(x, contains = character(0L), .var.name)

testEnvironment(x, contains = character(0L))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{contains}{[\code{character}]\cr
Vector of object names expected in the environment.
Defaults to \code{character(0)}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertEnvironment} throws an error message,
 \code{testEnvironment} returns \code{FALSE} and \code{checkEnvironment} returns
 a string with the error message.
}
\description{
Check if an argument is an environment
}
\examples{
ee = as.environment(list(a = 1))
testEnvironment(ee)
testEnvironment(ee, contains = "a")
}
\seealso{
Other basetypes: \code{\link{assertArray}},
  \code{\link{checkArray}}, \code{\link{testArray}};
  \code{\link{assertAtomicVector}},
  \code{\link{checkAtomicVector}},
  \code{\link{testAtomicVector}};
  \code{\link{assertAtomic}}, \code{\link{checkAtomic}},
  \code{\link{testAtomic}}; \code{\link{assertCharacter}},
  \code{\link{checkCharacter}},
  \code{\link{testCharacter}}; \code{\link{assertComplex}},
  \code{\link{checkComplex}}, \code{\link{testComplex}};
  \code{\link{assertDataFrame}},
  \code{\link{checkDataFrame}},
  \code{\link{testDataFrame}}; \code{\link{assertFactor}},
  \code{\link{checkFactor}}, \code{\link{testFactor}};
  \code{\link{assertFunction}},
  \code{\link{checkFunction}}, \code{\link{testFunction}};
  \code{\link{assertIntegerish}},
  \code{\link{checkIntegerish}},
  \code{\link{testIntegerish}};
  \code{\link{assertInteger}}, \code{\link{checkInteger}},
  \code{\link{testInteger}}; \code{\link{assertList}},
  \code{\link{checkList}}, \code{\link{testList}};
  \code{\link{assertLogical}}, \code{\link{checkLogical}},
  \code{\link{testLogical}}; \code{\link{assertMatrix}},
  \code{\link{checkMatrix}}, \code{\link{testMatrix}};
  \code{\link{assertNumeric}}, \code{\link{checkNumeric}},
  \code{\link{testNumeric}}; \code{\link{assertVector}},
  \code{\link{checkVector}}, \code{\link{testVector}}
}

