% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asInteger.R
\name{asInteger}
\alias{asInteger}
\alias{asCount}
\alias{asInt}
\title{Convert an argument to an integer}
\usage{
asInteger(
  x,
  tol = sqrt(.Machine$double.eps),
  lower = -Inf,
  upper = Inf,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  .var.name = vname(x)
)

asCount(
  x,
  na.ok = FALSE,
  positive = FALSE,
  tol = sqrt(.Machine$double.eps),
  .var.name = vname(x)
)

asInt(
  x,
  na.ok = FALSE,
  lower = -Inf,
  upper = Inf,
  tol = sqrt(.Machine$double.eps),
  .var.name = vname(x)
)
}
\arguments{
\item{x}{[any]\cr
Object to convert.}

\item{tol}{[\code{double(1)}]\cr
Numerical tolerance used to check whether a double or complex can be converted.
Default is \code{sqrt(.Machine$double.eps)}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than or equal to.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than or equal to.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with no non-missing values allowed? Default is \code{TRUE}.
Note that empty vectors do not have non-missing values.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{sorted}{[\code{logical(1)}]\cr
Elements must be sorted in ascending order. Missing values are ignored.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in error messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{positive}{[\code{logical(1)}]\cr
Must \code{x} be positive (>= 1)?
Default is \code{FALSE}.}
}
\value{
Converted \code{x}.
}
\description{
\code{asInteger} is intended to be used for vectors while \code{asInt} is
a specialization for scalar integers and \code{asCount} for scalar
non-negative integers.
Convertible are (a) atomic vectors with all elements \code{NA}
and (b) double vectors with all elements being within \code{tol}
range of an integer.

Note that these functions may be deprecated in the future.
Instead, it is advised to use \code{\link{assertCount}},
\code{\link{assertInt}} or \code{\link{assertIntegerish}} with
argument \code{coerce} set to \code{TRUE} instead.
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
asInteger(c(1, 2, 3))
asCount(1)
asInt(1)
}
