% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-chk-error.R
\name{expect_chk_error}
\alias{expect_chk_error}
\title{Expect Chk Error}
\usage{
expect_chk_error(
  object,
  regexp = NULL,
  ...,
  info = NULL,
  label = NULL,
  class = NULL
)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link[testthat]{quasi_label} for more details.}

\item{regexp}{Regular expression to test against.
\itemize{
\item A character vector giving a regular expression that must match the
error message.
\item If \code{NULL}, the default, asserts that there should be an error,
but doesn't test for a specific value.
\item If \code{NA}, asserts that there should be no errors, but we now recommend
using \code{\link[testthat:expect_no_error]{expect_no_error()}} and friends instead.
}

Note that you should only use \code{message} with errors/warnings/messages
that you generate. Avoid tests that rely on the specific text generated by
another package since this can easily change. If you do need to test text
generated by another package, either protect the test with \code{skip_on_cran()}
or use \code{expect_snapshot()}.}

\item{...}{
  Arguments passed on to \code{\link[testthat:expect_match]{expect_match}}
  \describe{
    \item{\code{fixed}}{If \code{TRUE}, treats \code{regexp} as a string to be matched exactly
(not a regular expressions). Overrides \code{perl}.}
    \item{\code{perl}}{logical.  Should Perl-compatible regexps be used?}
  }}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link[testthat]{quasi_label}.}

\item{label}{Used to customise failure messages. For expert use only.}

\item{class}{Must be NULL.}
}
\value{
If \code{regexp = NA}, the value of the first argument; otherwise
the captured condition.
}
\description{
\code{\link[=expect_chk_error]{expect_chk_error()}} checks that code throws an error
of class \code{"chk_error"} with a message that matches regexp.
See below for more details.
}
\section{Testing \code{message} vs \code{class}}{


When checking that code generates an error, it's important to check that the
error is the one you expect. There are two ways to do this. The first
way is the simplest: you just provide a \code{regexp} that match some fragment
of the error message. This is easy, but fragile, because the test will
fail if the error message changes (even if its the same error).

A more robust way is to test for the class of the error, if it has one.
You can learn more about custom conditions at
\url{https://adv-r.hadley.nz/conditions.html#custom-conditions}, but in
short, errors are S3 classes and you can generate a custom class and check
for it using \code{class} instead of \code{regexp}.

If you are using \code{expect_error()} to check that an error message is
formatted in such a way that it makes sense to a human, we recommend
using \code{\link[testthat:expect_snapshot]{expect_snapshot()}} instead.

}

\examples{
expect_chk_error(chk_true(FALSE))
try(expect_chk_error(chk_false(FALSE)))
}
\seealso{
\code{\link[testthat:expect_no_error]{expect_no_error()}}, \code{expect_no_warning()},
\code{expect_no_message()}, and \code{expect_no_condition()} to assert
that code runs without errors/warnings/messages/conditions.

Other expectations: 
\code{\link[testthat]{comparison-expectations}},
\code{\link[testthat]{equality-expectations}},
\code{\link[testthat]{expect_length}()},
\code{\link[testthat]{expect_match}()},
\code{\link[testthat]{expect_named}()},
\code{\link[testthat]{expect_null}()},
\code{\link[testthat]{expect_output}()},
\code{\link[testthat]{expect_reference}()},
\code{\link[testthat]{expect_silent}()},
\code{\link[testthat]{inheritance-expectations}},
\code{\link[testthat]{logical-expectations}}
}
