% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utf8.R
\name{utf8_graphemes}
\alias{utf8_graphemes}
\title{Break an UTF-8 character vector into grapheme clusters}
\usage{
utf8_graphemes(x)
}
\arguments{
\item{x}{Character vector.}
}
\value{
List of characters vectors, the grapheme clusters of the input
string.
}
\description{
Break an UTF-8 character vector into grapheme clusters
}
\examples{
# Five grapheme clusters
str <- paste0(
  "\U0001f477\U0001f3ff\u200d\u2640\ufe0f",
  "\U0001f477\U0001f3ff",
  "\U0001f477\u200d\u2640\ufe0f",
  "\U0001f477\U0001f3fb",
  "\U0001f477\U0001f3ff")
cat(str, "\n")
chrs <- utf8_graphemes(str)
}
\seealso{
Other UTF-8 string manipulation: 
\code{\link{utf8_nchar}()},
\code{\link{utf8_substr}()}
}
\concept{UTF-8 string manipulation}
