% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_nodes_from_df_cols.R
\name{add_nodes_from_df_cols}
\alias{add_nodes_from_df_cols}
\title{Add nodes from distinct values in data frame columns}
\usage{
add_nodes_from_df_cols(
  graph,
  df,
  columns,
  type = NULL,
  keep_duplicates = FALSE
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{df}{A data frame from which values will be taken as new nodes for the
graph.}

\item{columns}{A character vector of column names or a numeric vector of
column numbers for the data frame supplied in \code{df}. The distinct values in
these columns will serve as labels for the nodes added to the graph.}

\item{type}{An optional, single-length character vector that provides a group
identifier for the nodes to be added to the graph.}

\item{keep_duplicates}{An option to exclude incoming nodes where the labels
(i.e., values found in columns of the specified \code{df}) match label values
available in the graph's nodes. By default, this is set to \code{FALSE}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Add new nodes to a graph object of class \code{dgr_graph} using distinct values
from one or more columns in a data frame. The values will serve as node
labels and the number of nodes added depends on the number of distinct values
found in the specified columns.
}
\examples{
# Create an empty graph
graph <- create_graph()

# Create a data frame from
# which several columns have
# values designated as graph nodes
df <-
  data.frame(
    col_1 = c("f", "p", "q"),
    col_2 = c("q", "x", "f"),
    col_3 = c(1, 5, 3),
    col_4 = c("a", "v", "h"),
    stringsAsFactors = FALSE)

# Add nodes from columns `col_1`
# and `col_2` from the data frame
# to the graph object
graph <-
  graph \%>\%
  add_nodes_from_df_cols(
    df = df,
    columns = c("col_1", "col_2"))

# Show the graph's node data
# frame; duplicate labels are
# prevented with `keep_duplicates =
# FALSE`)
graph \%>\% get_node_df()

# Add new nodes from columns 3 and 4;
# We can specify the columns by their
# numbers as well
graph <-
  graph \%>\%
  add_nodes_from_df_cols(
    df = df,
    columns = 3:4)

# Show the graph's node data
# frame; note that nodes didn't
# get made with columns that
# are not character class columns
graph \%>\% get_node_df()

}
\seealso{
Other node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_node}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_table}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_node}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_position}()}
}
\concept{node creation and removal}
