% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event.R
\name{dyLimit}
\alias{dyLimit}
\title{dygraph limit line}
\usage{
dyLimit(dygraph, limit, label = NULL, labelLoc = c("left", "right"),
  color = "black", strokePattern = "dashed")
}
\arguments{
\item{dygraph}{Dygraph to add limit line to}

\item{limit}{Numeric position of limit.}

\item{label}{Label for limit. Defaults to blank.}

\item{labelLoc}{Location for label (left or right).}

\item{color}{Color of limit line. This can be of the form "#AABBCC" or 
"rgb(255,100,200)" or "yellow". Defaults to black.}

\item{strokePattern}{A predefined stroke pattern type ("dotted", "dashed",
"dotdash", or "solid") or a custom pattern array where the even index is 
a draw and odd is a space in pixels. Defaults to dashed.}
}
\value{
A dygraph with the specified limit line.
}
\description{
Add a horizontal limit line to a dygraph
}
\note{
See the \href{https://rstudio.github.io/dygraphs/gallery-event-lines.html}{online 
  documentation} for additional details and examples.
}
\examples{
library(dygraphs)

dygraph(presidents, main = "Presidential Approval") \%>\%
  dyAxis("y", valueRange = c(0, 100)) \%>\% 
  dyLimit(max(presidents, na.rm = TRUE), "Max",
          strokePattern = "solid", color = "blue")
 
}
