% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_between_riskchange.R
\name{oddsratio_to_riskratio}
\alias{oddsratio_to_riskratio}
\alias{oddsratio_to_arr}
\alias{oddsratio_to_nnt}
\alias{logoddsratio_to_riskratio}
\alias{logoddsratio_to_arr}
\alias{logoddsratio_to_nnt}
\alias{riskratio_to_oddsratio}
\alias{riskratio_to_arr}
\alias{riskratio_to_logoddsratio}
\alias{riskratio_to_nnt}
\alias{arr_to_riskratio}
\alias{arr_to_oddsratio}
\alias{arr_to_logoddsratio}
\alias{arr_to_nnt}
\alias{nnt_to_oddsratio}
\alias{nnt_to_logoddsratio}
\alias{nnt_to_riskratio}
\alias{nnt_to_arr}
\title{Convert Between Odds Ratios, Risk Ratios and Other Metrics of Change in Probabilities}
\usage{
oddsratio_to_riskratio(OR, p0, log = FALSE, verbose = TRUE, ...)

oddsratio_to_arr(OR, p0, log = FALSE, verbose = TRUE, ...)

oddsratio_to_nnt(OR, p0, log = FALSE, verbose = TRUE, ...)

logoddsratio_to_riskratio(logOR, p0, log = TRUE, verbose = TRUE, ...)

logoddsratio_to_arr(logOR, p0, log = TRUE, verbose = TRUE, ...)

logoddsratio_to_nnt(logOR, p0, log = TRUE, verbose = TRUE, ...)

riskratio_to_oddsratio(RR, p0, log = FALSE, verbose = TRUE, ...)

riskratio_to_arr(RR, p0, verbose = TRUE, ...)

riskratio_to_logoddsratio(RR, p0, log = TRUE, verbose = TRUE, ...)

riskratio_to_nnt(RR, p0, verbose = TRUE, ...)

arr_to_riskratio(ARR, p0, verbose = TRUE, ...)

arr_to_oddsratio(ARR, p0, log = FALSE, verbose = TRUE, ...)

arr_to_logoddsratio(ARR, p0, log = TRUE, verbose = TRUE, ...)

arr_to_nnt(ARR, ...)

nnt_to_oddsratio(NNT, p0, log = FALSE, verbose = TRUE, ...)

nnt_to_logoddsratio(NNT, p0, log = TRUE, verbose = TRUE, ...)

nnt_to_riskratio(NNT, p0, verbose = TRUE, ...)

nnt_to_arr(NNT, ...)
}
\arguments{
\item{OR, logOR, RR, ARR, NNT}{Odds-ratio of \code{odds(p1)/odds(p0)}, log-Odds-ratio
of \code{log(odds(p1)/odds(p0))}, Risk ratio of \code{p1/p0}, Absolute Risk Reduction
of \code{p1 - p0}, or Number-needed-to-treat of \code{1/(p1 - p0)}. \code{OR} and \code{logOR}
can also be a logistic regression model.}

\item{p0}{Baseline risk}

\item{log}{If:
\itemize{
\item \code{TRUE}:
\itemize{
\item In \verb{oddsratio_to_*()}, \code{OR} input is treated as \code{log(OR)}.
\item In \verb{*_to_oddsratio()}, returned value is \code{log(OR)}.
}
\item \code{FALSE}:
\itemize{
\item In \verb{logoddsratio_to_*()}, \code{logOR} input is treated as \code{OR}.
\item In \verb{*_to_logoddsratio()}, returned value is \code{OR}.
}
}}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to and from other methods.}
}
\value{
Converted index, or if \code{OR}/\code{logOR} is a logistic regression model, a
parameter table with the converted indices.
}
\description{
Convert Between Odds Ratios, Risk Ratios and Other Metrics of Change in Probabilities
}
\examples{
p0 <- 0.4
p1 <- 0.7

(OR <- probs_to_odds(p1) / probs_to_odds(p0))
(RR <- p1 / p0)
(ARR <- p1 - p0)
(NNT <- arr_to_nnt(ARR))

riskratio_to_oddsratio(RR, p0 = p0)
oddsratio_to_riskratio(OR, p0 = p0)
riskratio_to_arr(RR, p0 = p0)
arr_to_oddsratio(nnt_to_arr(NNT), p0 = p0)

m <- glm(am ~ factor(cyl),
  data = mtcars,
  family = binomial()
)
oddsratio_to_riskratio(m, verbose = FALSE) # RR is relative to the intercept if p0 not provided

}
\references{
Grant, R. L. (2014). Converting an odds ratio to a range of plausible
relative risks for better communication of research findings. Bmj, 348,
f7450.
}
\seealso{
\code{\link[=oddsratio]{oddsratio()}}, \code{\link[=riskratio]{riskratio()}}, \code{\link[=arr]{arr()}}, and \code{\link[=nnt]{nnt()}}.

Other convert between effect sizes: 
\code{\link{d_to_r}()},
\code{\link{diff_to_cles}},
\code{\link{eta2_to_f2}()},
\code{\link{odds_to_probs}()},
\code{\link{w_to_fei}()}
}
\concept{convert between effect sizes}
