% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive.R
\name{forecast.rw_model}
\alias{forecast.rw_model}
\alias{rwf}
\alias{naive}
\alias{snaive}
\title{Naive and Random Walk Forecasts}
\usage{
\method{forecast}{rw_model}(
  object,
  h = 10,
  level = c(80, 95),
  fan = FALSE,
  simulate = FALSE,
  bootstrap = FALSE,
  npaths = 5000,
  innov = NULL,
  lambda = object$lambda,
  biasadj = FALSE,
  ...
)

rwf(
  y,
  h = 10,
  drift = FALSE,
  level = c(80, 95),
  fan = FALSE,
  lambda = NULL,
  biasadj = FALSE,
  lag = 1,
  ...,
  x = y
)

naive(
  y,
  h = 10,
  level = c(80, 95),
  fan = FALSE,
  lambda = NULL,
  biasadj = FALSE,
  ...,
  x = y
)

snaive(
  y,
  h = 2 * frequency(x),
  level = c(80, 95),
  fan = FALSE,
  lambda = NULL,
  biasadj = FALSE,
  ...,
  x = y
)
}
\arguments{
\item{object}{An object of class \code{rw_model} returned by \code{\link[=rw_model]{rw_model()}}.}

\item{h}{Number of periods for forecasting. Default value is twice the
largest seasonal period (for seasonal data) or ten (for non-seasonal data).}

\item{level}{Confidence levels for prediction intervals.}

\item{fan}{If \code{TRUE}, \code{level} is set to \code{seq(51, 99, by = 3)}.
This is suitable for fan plots.}

\item{simulate}{If \code{TRUE}, prediction intervals are produced by simulation rather
than using analytic formulae. Errors are assumed to be normally distributed.}

\item{bootstrap}{If \code{TRUE}, then prediction intervals are produced by
simulation using resampled errors (rather than normally distributed errors). Ignored if \code{innov} is not \code{NULL}.}

\item{npaths}{Number of sample paths used in computing simulated prediction
intervals.}

\item{innov}{Optional matrix of future innovations to be used in
simulations. Ignored if \code{simulate = FALSE}. If provided, this overrides the \code{bootstrap} argument. The matrix
should have \code{h} rows and \code{npaths} columns.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{...}{Additional arguments not used.}

\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{drift}{Logical flag. If \code{TRUE}, fits a random walk with drift model.}

\item{lag}{Lag parameter. \code{lag = 1} corresponds to a standard random walk (giving naive forecasts if \code{drift = FALSE} or drift forecasts if \code{drift = TRUE}),
while \code{lag = m} corresponds to a seasonal random walk where m is the seasonal period (giving seasonal naive forecasts if \code{drift = FALSE}).}

\item{x}{Deprecated. Included for backwards compatibility.}
}
\value{
An object of class \code{forecast}.
}
\description{
Returns forecasts and prediction intervals for a generalized random walk model.
\code{\link[=rwf]{rwf()}} is a convenience function that combines \code{\link[=rw_model]{rw_model()}} and \code{\link[=forecast]{forecast()}}.
\code{\link[=naive]{naive()}} is a wrapper to \code{\link[=rwf]{rwf()}} with \code{drift=FALSE} and \code{lag=1}, while
\code{\link[=snaive]{snaive()}} is a wrapper to \code{\link[=rwf]{rwf()}} with \code{drift=FALSE} and \code{lag=frequency(y)}.
}
\details{
The model assumes that

\deqn{Y_t = Y_{t-p} + c + \varepsilon_{t}}{Y[t] = Y[t-p] + epsilon[t]}

where \eqn{p} is the lag parameter,
\eqn{c} is the drift parameter, and
\eqn{\varepsilon_t\sim N(0,\sigma^2)}{Y[t] ~ N(0, sigma^2)} are iid.

The model without drift has \eqn{c=0}.
In the model with drift, \eqn{c} is estimated
by the sample mean of the differences \eqn{Y_t - Y_{t-p}}{Y[t] - Y[t-p]}.

If \eqn{p=1}, this is equivalent to an ARIMA(0,1,0) model with
an optional drift coefficient. For \eqn{p>1}, it is equivalent to an
ARIMA(0,0,0)(0,1,0)p model.

The forecasts are given by

\deqn{Y_{T+h|T}= Y_{T+h-p(k+1)} + ch}{Y[T+h|T] = Y[T+h-p(k+1)]+ch}

where \eqn{k} is the integer part of \eqn{(h-1)/p}.
For a regular random walk, \eqn{p=1} and \eqn{c=0}, so all forecasts are equal to the last observation.
Forecast standard errors allow for uncertainty in estimating the drift parameter
(unlike the corresponding forecasts obtained by fitting an ARIMA model
directly).

The generic accessor functions \code{\link[stats:fitted.values]{stats::fitted()}} and \code{\link[stats:residuals]{stats::residuals()}}
extract useful features of the object returned.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{
# Three ways to do the same thing
gold_model <- rw_model(gold)
gold_fc1 <- forecast(gold_model, h = 50)
gold_fc2 <- rwf(gold, h = 50)
gold_fc3 <- naive(gold, h = 50)

# Plot the forecasts
autoplot(gold_fc1)

# Drift forecasts
rwf(gold, drift = TRUE) |> autoplot()

# Seasonal naive forecasts
snaive(wineind) |> autoplot()
}
\seealso{
\code{\link[=rw_model]{rw_model()}}, \code{\link[=Arima]{Arima()}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
