% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp-headers.R
\name{resp_headers}
\alias{resp_headers}
\alias{resp_header}
\alias{resp_header_exists}
\title{Extract headers from a response}
\usage{
resp_headers(resp, filter = NULL)

resp_header(resp, header, default = NULL)

resp_header_exists(resp, header)
}
\arguments{
\item{resp}{An HTTP response object, as created by \code{\link[=req_perform]{req_perform()}}.}

\item{filter}{A regular expression used to filter the header names.
\code{NULL}, the default, returns all headers.}

\item{header}{Header name (case insensitive)}

\item{default}{Default value to use if header doesn't exist.}
}
\value{
\itemize{
\item \code{resp_headers()} returns a list.
\item \code{resp_header()} returns a string if the header exists and \code{NULL} otherwise.
\item \code{resp_header_exists()} returns \code{TRUE} or \code{FALSE}.
}
}
\description{
\itemize{
\item \code{resp_headers()} retrieves a list of all headers.
\item \code{resp_header()} retrieves a single header.
\item \code{resp_header_exists()} checks if a header is present.
}
}
\examples{
resp <- request("https://httr2.r-lib.org") |> req_perform()
resp |> resp_headers()
resp |> resp_headers("x-")

resp |> resp_header_exists("server")
resp |> resp_header("server")
# Headers are case insensitive
resp |> resp_header("SERVER")

# Returns NULL if header doesn't exist
resp |> resp_header("this-header-doesnt-exist")
}
