/*  -- translated by f2c (version 20191129).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* > \brief \b DGER   

    =========== DOCUMENTATION ===========   

   Online html documentation available at   
              http://www.netlib.org/lapack/explore-html/   

    Definition:   
    ===========   

         SUBROUTINE DGER(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)   

         DOUBLE PRECISION ALPHA   
         INTEGER INCX,INCY,LDA,M,N   
         DOUBLE PRECISION A(LDA,*),X(*),Y(*)   


   > \par Purpose:   
    =============   
   >   
   > \verbatim   
   >   
   > DGER   performs the rank 1 operation   
   >   
   >    A := alpha*x*y**T + A,   
   >   
   > where alpha is a scalar, x is an m element vector, y is an n element   
   > vector and A is an m by n matrix.   
   > \endverbatim   

    Arguments:   
    ==========   

   > \param[in] M   
   > \verbatim   
   >          M is INTEGER   
   >           On entry, M specifies the number of rows of the matrix A.   
   >           M must be at least zero.   
   > \endverbatim   
   >   
   > \param[in] N   
   > \verbatim   
   >          N is INTEGER   
   >           On entry, N specifies the number of columns of the matrix A.   
   >           N must be at least zero.   
   > \endverbatim   
   >   
   > \param[in] ALPHA   
   > \verbatim   
   >          ALPHA is DOUBLE PRECISION.   
   >           On entry, ALPHA specifies the scalar alpha.   
   > \endverbatim   
   >   
   > \param[in] X   
   > \verbatim   
   >          X is DOUBLE PRECISION array, dimension at least   
   >           ( 1 + ( m - 1 )*abs( INCX ) ).   
   >           Before entry, the incremented array X must contain the m   
   >           element vector x.   
   > \endverbatim   
   >   
   > \param[in] INCX   
   > \verbatim   
   >          INCX is INTEGER   
   >           On entry, INCX specifies the increment for the elements of   
   >           X. INCX must not be zero.   
   > \endverbatim   
   >   
   > \param[in] Y   
   > \verbatim   
   >          Y is DOUBLE PRECISION array, dimension at least   
   >           ( 1 + ( n - 1 )*abs( INCY ) ).   
   >           Before entry, the incremented array Y must contain the n   
   >           element vector y.   
   > \endverbatim   
   >   
   > \param[in] INCY   
   > \verbatim   
   >          INCY is INTEGER   
   >           On entry, INCY specifies the increment for the elements of   
   >           Y. INCY must not be zero.   
   > \endverbatim   
   >   
   > \param[in,out] A   
   > \verbatim   
   >          A is DOUBLE PRECISION array, dimension ( LDA, N )   
   >           Before entry, the leading m by n part of the array A must   
   >           contain the matrix of coefficients. On exit, A is   
   >           overwritten by the updated matrix.   
   > \endverbatim   
   >   
   > \param[in] LDA   
   > \verbatim   
   >          LDA is INTEGER   
   >           On entry, LDA specifies the first dimension of A as declared   
   >           in the calling (sub) program. LDA must be at least   
   >           max( 1, m ).   
   > \endverbatim   

    Authors:   
    ========   

   > \author Univ. of Tennessee   
   > \author Univ. of California Berkeley   
   > \author Univ. of Colorado Denver   
   > \author NAG Ltd.   

   > \date December 2016   

   > \ingroup double_blas_level2   

   > \par Further Details:   
    =====================   
   >   
   > \verbatim   
   >   
   >  Level 2 Blas routine.   
   >   
   >  -- Written on 22-October-1986.   
   >     Jack Dongarra, Argonne National Lab.   
   >     Jeremy Du Croz, Nag Central Office.   
   >     Sven Hammarling, Nag Central Office.   
   >     Richard Hanson, Sandia National Labs.   
   > \endverbatim   
   >   
    =====================================================================   
   Subroutine */ int igraphdger_(integer *m, integer *n, doublereal *alpha, 
	doublereal *x, integer *incx, doublereal *y, integer *incy, 
	doublereal *a, integer *lda)
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2;

    /* Local variables */
    integer i__, j, ix, jy, kx, info;
    doublereal temp;
    extern /* Subroutine */ int igraphxerbla_(char *, integer *, ftnlen);


/*  -- Reference BLAS level2 routine (version 3.7.0) --   
    -- Reference BLAS is a software package provided by Univ. of Tennessee,    --   
    -- Univ. of California Berkeley, Univ. of Colorado Denver and NAG Ltd..--   
       December 2016   


    =====================================================================   


       Test the input parameters.   

       Parameter adjustments */
    --x;
    --y;
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;

    /* Function Body */
    info = 0;
    if (*m < 0) {
	info = 1;
    } else if (*n < 0) {
	info = 2;
    } else if (*incx == 0) {
	info = 5;
    } else if (*incy == 0) {
	info = 7;
    } else if (*lda < max(1,*m)) {
	info = 9;
    }
    if (info != 0) {
	igraphxerbla_("DGER  ", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*m == 0 || *n == 0 || *alpha == 0.) {
	return 0;
    }

/*     Start the operations. In this version the elements of A are   
       accessed sequentially with one pass through A. */

    if (*incy > 0) {
	jy = 1;
    } else {
	jy = 1 - (*n - 1) * *incy;
    }
    if (*incx == 1) {
	i__1 = *n;
	for (j = 1; j <= i__1; ++j) {
	    if (y[jy] != 0.) {
		temp = *alpha * y[jy];
		i__2 = *m;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    a[i__ + j * a_dim1] += x[i__] * temp;
/* L10: */
		}
	    }
	    jy += *incy;
/* L20: */
	}
    } else {
	if (*incx > 0) {
	    kx = 1;
	} else {
	    kx = 1 - (*m - 1) * *incx;
	}
	i__1 = *n;
	for (j = 1; j <= i__1; ++j) {
	    if (y[jy] != 0.) {
		temp = *alpha * y[jy];
		ix = kx;
		i__2 = *m;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    a[i__ + j * a_dim1] += x[ix] * temp;
		    ix += *incx;
/* L30: */
		}
	    }
	    jy += *incy;
/* L40: */
	}
    }

    return 0;

/*     End of DGER  . */

} /* igraphdger_ */

