% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{formatter_json}
\alias{formatter_json}
\title{Transforms all passed R objects into a JSON list}
\usage{
formatter_json(
  ...,
  .logcall = sys.call(),
  .topcall = sys.call(-1),
  .topenv = parent.frame()
)
}
\arguments{
\item{...}{passed to \code{toJSON} wrapped into a \code{list}}

\item{.logcall}{the logging call being evaluated (useful in formatters and layouts when you want to have access to the raw, unevaluated R expression)}

\item{.topcall}{R expression from which the logging function was called (useful in formatters and layouts to extract the calling function's name or arguments)}

\item{.topenv}{original frame of the \code{.topcall} calling function where the formatter function will be evaluated and that is used to look up the \code{namespace} as well via \code{logger:::top_env_name}}
}
\value{
character vector
}
\description{
Transforms all passed R objects into a JSON list
}
\note{
This functionality depends on the \pkg{jsonlite} package.
}
\examples{
\dontrun{
log_formatter(formatter_json)
log_layout(layout_json_parser())
log_info(everything = 42)
log_info(mtcars = mtcars, species = iris$Species)
}
}
\seealso{
This is a \code{\link{log_formatter}} potentially to be used with \code{\link{layout_json_parser}}, for alternatives, see \code{\link{formatter_paste}}, \code{\link{formatter_sprintf}}, \code{\link{formatter_glue}}, \code{\link{formatter_glue_safe}}, \code{\link{formatter_glue_or_sprintf}}, \code{\link{formatter_logging}}, \code{\link{formatter_pander}} and \code{\link{skip_formatter}} for marking a string not to apply the formatter on it.
}
