% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.norm.nob.R
\name{mice.impute.norm.nob}
\alias{mice.impute.norm.nob}
\alias{norm.nob}
\title{Imputation by linear regression without parameter uncertainty}
\usage{
mice.impute.norm.nob(y, ry, x, wy = NULL, ...)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the
the subset \code{y[ry]} of elements in \code{y} to which the imputation
model is fitted. The \code{ry} generally distinguishes the observed
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value
indicates locations in \code{y} for which imputations are created.}

\item{...}{Other named arguments.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length
\code{sum(wy)}
}
\description{
Imputes univariate missing data using linear regression analysis without
accounting for the uncertainty of the model parameters.
}
\details{
This function creates imputations using the spread around the
fitted linear regression line of \code{y} given \code{x}, as
fitted on the observed data.

This function is provided mainly to allow comparison between proper (e.g.,
as implemented in \code{mice.impute.norm} and improper (this function)
normal imputation methods.

For large data, having many rows, differences between proper and improper
methods are small, and in those cases one may opt for speed by using
\code{mice.impute.norm.nob}.
}
\section{Warning}{
 The function does not incorporate the variability of the
regression weights, so it is not 'proper' in the sense of Rubin. For small
samples, variability of the imputed data is therefore underestimated.
}

\references{
Van Buuren, S., Groothuis-Oudshoorn, K. (2011). \code{mice}:
Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1-67.
\doi{10.18637/jss.v045.i03}

Brand, J.P.L. (1999). Development, Implementation and Evaluation of Multiple
Imputation Strategies for the Statistical Analysis of Incomplete Data Sets.
Ph.D. Thesis, TNO Prevention and Health/Erasmus University Rotterdam.
}
\seealso{
\code{\link{mice}}, \code{\link{mice.impute.norm}}

Other univariate imputation functions: 
\code{\link{mice.impute.cart}()},
\code{\link{mice.impute.lasso.logreg}()},
\code{\link{mice.impute.lasso.norm}()},
\code{\link{mice.impute.lasso.select.logreg}()},
\code{\link{mice.impute.lasso.select.norm}()},
\code{\link{mice.impute.lda}()},
\code{\link{mice.impute.logreg.boot}()},
\code{\link{mice.impute.logreg}()},
\code{\link{mice.impute.mean}()},
\code{\link{mice.impute.midastouch}()},
\code{\link{mice.impute.mnar.logreg}()},
\code{\link{mice.impute.norm.boot}()},
\code{\link{mice.impute.norm.predict}()},
\code{\link{mice.impute.norm}()},
\code{\link{mice.impute.pmm}()},
\code{\link{mice.impute.polr}()},
\code{\link{mice.impute.polyreg}()},
\code{\link{mice.impute.quadratic}()},
\code{\link{mice.impute.rf}()},
\code{\link{mice.impute.ri}()}
}
\author{
Gerko Vink, Stef van Buuren, Karin Groothuis-Oudshoorn, 2018
}
\concept{univariate imputation functions}
\keyword{datagen}
