% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mykey.R
\name{my_key}
\alias{my_key}
\alias{my_pubkey}
\title{Default keypair}
\usage{
my_key()

my_pubkey()
}
\description{
Set a default keypair via \code{USER_KEY} and \code{USER_PUKBEY} variables.
}
\details{
The \code{my_key()} function checks environment variable \code{USER_KEY} for a
path to a private keyfile. If unset it defaults to \code{"~/.ssh/id_rsa"}.

The \code{my_pubkey()} function first tries \code{USER_PUBKEY} and if unset
it checks for \code{USER_KEY} to derive the corresponding pubkey. If both are
unset it defaults to \code{"~/.ssh/id_rsa.pub"}.
}
\examples{
# Set random RSA key as default
key <- rsa_keygen()
write_pem(key, tmp <- tempfile(), password = "")
rm(key)
Sys.setenv("USER_KEY" = tmp)

# Check the new keys
print(my_key())
print(my_pubkey())
}
