% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAT_modcomp.R
\name{sat_modcomp}
\alias{sat_modcomp}
\alias{SATmodcomp}
\alias{SATmodcomp.lmerMod}
\title{F-test and degrees of freedom based on Satterthwaite approximation}
\usage{
SATmodcomp(
  largeModel,
  smallModel,
  betaH = 0,
  details = 0,
  eps = sqrt(.Machine$double.eps)
)

\method{SATmodcomp}{lmerMod}(
  largeModel,
  smallModel,
  betaH = 0,
  details = 0,
  eps = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{largeModel}{An \code{lmer} model}

\item{smallModel}{An \code{lmer} model or a restriction matrix}

\item{betaH}{A number or a vector of the beta of the hypothesis,
e.g. L beta=L betaH. If \code{smallModel} is a model object then betaH=0.}

\item{details}{If larger than 0 some timing details are printed.}

\item{eps}{A small number.}
}
\description{
An approximate F-test based on the Satterthwaite approach.
}
\details{
Notice: It cannot be guaranteed that the results agree with other
implementations of the Satterthwaite approach!
}
\examples{

(fm0 <- lmer(Reaction ~ (Days|Subject), sleepstudy))
(fm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))
(fm2 <- lmer(Reaction ~ Days + I(Days^2) + (Days|Subject), sleepstudy))

## Test for no effect of Days in fm1, i.e. test fm0 under fm1
SATmodcomp(fm1, "Days")
SATmodcomp(fm1, ~.-Days)
L1 <- cbind(0, 1) 
SATmodcomp(fm1, L1)
SATmodcomp(fm1, fm0)
anova(fm1, fm0)

## Test for no effect of Days and Days-squared in fm2, i.e. test fm0 under fm2
SATmodcomp(fm2, "(Days+I(Days^2))")
SATmodcomp(fm2, ~. - Days - I(Days^2))
L2 <- rbind(c(0, 1, 0), c(0, 0, 1))
SATmodcomp(fm2, L2)
SATmodcomp(fm2, fm0)
anova(fm2, fm0)

## Test for no effect of Days-squared in fm2, i.e. test fm1 under fm2
SATmodcomp(fm2, "I(Days^2)")
SATmodcomp(fm2, ~. - I(Days^2))
L3 <- rbind(c(0, 0, 1))
SATmodcomp(fm2, L3)
SATmodcomp(fm2, fm1)
anova(fm2, fm1)
}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A
Kenward-Roger Approximation and Parametric Bootstrap Methods
for Tests in Linear Mixed Models - The R Package pbkrtest.,
Journal of Statistical Software, 58(10), 1-30.,
\url{https://www.jstatsoft.org/v59/i09/}
}
\seealso{
\code{\link{getKR}}, \code{\link[lme4]{lmer}}, \code{\link{vcovAdj}},
\code{\link{PBmodcomp}}, \code{\link{KRmodcomp}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\concept{model_comparison}
\keyword{inference}
\keyword{models}
