% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_mckelvey.R
\name{r2_mckelvey}
\alias{r2_mckelvey}
\title{McKelvey & Zavoinas R2}
\usage{
r2_mckelvey(model)
}
\arguments{
\item{model}{Generalized linear model.}
}
\value{
The R2 value.
}
\description{
Calculates McKelvey & Zavoinas pseudo R2.
}
\details{
McKelvey & Zavoinas R2 is based on the explained variance,
where the variance of the predicted response is divided by the sum
of the variance of the predicted response and residual variance.
For binomial models, the residual variance is either \code{pi^2/3}
for logit-link and 1 for probit-link. For poisson-models, the
residual variance is based on log-normal approximation, similar to
the \emph{distribution-specific variance} as described in
\code{?insight::get_variance}.
}
\examples{
## Dobson (1990) Page 93: Randomized Controlled Trial:
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12) #
outcome <- gl(3, 1, 9)
treatment <- gl(3, 3)
model <- glm(counts ~ outcome + treatment, family = poisson())

r2_mckelvey(model)
}
\references{
\itemize{
\item McKelvey, R., Zavoina, W. (1975), "A Statistical Model for the Analysis of Ordinal Level Dependent Variables", Journal of Mathematical Sociology 4, S. 103–120.
}
}
