% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.prodlim.R
\name{summary.prodlim}
\alias{summary.prodlim}
\title{Summary method for prodlim objects.}
\usage{
\method{summary}{prodlim}(
  object,
  times,
  newdata,
  max.tables = 20,
  surv = TRUE,
  cause,
  intervals = FALSE,
  percent = FALSE,
  format = "df",
  ...
)
}
\arguments{
\item{object}{An object with class `prodlim' derived with
\code{\link{prodlim}}}

\item{times}{Vector of times at which to return the estimated
probabilities.}

\item{newdata}{A data frame with the same variable names as those
that appear on the right hand side of the 'prodlim' formula.
Defaults to \code{object$X}.}

\item{max.tables}{Integer. If \code{newdata} is not given the value
of \code{max.tables} decides about the maximal number of tables to
be shown.  Defaults to 20.}

\item{surv}{Logical. If FALSE report event probabilities instead of
survival probabilities. Only available for
\code{object$model=="survival"}.}

\item{cause}{For competing risk models. The event of interest for which predictions of the absolute risks are obtained by evaluating the cause-specific cumulative
incidence functions at  \code{times}.}

\item{intervals}{Logical. If TRUE count events and censored in
intervals between the values of \code{times}.}

\item{percent}{Logical. If TRUE all estimated values are multiplied
by 100 and thus interpretable on a percent scale.}

\item{format}{Control format of output. Since May 2021,
the result is a data.table and data.frame with attributes. When there are multiple
covariate strata or competing risks, these are indicated by columns.
Set format to \code{"list"} to get the old behaviour.}

\item{...}{Further arguments that are passed to the print
function.}
}
\value{
A data.frame with the relevant information.
}
\description{
Summarizing the result of the product limit method in life-table format.
Calculates the number of subjects at risk and counts events and censored
observations at specified times or in specified time intervals.
}
\details{
For cluster-correlated data the number of clusters at-risk are are also
given. Confidence intervals are displayed when they are part of the fitted
object.
}
\examples{

library(lava)
set.seed(17)
m <- survModel()
distribution(m,~age) <- uniform.lvm(30,80)
distribution(m,~sex) <- binomial.lvm()
m <- categorical(m,~z,K=3)
regression(m,eventtime~age) <- 0.01
regression(m,eventtime~sex) <- -0.4
d <- sim(m,50)
d$sex <- factor(d$sex,levels=c(0,1),labels=c("female","male"))
d$Z <- factor(d$z,levels=c(1,0,2),labels=c("B","A","C"))

# Univariate Kaplan-Meier
# -----------------------------------------------------------------------------------------
fit0 <- prodlim(Hist(time,event)~1,data=d)
summary(fit0)

## show survival probabilities as percentage and
## count number of events within intervals of a
## given time-grid:
summary(fit0,times=c(1,5,10,12),percent=TRUE,intervals=TRUE)

## the result of summary has a print function
## which passes ... to print and print.listof
sx <- summary(fit0,times=c(1,5,10,12),percent=TRUE,intervals=TRUE)
print(sx,digits=3)

## show absolute risks, i.e., cumulative incidences (1-survival)
summary(fit0,times=c(1,5,10,12),surv=FALSE,percent=TRUE,intervals=TRUE)

# Stratified Kaplan-Meier
# -----------------------------------------------------------------------------------------

fit1 <- prodlim(Hist(time,event)~sex,data=d)
print(summary(fit1,times=c(1,5,10),intervals=TRUE,percent=TRUE),digits=3)
# old behaviour
print(summary(fit1,times=c(1,5,10),intervals=TRUE,percent=TRUE,format="list"),digits=3)

summary(fit1,times=c(1,5,10),intervals=TRUE,percent=TRUE)

fit2 <- prodlim(Hist(time,event)~Z,data=d)
print(summary(fit2,times=c(1,5,10),intervals=TRUE,percent=TRUE),digits=3)

## Continuous strata (Beran estimator)
# -----------------------------------------------------------------------------------------
fit3 <- prodlim(Hist(time,event)~age,data=d)
print(summary(fit3,
              times=c(1,5,10),
              newdata=data.frame(age=c(20,50,70)),
              intervals=TRUE,
              percent=TRUE),digits=3)

## stratified Beran estimator
# -----------------------------------------------------------------------------------------
fit4 <- prodlim(Hist(time,event)~age+sex,data=d)
print(summary(fit4,
              times=c(1,5,10),
              newdata=data.frame(age=c(20,50,70),sex=c("female","male","male")),
              intervals=TRUE,
              percent=TRUE),digits=3)

print(summary(fit4,
              times=c(1,5,10),
              newdata=data.frame(age=c(20,50,70),sex=c("female","male","male")),
              intervals=TRUE,
              percent=TRUE),digits=3)

## assess results from summary
x <- summary(fit4,times=10,newdata=expand.grid(age=c(60,40,50),sex=c("male","female")))
cbind(names(x$table),do.call("rbind",lapply(x$table,round,2)))

x <- summary(fit4,times=10,newdata=expand.grid(age=c(60,40,50),sex=c("male","female")))

## Competing risks: Aalen-Johansen
# -----------------------------------------------------------------------------------------
d <- SimCompRisk(30)
crfit <- prodlim(Hist(time,event)~X1,data=d)
summary(crfit,times=c(1,2,5))
summary(crfit,times=c(1,2,5),cause=1,intervals=TRUE)
summary(crfit,times=c(1,2,5),cause=1)
summary(crfit,times=c(1,2,5),cause=1:2)


# extract the actual tables from the summary 
sumfit <- summary(crfit,times=c(1,2,5),print=FALSE)
sumfit$table[[1]] # cause 1
sumfit$table[[2]] # cause 2


# '
}
\seealso{
\code{\link{prodlim}}, \code{\link{summary.Hist}}
}
\author{
Thomas A. Gerds \email{tag@biostat.ku.dk}
}
\keyword{survival}
