% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call2}
\alias{call2}
\title{Create a call}
\usage{
call2(.fn, ..., .ns = NULL)
}
\arguments{
\item{.fn}{Function to call. Must be a callable object: a string,
symbol, call, or a function.}

\item{...}{Arguments to the call either in or out of a list. These dots
support \link[=tidy-dots]{tidy dots} features.}

\item{.ns}{Namespace with which to prefix \code{.fn}. Must be a string
or symbol.}
}
\description{
Language objects are (with symbols) one of the two types of
\link[=is_symbolic]{symbolic} objects in R. These symbolic objects form
the backbone of \link[=is_expression]{expressions}. They represent a value,
unlike literal objects which are their own values. While symbols
are directly \link[=env_bind]{bound} to a value, language objects
represent \emph{function calls}, which is why they are commonly referred
to as calls.

\code{call2()} creates a call from a function name (or a literal
function to inline in the call) and a list of arguments.
}
\section{Life cycle}{


In rlang 0.2.0 \code{lang()} was soft-deprecated and renamed to
\code{call2()}.

In early versions of rlang calls were called "language" objects in
order to follow the R type nomenclature as returned by
\code{\link[base:typeof]{base::typeof()}}. The goal was to avoid adding to the confusion
between S modes and R types. With hindsight we find it is better to
use more meaningful type names.
}

\examples{
# fn can either be a string, a symbol or a call
call2("f", a = 1)
call2(quote(f), a = 1)
call2(quote(f()), a = 1)

#' Can supply arguments individually or in a list
call2(quote(f), a = 1, b = 2)
call2(quote(f), splice(list(a = 1, b = 2)))

# Creating namespaced calls:
call2("fun", arg = quote(baz), .ns = "mypkg")
}
\seealso{
call_modify
}
