% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot-wide.R
\name{pivot_wider_spec}
\alias{pivot_wider_spec}
\alias{build_wider_spec}
\title{Pivot data from long to wide using a spec}
\usage{
pivot_wider_spec(
  data,
  spec,
  names_repair = "check_unique",
  id_cols = NULL,
  values_fill = NULL,
  values_fn = NULL
)

build_wider_spec(
  data,
  names_from = name,
  values_from = value,
  names_prefix = "",
  names_sep = "_"
)
}
\arguments{
\item{data}{A data frame to pivot.}

\item{names_repair}{What happen if the output has invalid column names?
The default, \code{"check_unique"} is to error if the columns are duplicated.
Use \code{"minimal"} to allow duplicates in the output, or \code{"unique"} to
de-duplicated by adding numeric suffixes. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}
for more options.}

\item{id_cols}{A set of columns that uniquely identifies each observation.
Defaults to all columns in \code{data} except for the columns specified in
\code{names_from} and \code{values_from}. Typically used when you have additional
variables that is directly related.}

\item{values_fill}{Optionally, a named list specifying what each \code{value}
should be filled in with when missing.}

\item{values_fn}{Optionally, a named list providing a function that will be
applied to the \code{value} in each cell in the output. You will typically
use this when the combination of \code{id_cols} and \code{value} column does not
uniquely identify an observation.}

\item{names_from}{A pair of arguments describing which column
(or columns) to get the name of the output column (\code{name_from}), and
which column (or columns) to get the cell values from (\code{values_from}).

If \code{values_from} contains multiple values, the value will be added to the
front of the output column.}

\item{values_from}{A pair of arguments describing which column
(or columns) to get the name of the output column (\code{name_from}), and
which column (or columns) to get the cell values from (\code{values_from}).

If \code{values_from} contains multiple values, the value will be added to the
front of the output column.}

\item{names_prefix}{String added to the start of every variable name. This is
particularly useful if \code{names_from} is a numeric vector and you want to
create syntactic variable names.}

\item{names_sep}{If \code{names_from} or \code{values_from} contains multiple
variables, this will be used to join their values together into a single
string to use as a column name.}
}
\description{
This is a low level interface to pivotting, inspired by the cdata package,
that allows you to describe pivotting with a data frame.
}
\keyword{internal}
