% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{ignore}
\alias{ignore}
\title{Ignore the output of an expectation}
\usage{
ignore(fun)
}
\arguments{
\item{fun}{\code{[function]} An \code{expect_} function}
}
\value{
An ignored \code{function}
}
\description{
Ignored expectations are not reported in the test results.
Ignoring is only useful for test files, and not for use directly
at the command-line. See also the package vignette: \code{vignette("using_tinytest")}.
}
\section{Details}{


\code{ignore} is a higher-order function: a function that returns another function.
In particular, it accepts a function and returns a function that is almost identical
to the input function. The only difference is that the return value of the function
returned by \code{ignore} is not caught by \code{\link{run_test_file}} and friends. 
For example, \code{ignore(expect_true)} is a function, and we can use it as 
\code{ignore(expect_true)( 1 == 1)}. The return value of \code{ignore(expect_true)(1==1)}
is exactly the same as that for \code{expect_true(1==1)}.
}

\examples{
\donttest{
   ## The result of 'expect_warning' is not stored in the test result when
   ## this is run from a file.
   expect_true( ignore(expect_warning)(warning("foo!")) )
   ## Note the placement of the brackets in ignore(expect_warning)(...).
 }


}
\seealso{
Other test-functions: 
\code{\link{expect_equal_to_reference}()},
\code{\link{expect_equal}()}
}
\concept{test-functions}
