// https://www.st.com/resource/en/programming_manual/pm0044-stm8-cpu-programming-manual-stmicroelectronics.pdf

typedef enum {
	STM8_NONE = 0,
	STM8_REG_A, STM8_REG_XL, STM8_REG_YL, STM8_REG_XH, STM8_REG_YH, STM8_REG_CC, STM8_REG_X, STM8_REG_Y, STM8_REG_SP,
	STM8_PTR_X, STM8_PTR_Y,
	STM8_IMM_BYTE_2, STM8_IMM_WORD_23,
	SHORTMEM_2, SHORTMEM_3, LONGMEM_23, LONGMEM_34, LONGMEM_45, EXTMEM_234,
	SHORTOFF_2, SHORTOFF_4,
	SHORTOFF_X_2, SHORTOFF_Y_2, SHORTOFF_SP_2,
	LONGOFF_X_23, LONGOFF_Y_23,
	EXTOFF_X_234, EXTOFF_Y_234,
	SHORTPTR_2, LONGPTR_23,
	SHORTPTR_OFF_X_2, SHORTPTR_OFF_Y_2,
	LONGPTR_OFF_X_23, LONGPTR_OFF_Y_23,
	LONGMEM_BIT_123
} Ins_Operand;

typedef struct {
	char     text[8];
	uint8_t  des;
	uint8_t  src;
	uint16_t size;
	int type;
	const char *esil;
} instruction;

static const instruction ins_table[] = {
	{ "neg", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_NOT },
	{ "rrwa", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_ROR },
	{ "rlwa", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_ROL },
	{ "cpl", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "sra", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_SHR },
	{ "void", 0, 0, 0 },
	{ "rrc", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_ROR },
	{ "sra", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_SHR },
	{ "sll", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_SHL },
	{ "rlc", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_ROL },
	{ "dec", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_ADD },
	{ "tnz", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "swap", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_MOV },
	{ "clr", SHORTOFF_SP_2, 0, 2, R_ANAL_OP_TYPE_MOV },
	{ "sub", STM8_REG_A, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "ldw", STM8_REG_Y, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTOFF_SP_2, STM8_REG_Y, 2, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, SHORTOFF_SP_2, 2 },
	{ "add", STM8_REG_A, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_ADD },
	{ "addw", STM8_REG_X, STM8_IMM_WORD_23, 3, R_ANAL_OP_TYPE_ADD },
	{ "subw", STM8_REG_X, STM8_IMM_WORD_23, 3, R_ANAL_OP_TYPE_SUB },
	{ "ldw", STM8_REG_X, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTOFF_SP_2, STM8_REG_X, 2, R_ANAL_OP_TYPE_LOAD },
	{ "jra", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_JMP },
	{ "jrf", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrugt", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrule", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrnc", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrc", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrne", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jreq", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrnv", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrv", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrpl", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrmi", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrsgt", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrsle", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrsge", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "jrslt", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_CJMP },
	{ "neg", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_NOT },
	{ "exg", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_MOV },
	{ "pop", LONGMEM_23, 0, 3, R_ANAL_OP_TYPE_POP },
	{ "cpl", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "sra", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_SAR },
	{ "mov", LONGMEM_34, STM8_IMM_BYTE_2, 4, R_ANAL_OP_TYPE_MOV },
	{ "rrc", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_ROR },
	{ "sra", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_SAR },
	{ "sll", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_SAL },
	{ "rlc", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_ROL },
	{ "dec", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_SUB },
	{ "push", LONGMEM_23, 0, 3, R_ANAL_OP_TYPE_PUSH },
	{ "inc", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_ADD },
	{ "tnz", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "swap", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_MOV },
	{ "clr", SHORTMEM_2, 0, 2, R_ANAL_OP_TYPE_MOV, "0,%s,:=" },
	{ "neg", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_NOT },
	{ "exg", STM8_REG_A, STM8_REG_XL, 1, R_ANAL_OP_TYPE_MOV },
	{ "mul", STM8_REG_X, STM8_REG_A, 1, R_ANAL_OP_TYPE_MUL },
	{ "cpl", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_CMP },
	{ "sra", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_SAR },
	{ "mov", SHORTMEM_3, SHORTMEM_2, 3, R_ANAL_OP_TYPE_MOV },
	{ "rrc", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_ROR },
	{ "sra", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_SAR },
	{ "sll", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_SHL },
	{ "rlc", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_ROL },
	{ "dec", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_SUB },
	{ "push", STM8_IMM_BYTE_2, 0, 2, R_ANAL_OP_TYPE_PUSH },
	{ "inc", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_ADD },
	{ "tnz", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_CMP },
	{ "swap", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "clr", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "negw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_NOT },
	{ "exgw", STM8_REG_X, STM8_REG_Y, 1, R_ANAL_OP_TYPE_MOV },
	{ "sub", STM8_REG_SP, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_SUB },
	{ "cplw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_CMP },
	{ "srlw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_SHR },
	{ "mov", LONGMEM_45, LONGMEM_23, 5, R_ANAL_OP_TYPE_MOV },
	{ "rrcw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_ROR },
	{ "sraw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_SAR },
	{ "sllw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_SHL },
	{ "rlcw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_ROL },
	{ "decw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_SUB },
	{ "add", STM8_REG_SP, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_ADD },
	{ "incw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_ADD },
	{ "tnzw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_CMP },
	{ "swapw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "clrw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "neg", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_NOT },
	{ "exg", STM8_REG_A, STM8_REG_YL, 1, R_ANAL_OP_TYPE_MOV },
	{ "div", STM8_REG_X, STM8_REG_A, 1, R_ANAL_OP_TYPE_DIV },
	{ "cpl", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "sra", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_SHR },
	{ "divw", STM8_REG_X, STM8_REG_Y, 1, R_ANAL_OP_TYPE_DIV },
	{ "rrc", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_ROR },
	{ "sra", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_SAR },
	{ "sll", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_SHL },
	{ "rlc", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_ROL },
	{ "dec", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_SUB },
	{ "ld", SHORTOFF_SP_2, STM8_REG_A, 2, R_ANAL_OP_TYPE_LOAD },
	{ "inc", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_ADD },
	{ "tnz", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "swap", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_MOV },
	{ "clr", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_MOV },
	{ "neg", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpl", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_CMP },
	{ "sra", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_SAR },
	{ "void", 0, 0, 0 },
	{ "rrc", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_ROR },
	{ "sra", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_SHR },
	{ "sll", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_SHL },
	{ "rlc", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_ROL },
	{ "dec", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_SUB },
	{ "ld", STM8_REG_A, SHORTOFF_SP_2, 2, R_ANAL_OP_TYPE_LOAD },
	{ "inc", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_ADD },
	{ "tnz", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_CMP },
	{ "swap", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "clr", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "iret", 0, 0, 1, R_ANAL_OP_TYPE_RET },
	{ "ret", 0, 0, 1, R_ANAL_OP_TYPE_RET },
	{ "int", EXTMEM_234, 0, 4, R_ANAL_OP_TYPE_SWI },
	{ "trap", 0, 0, 1, R_ANAL_OP_TYPE_TRAP },
	{ "pop", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_POP },
	{ "popw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_POP },
	{ "pop", STM8_REG_CC, 0, 1, R_ANAL_OP_TYPE_POP },
	{ "retf", 0, 0, 1, R_ANAL_OP_TYPE_RET },
	{ "push", STM8_REG_A, 0, 1, R_ANAL_OP_TYPE_PUSH },
	{ "pushw", STM8_REG_X, 0, 1, R_ANAL_OP_TYPE_PUSH },
	{ "push", STM8_REG_CC, 0, 1, R_ANAL_OP_TYPE_PUSH },
	{ "break", 0, 0, 1, R_ANAL_OP_TYPE_TRAP },
	{ "ccf", 0, 0, 1, R_ANAL_OP_TYPE_CPL },
	{ "callf", EXTMEM_234, 0, 4, R_ANAL_OP_TYPE_CALL },
	{ "halt", 0, 0, 1, R_ANAL_OP_TYPE_SYNC },
	{ "wfi", 0, 0, 1, R_ANAL_OP_TYPE_SYNC },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldw", STM8_REG_X, STM8_REG_Y, 1, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", STM8_REG_SP, STM8_REG_X, 1, R_ANAL_OP_TYPE_LOAD },
	{ "ld", STM8_REG_XH, STM8_REG_A, 1, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", STM8_REG_X, STM8_REG_SP, 1, R_ANAL_OP_TYPE_LOAD },
	{ "ld", STM8_REG_XL, STM8_REG_A, 1, R_ANAL_OP_TYPE_LOAD },
	{ "rcf", 0, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "scf", 0, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "rim", 0, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "sim", 0, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "rvf", 0, 0, 1, R_ANAL_OP_TYPE_MOV },
	{ "nop", 0, 0, 1, R_ANAL_OP_TYPE_NOP },
	{ "ld", STM8_REG_A, STM8_REG_XH, 1, R_ANAL_OP_TYPE_LOAD },
	{ "ld", STM8_REG_A, STM8_REG_XL, 1, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, STM8_IMM_WORD_23, 3, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ldf", EXTOFF_X_234, STM8_REG_A, 4, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, STM8_IMM_BYTE_2, 2, R_ANAL_OP_TYPE_ADD },
	{ "jpf", EXTMEM_234, 0, 4, R_ANAL_OP_TYPE_JMP },
	{ "callr", SHORTOFF_2, 0, 2, R_ANAL_OP_TYPE_RCALL },
	{ "ldw", STM8_REG_X, STM8_IMM_WORD_23, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ldf", STM8_REG_A, EXTOFF_X_234, 4, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, SHORTMEM_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ld", SHORTMEM_2, STM8_REG_A, 2, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, SHORTMEM_2, 2, R_ANAL_OP_TYPE_ADD },
	{ "ldf", STM8_REG_A, EXTMEM_234, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ldf", EXTMEM_234, STM8_REG_A, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", STM8_REG_X, SHORTMEM_2, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTMEM_2, STM8_REG_X, 2, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, LONGMEM_23, 3, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ld", LONGMEM_23, STM8_REG_A, 3, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, LONGMEM_23, 3, R_ANAL_OP_TYPE_ADD },
	{ "jp", LONGMEM_23, 0, 3, R_ANAL_OP_TYPE_JMP },
	{ "call", LONGMEM_23, 0, 3, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_X, LONGMEM_23, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", LONGMEM_23, STM8_REG_X, 3, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_Y, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ld", LONGOFF_X_23, STM8_REG_A, 3, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_ADD },
	{ "jp", LONGOFF_X_23, 0, 3, R_ANAL_OP_TYPE_JMP },
	{ "call", LONGOFF_X_23, 0, 3, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_X, LONGOFF_X_23, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", LONGOFF_X_23, STM8_REG_Y, 3, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_Y, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ld", SHORTOFF_X_2, STM8_REG_A, 2, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_ADD },
	{ "jp", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_JMP },
	{ "call", SHORTOFF_X_2, 0, 2, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_X, SHORTOFF_X_2, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTOFF_X_2, STM8_REG_Y, 2, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_Y, STM8_PTR_X, 1, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_LOAD },
	{ "ld", STM8_PTR_X, STM8_REG_A, 1, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, STM8_PTR_X, 1, R_ANAL_OP_TYPE_ADD },
	{ "jp", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_JMP },
	{ "call", STM8_PTR_X, 0, 1, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_X, STM8_PTR_X, 1, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", STM8_PTR_X, STM8_REG_Y, 1, R_ANAL_OP_TYPE_LOAD}
};

static const instruction ins_table_72[]={
	{ "btjt", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjf", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjt", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjf", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjt", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjf", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjt", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjf", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjt", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjf", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjt", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjf", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjt", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjf", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjt", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "btjf", LONGMEM_BIT_123, SHORTOFF_4, 5, R_ANAL_OP_TYPE_CJMP },
	{ "bset", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bres", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bset", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bres", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bset", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bres", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bset", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bres", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bset", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bres", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bset", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bres", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bset", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bres", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bset", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "bres", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "neg", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpl", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "sra", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_SAR },
	{ "void", 0, 0, 0 },
	{ "rrc", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_ROR },
	{ "sra", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_SHR },
	{ "sll", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_SHL },
	{ "rlc", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_ROL },
	{ "dec", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_ADD },
	{ "tnz", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "swap", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "clr", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "neg", LONGOFF_X_23, 0, 4, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpl", LONGOFF_X_23, 0, 4 },
	{ "sra", LONGOFF_X_23, 0, 4 },
	{ "void", 0, 0, 0 },
	{ "rrc", LONGOFF_X_23, 0, 4, R_ANAL_OP_TYPE_ROR },
	{ "sra", LONGOFF_X_23, 0, 4, R_ANAL_OP_TYPE_SHR },
	{ "sll", LONGOFF_X_23, 0, 4, R_ANAL_OP_TYPE_SHL },
	{ "rlc", LONGOFF_X_23, 0, 4, R_ANAL_OP_TYPE_ROL },
	{ "dec", LONGOFF_X_23, 0, 4 },
	{ "void", 0, 0, 0 },
	{ "inc", LONGOFF_X_23, 0, 4, R_ANAL_OP_TYPE_ADD },
	{ "tnz", LONGOFF_X_23, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "swap", LONGOFF_X_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "clr", LONGOFF_X_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "neg", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpl", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "sra", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_SHR },
	{ "void", 0, 0, 0 },
	{ "rrc", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_ROR },
	{ "sra", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_SHR },
	{ "sll", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_SHL },
	{ "rlc", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_ROL },
	{ "dec", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_ADD },
	{ "tnz", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "swap", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "clr", LONGMEM_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "neg", LONGPTR_OFF_X_23, 0, 4 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpl", LONGPTR_OFF_X_23, 0, 4 },
	{ "sra", LONGPTR_OFF_X_23, 0, 4 },
	{ "void", 0, 0, 0 },
	{ "rrc", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_ROR },
	{ "sra", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_SAR },
	{ "sll", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_SHL },
	{ "rlc", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_ROL },
	{ "dec", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_ADD },
	{ "tnz", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "swap", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "clr", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "wfe", 0, 0, 2 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "subw", STM8_REG_Y, STM8_IMM_WORD_23, 4, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "addw", STM8_REG_Y, STM8_IMM_WORD_23, 4, R_ANAL_OP_TYPE_ADD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "subw", STM8_REG_X, LONGMEM_23, 4, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "subw", STM8_REG_Y, LONGMEM_23, 4, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "addw", STM8_REG_Y, LONGMEM_23, 4, R_ANAL_OP_TYPE_ADD },
	{ "void", 0, 0, 0 },
	{ "addw", STM8_REG_X, LONGMEM_23, 4, R_ANAL_OP_TYPE_ADD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "sub", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, LONGPTR_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ld", LONGPTR_23, STM8_REG_A, 4, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_ADD },
	{ "jp", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_JMP },
	{ "call", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_X, LONGPTR_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", LONGPTR_23, STM8_REG_X, 4, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_Y, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ld", LONGPTR_OFF_X_23, STM8_REG_A, 4, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_ADD },
	{ "jp", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_JMP },
	{ "call", LONGPTR_OFF_X_23, 0, 4, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_X, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", LONGPTR_OFF_X_23, STM8_REG_Y, 4, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "subw", STM8_REG_X, SHORTOFF_SP_2, 3 },
	{ "subw", STM8_REG_Y, SHORTOFF_SP_2, 3 },
	{ "addw", STM8_REG_Y, SHORTOFF_SP_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "addw", STM8_REG_X, SHORTOFF_SP_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "subw", STM8_REG_X, SHORTOFF_SP_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "subw", STM8_REG_Y, SHORTOFF_SP_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "addw", STM8_REG_Y, SHORTOFF_SP_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "void", 0, 0, 0 },
	{ "addw", STM8_REG_X, SHORTOFF_SP_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0}
};

static const instruction ins_table_90[]={
	{ "void", 0, 0, 0 },
	{ "rrwa", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_ROR },
	{ "rlwa", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_ROL },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "bcpl", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bccm", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bcpl", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bccm", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bcpl", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bccm", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bcpl", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bccm", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bcpl", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bccm", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bcpl", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bccm", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bcpl", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bccm", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bcpl", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "bccm", LONGMEM_BIT_123, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "jrnh", SHORTOFF_2, 0, 3, R_ANAL_OP_TYPE_CJMP },
	{ "jrh", SHORTOFF_2, 0, 3, R_ANAL_OP_TYPE_CJMP },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "jrnm", SHORTOFF_2, 0, 3, R_ANAL_OP_TYPE_CJMP },
	{ "jrm", SHORTOFF_2, 0, 3, R_ANAL_OP_TYPE_CJMP },
	{ "jril", SHORTOFF_2, 0, 3, R_ANAL_OP_TYPE_CJMP },
	{ "jrih", SHORTOFF_2, 0, 3, R_ANAL_OP_TYPE_CJMP },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "neg", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "mul", STM8_REG_Y, STM8_REG_A, 2, R_ANAL_OP_TYPE_MUL },
	{ "cpl", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "sra", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_SHR },
	{ "void", 0, 0, 0 },
	{ "rrc", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_ROR },
	{ "sra", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_SHR },
	{ "sll", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_SHL },
	{ "rlc", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_ROL },
	{ "dec", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_ADD },
	{ "tnz", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_CMP },
	{ "swap", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "clr", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_MOV },
	{ "negw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cplw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "srlw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_SHR },
	{ "void", 0, 0, 0 },
	{ "rrcw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_ROR },
	{ "sraw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_SAR },
	{ "sllw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_SAL}, // R_ANALOP_TYPE_CORTEX },
	{ "rlcw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_ROL },
	{ "decw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "incw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_ADD },
	{ "tnzw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "swapw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_MOV },
	{ "clrw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_MOV },
	{ "neg", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "div", STM8_REG_Y, STM8_REG_A, 2, R_ANAL_OP_TYPE_DIV },
	{ "cpl", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_CMP },
	{ "sra", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_SHR },
	{ "void", 0, 0, 0 },
	{ "rrc", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_ROR },
	{ "sra", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_SHR },
	{ "sll", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_SHL },
	{ "rlc", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_ROL },
	{ "dec", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_ADD },
	{ "tnz", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_CMP },
	{ "swap", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_MOV },
	{ "clr", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_MOV },
	{ "neg", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpl", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "sra", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_SHR },
	{ "void", 0, 0, 0 },
	{ "rrc", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_ROR },
	{ "sra", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_SAR },
	{ "sll", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_SHL },
	{ "rlc", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_ROL },
	{ "dec", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_ADD },
	{ "tnz", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_CMP },
	{ "swap", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_MOV },
	{ "clr", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_MOV },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "popw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_POP },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "pushw", STM8_REG_Y, 0, 2, R_ANAL_OP_TYPE_PUSH },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldw", STM8_REG_Y, STM8_REG_X, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", STM8_REG_SP, STM8_REG_Y, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ld", STM8_REG_YH, STM8_REG_A, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", STM8_REG_Y, STM8_REG_SP, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ld", STM8_REG_YL, STM8_REG_A, 2, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ld", STM8_REG_A, STM8_REG_YH, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ld", STM8_REG_A, STM8_REG_YL, 2, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpw", STM8_REG_Y, STM8_IMM_WORD_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldf", EXTOFF_Y_234, STM8_REG_A, 5, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldw", STM8_REG_Y, STM8_IMM_WORD_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ldf", STM8_REG_A, EXTOFF_Y_234, 5, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpw", STM8_REG_Y, SHORTMEM_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldw", STM8_REG_Y, SHORTMEM_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTMEM_2, STM8_REG_Y, 3, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpw", STM8_REG_Y, LONGMEM_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldw", STM8_REG_Y, LONGMEM_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", LONGMEM_23, STM8_REG_Y, 4, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ld", LONGOFF_Y_23, STM8_REG_A, 4, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_ADD },
	{ "jp", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_JMP },
	{ "call", LONGOFF_Y_23, 0, 4, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_Y, LONGOFF_Y_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", LONGOFF_Y_23, STM8_REG_X, 4, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ld", SHORTOFF_Y_2, STM8_REG_A, 3, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "jp", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_JMP },
	{ "call", SHORTOFF_Y_2, 0, 3, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_Y, SHORTOFF_Y_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTOFF_Y_2, STM8_REG_X, 3, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ld", STM8_PTR_Y, STM8_REG_A, 2, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_ADD },
	{ "jp", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_JMP },
	{ "call", STM8_PTR_Y, 0, 2, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_Y, STM8_PTR_Y, 2, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", STM8_PTR_Y, STM8_REG_X, 2, R_ANAL_OP_TYPE_LOAD}
};

/*
 * Instructions 0x91 modifier, OC1=0x60:0xDF
 */
static const instruction ins_table_91_0x60[]={
	{ "neg", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpl", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_CMP },
	{ "sra", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_SHR },
	{ "void", 0, 0, 0 },
	{ "rrc", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_ROR },
	{ "sra", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_SHR },
	{ "sll", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_SHL },
	{ "rlc", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_ROL },
	{ "dec", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_ADD },
	{ "tnz", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_CMP },
	{ "swap", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_MOV },
	{ "clr", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_MOV },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldf", LONGPTR_OFF_Y_23, STM8_REG_A, 4, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldf", STM8_REG_A, LONGPTR_OFF_Y_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpw", STM8_REG_Y, SHORTPTR_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldw", STM8_REG_Y, SHORTPTR_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTPTR_2, STM8_REG_Y, 3, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ld", SHORTPTR_OFF_Y_2, STM8_REG_A, 3, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "jp", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_JMP },
	{ "call", SHORTPTR_OFF_Y_2, 0, 3, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_Y, SHORTPTR_OFF_Y_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTPTR_OFF_Y_2, STM8_REG_X, 3, R_ANAL_OP_TYPE_LOAD}
};

/*
 * Instructions 0x92 modifier, OC1=0x30:0xDF
 */
static const instruction ins_table_92_0x30[]={
	{ "neg", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpl", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_CMP },
	{ "sra", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_SAR },
	{ "void", 0, 0, 0 },
	{ "rrc", SHORTPTR_2, 0, 3 },
	{ "sra", SHORTPTR_2, 0, 3 },
	{ "sll", SHORTPTR_2, 0, 3 },
	{ "rlc", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_ROL },
	{ "dec", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_ADD },
	{ "tnz", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_CMP },
	{ "swap", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_MOV },
	{ "clr", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_MOV },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "neg", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_NOT },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "cpl", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_CMP },
	{ "sra", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_SHR },
	{ "void", 0, 0, 0 },
	{ "rrc", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_ROR },
	{ "sra", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_SAR },
	{ "sll", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_SHL },
	{ "rlc", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_ROL },
	{ "dec", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_SUB },
	{ "void", 0, 0, 0 },
	{ "inc", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_ADD },
	{ "tnz", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_CMP },
	{ "swap", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_MOV },
	{ "clr", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_MOV },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "callf", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_CALL },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldf", LONGPTR_OFF_X_23, STM8_REG_A, 4, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "jpf", LONGPTR_23, 0, 4, R_ANAL_OP_TYPE_JMP },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldf", STM8_REG_A, LONGPTR_OFF_X_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "ldf", STM8_REG_A, LONGPTR_23, 4, R_ANAL_OP_TYPE_LOAD },
	{ "ldf", LONGPTR_23, STM8_REG_A, 4, R_ANAL_OP_TYPE_LOAD },
	{ "void", 0, 0, 0 },
	{ "void", 0, 0, 0 },
	{ "sub", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_X, SHORTPTR_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ld", SHORTPTR_2, STM8_REG_A, 3, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, SHORTPTR_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "jp", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_JMP },
	{ "call", SHORTPTR_2, 0, 3, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_X, SHORTPTR_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTPTR_2, STM8_REG_X, 3, R_ANAL_OP_TYPE_LOAD },
	{ "sub", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "cp", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "sbc", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_SUB },
	{ "cpw", STM8_REG_Y, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "and", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_AND },
	{ "bcp", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_CMP },
	{ "ld", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ld", SHORTPTR_OFF_X_2, STM8_REG_A, 3, R_ANAL_OP_TYPE_LOAD },
	{ "xor", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_XOR },
	{ "adc", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "or", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_OR },
	{ "add", STM8_REG_A, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_ADD },
	{ "jp", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_JMP },
	{ "call", SHORTPTR_OFF_X_2, 0, 3, R_ANAL_OP_TYPE_CALL },
	{ "ldw", STM8_REG_X, SHORTPTR_OFF_X_2, 3, R_ANAL_OP_TYPE_LOAD },
	{ "ldw", SHORTPTR_OFF_X_2, STM8_REG_Y, 3, R_ANAL_OP_TYPE_LOAD}
};
