# Announce: Rakudo Perl 6 compiler, Release #129 (2018.12)

On behalf of the Rakudo development team, I’m very happy to announce the
December 2018 release of Rakudo Perl 6 #129. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements 6.c and 6.d versions of the Perl 6 specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2019 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

The tarball for this release is available from <https://rakudo.org/files/rakudo>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<https://rakudo.org/files/star>.

The changes in this release are outlined below:

New in 2018.12:
  + Fixes:
    + Fixed infiniloops with some set operators [99d94db4][9f5cc8d1]
    + Fixed regression in handling of `"1"..9` [d92b155c]
    + Fixed use of `Proxy` in a class attribute using
        the `Attribute`.`get_value`/`set_value` interface [a5411e45]
    + Fixed semantics of `minpairs`/`maxpairs` (ignore undefined values) [7bf7a2c6]
    + Fixed error on `@a > 2` if `@a` is a native array
    + Fixed error reporting on initializing shaped array with
        improperly shaped data [fd216fec]
    + Negative indexes on native arrays are now checked properly [dd2af90c]
    + Fixed use of uninitialized value in `IO::Notification` [83d0056b]
    + Enums can now have private methods mixed in [3c2cfb22]
    + Fixed resource content lookup for `Distribution::Path` [370310b3]
    + Fixed precompilation when cwd gets changed at run time [e2e5cc53]
    + Shared library versions are now ignored on OpenBSD [5603128e]
    + Many improvements to the JS backend [1865db0d][fdd249a3][194c84b9]
        [1dd59f10][52c2af5d][8b13655c][2869a48b][cf5432ae][758caa89]
        [e0b943d0][a759f9d7]
    + Various improvements to produced messages [869b9e58][abfb9a40]
        [79824db5][55d08c8f][24c8e172]
  + Additions:
    + Added `Endian` enum and implemented new methods in `blob8`/`buf8`
        for reading/writing native values [46d4c9fe][011c6f11][f66861dc]
        [f0279313][b781f8cc][543219c9][77182713][06156a7c]
    + Added `Kernel.endian` [2a761ca7][af43b159]
    + Implemented `Blob.readint` / `Buf.writeint` [4f14d713][fecfb22d]
        [5cc0e02d][79dd1c8e][ceaf7218][631940c7][38afa2d6][e7b61aff]
    + Added `.native-descriptor` for async sockets [a4db9139][2fd90b1e]
    + Added `.Real` method to native arrays [dd3f91a2]
    + Implemented `last` and `LAST` in `whenever` blocks [890d628a]
  + Efficiency:
    + Made `<$rx>` interpolation 1.05x as fast [62243cd9]
    + Made simple regex matches 1.05x as fast [01c56b48]
    + Other minor optimizations [93ea7ed1][a0cb89a7][adb85609][6c2f3c83]
  + Internal:
    + Introduced a more generally usable `X::ArrayShapeMismatch` error [dd030145]
    + Internal micro-optimizations [38bc682b][f18432ea]


The following people contributed to this release:

Paweł Murias, Elizabeth Mattijsen, Aleks-Daniel Jakimenko-Aleksejev,
Stefan Seifert, Jonathan Worthington, Ben Davies, Petr Rockai, Nick Logan,
Samantha McVey, Timo Paulssen, Momo

If you would like to contribute or find out more information, visit
<https://perl6.org>, <https://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#130), is tentatively scheduled for 2019-01-19.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
